/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

public class LatLongToPoint {
    private static double re = 6378.14;
    private static double rp = 6356.755;
    public static double PIBy2 = 1.5707963267948966;
    public static double twoPI = Math.PI * 2;

    public static Point3d plotPoint(Point3d p) {
        double[] temp = new double[3];
        p.get(temp);
        return LatLongToPoint.plotPoint(temp[0], temp[1], temp[2]);
    }

    public static Point3d plotPoint(double latitude, double longitude, double altitude) {
        double radiusAtPoint = LatLongToPoint.calcRadius(latitude) + altitude;
        double Theta = LatLongToPoint.deg2rad(longitude);
        double Phi = LatLongToPoint.deg2rad(latitude);
        double rCosPhi = radiusAtPoint * Math.cos(PIBy2 - Phi);
        double rSinPhi = radiusAtPoint * Math.sin(PIBy2 - Phi);
        return new Point3d(rSinPhi * Math.cos(Theta *= -1.0), rCosPhi, rSinPhi * Math.sin(Theta));
    }

    public static Point3d plotPoint(double latitude, double longitude) {
        double radiusAtPoint = LatLongToPoint.calcRadius(latitude);
        double Theta = LatLongToPoint.deg2rad(longitude);
        double Phi = LatLongToPoint.deg2rad(latitude);
        double rCosPhi = radiusAtPoint * Math.cos(PIBy2 - Phi);
        double rSinPhi = radiusAtPoint * Math.sin(PIBy2 - Phi);
        return new Point3d(rSinPhi * Math.cos(Theta *= -1.0), rCosPhi, rSinPhi * Math.sin(Theta));
    }

    public static Point3f plotPoint3f(double latitude, double longitude, double altitude) {
        Point3d pt = LatLongToPoint.plotPoint(latitude, longitude, altitude);
        return new Point3f((float)pt.x, (float)pt.y, (float)pt.z);
    }

    public Point3f plotPoint3f(double latitude, double longitude) {
        Point3d pt = LatLongToPoint.plotPoint(latitude, longitude);
        return new Point3f((float)pt.x, (float)pt.y, (float)pt.z);
    }

    public static Vector3d plotSphere(double latitude, double longitude, double altitude) {
        double radiusAtPoint = LatLongToPoint.calcRadius(latitude) + altitude;
        double Theta = LatLongToPoint.deg2rad(longitude);
        double Phi = LatLongToPoint.deg2rad(latitude);
        double rCosPhi = radiusAtPoint * Math.cos(PIBy2 - Phi);
        double rSinPhi = radiusAtPoint * Math.sin(PIBy2 - Phi);
        return new Vector3d(rSinPhi * Math.cos(Theta *= -1.0), rCosPhi, rSinPhi * Math.sin(Theta));
    }

    public static double calcRadius(double lat) {
        double radius = re * Math.pow(1.0 + (re * re - rp * rp) / (rp * rp) * (Math.sin(LatLongToPoint.deg2rad(lat)) * Math.sin(LatLongToPoint.deg2rad(lat))), -0.5);
        return radius;
    }

    public static double deg2rad(double degree) {
        return degree * twoPI / 360.0;
    }
}

