/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public class PointToLatLong {
    private static double re = 6378.14;
    private static double rp = 6356.755;
    public static double PIBy2 = 1.5707963267948966;
    public static double twoPI = Math.PI * 2;
    private static double phi;
    private static double rho;
    private static double theta;
    private static double s;
    private static double latitude;
    private static double longitude;
    private static double altitude;

    public static double PointToLat(Point3d point) {
        rho = Math.sqrt(point.x * point.x + point.y * point.y + point.z * point.z);
        phi = Math.asin(point.y / rho);
        latitude = PointToLatLong.rad2deg(phi);
        return latitude;
    }

    public static double PointToLong(Point3d point) {
        s = Math.sqrt(point.x * point.x + point.z * point.z);
        theta = point.x >= 0.0 ? Math.asin(point.z / s) : Math.PI - Math.asin(point.z / s);
        longitude = PointToLatLong.rad2deg(theta);
        if (longitude < -180.0) {
            longitude += 360.0;
        }
        if (longitude > 180.0) {
            longitude -= 360.0;
        }
        return longitude;
    }

    public static double PointToAltitude(Point3d point) {
        latitude = PointToLatLong.PointToLat(point);
        rho = Math.sqrt(point.x * point.x + point.y * point.y + point.z * point.z);
        altitude = rho - PointToLatLong.calcRadius(latitude);
        return altitude;
    }

    public static double PointToLat(Point3f point) {
        Point3d doublept = new Point3d((double)point.x, (double)point.y, (double)point.z);
        return PointToLatLong.PointToLat(doublept);
    }

    public static double PointToLong(Point3f point) {
        Point3d doublept = new Point3d((double)point.x, (double)point.y, (double)point.z);
        return PointToLatLong.PointToLong(doublept);
    }

    public static double PointToAltitude(Point3f point) {
        Point3d doublept = new Point3d((double)point.x, (double)point.y, (double)point.z);
        return PointToLatLong.PointToAltitude(doublept);
    }

    public static double calcRadius(double lat) {
        double radius = re * Math.pow(1.0 + (re * re - rp * rp) / (rp * rp) * (Math.sin(PointToLatLong.deg2rad(lat)) * Math.sin(PointToLatLong.deg2rad(lat))), -0.5);
        return radius;
    }

    public static double rad2deg(double radian) {
        return 360.0 * radian / twoPI;
    }

    public static double deg2rad(double degree) {
        return degree * twoPI / 360.0;
    }
}

