/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import junit.framework.TestCase;
import org.scec.geo3d.tools.LatLongToPoint;
import org.scec.geo3d.tools.PointToLatLong;

public class PointToLatLongTest
extends TestCase {
    public void testDouble() {
        Point3d point = new Point3d(1.0, 1.0, 1.0);
        double latitude = PointToLatLong.PointToLat(point);
        double longitude = PointToLatLong.PointToLong(point);
        double depth = PointToLatLong.PointToAltitude(point);
        Point3d testpoint = LatLongToPoint.plotPoint(latitude, longitude, depth);
        PointToLatLongTest.assertEquals((double)point.x, (double)testpoint.x, (double)1.0E-5);
        PointToLatLongTest.assertEquals((double)point.y, (double)testpoint.y, (double)1.0E-5);
        PointToLatLongTest.assertEquals((double)point.z, (double)Math.abs(testpoint.z), (double)1.0E-5);
    }

    public void testFloat() {
        Point3f point = new Point3f(1.0f, 1.0f, 1.0f);
        double latitude = PointToLatLong.PointToLat(point);
        double longitude = PointToLatLong.PointToLong(point);
        double depth = PointToLatLong.PointToAltitude(point);
        Point3d testpoint = LatLongToPoint.plotPoint(latitude, longitude, depth);
        PointToLatLongTest.assertEquals((double)point.x, (double)testpoint.x, (double)1.0E-5);
        PointToLatLongTest.assertEquals((double)point.y, (double)testpoint.y, (double)1.0E-5);
        PointToLatLongTest.assertEquals((double)point.z, (double)Math.abs(testpoint.z), (double)1.0E-5);
    }
}

