/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.util.prefs.Preferences;

public class Prefs {
    public static final Color DEFAULT_MATERIAL_AMBIENT = new Color(0.2f, 0.2f, 0.2f);
    public static final Color DEFAULT_MATERIAL_EMISSIVE = new Color(0.0f, 0.0f, 0.0f);
    public static final Color DEFAULT_MATERIAL_DIFFUSE = new Color(0.8f, 0.8f, 0.8f);
    public static final Color DEFAULT_MATERIAL_SPECULAR = new Color(0.0f, 0.0f, 0.0f);
    public static final float DEFAULT_MATERIAL_SHININESS = 50.0f;
    private static Preferences prefs;
    private static String defaultLibLocation;
    private static int defaultStriping_r;
    private static int defaultStriping_g;
    private static int defaultStriping_b;
    private static int defaultPluginWidth;
    private static int defaultPluginHeight;
    private static int os;
    private static int platformActionKey;
    private static String platformFileSeparator;
    private static Insets platformIconInset;
    public static final int OSX = 1;
    public static final int WINDOWS = 2;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.tools.Prefs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prefs = Preferences.userNodeForPackage(clazz);
        defaultStriping_r = 240;
        defaultStriping_g = 240;
        defaultStriping_b = 255;
        defaultPluginWidth = 400;
        defaultPluginHeight = 600;
    }

    public static void init() {
        String system = System.getProperty("os.name");
        if (system.equals("Mac OS X")) {
            os = 1;
        } else if (system.indexOf("Windows") != -1) {
            os = 2;
        }
        platformActionKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        platformFileSeparator = File.separator;
        platformIconInset = os == 1 ? new Insets(3, 4, 3, 4) : new Insets(3, 4, 2, 3);
        defaultLibLocation = System.getProperty("user.home");
        defaultLibLocation = String.valueOf(defaultLibLocation) + platformFileSeparator + "ScecVideo";
    }

    public static void setPluginWidth(int width) {
        prefs.putInt("PLUGIN_WIDTH", width);
    }

    public static int getPluginWidth() {
        return prefs.getInt("PLUGIN_WIDTH", defaultPluginWidth);
    }

    public static void setPluginHeight(int height) {
        prefs.putInt("PLUGIN_HEIGHT", height);
    }

    public static int getPluginHeight() {
        return prefs.getInt("PLUGIN_HEIGHT", defaultPluginHeight);
    }

    public static void setLibLoc(String location) {
        prefs.put("LIB", location);
    }

    public static String getLibLoc() {
        return prefs.get("LIB", defaultLibLocation);
    }

    public static void setStripingColor(Color color) {
        prefs.putInt("STRIPE_COLOR_R", color.getRed());
        prefs.putInt("STRIPE_COLOR_G", color.getGreen());
        prefs.putInt("STRIPE_COLOR_B", color.getBlue());
    }

    public static Color getStripingColor() {
        int r = prefs.getInt("STRIPE_COLOR_R", defaultStriping_r);
        int g = prefs.getInt("STRIPE_COLOR_G", defaultStriping_g);
        int b = prefs.getInt("STRIPE_COLOR_B", defaultStriping_b);
        Color c = new Color(r, g, b);
        return c;
    }

    public static void moveLib() {
    }

    public static int getOS() {
        return os;
    }

    public static int getActionKey() {
        return platformActionKey;
    }

    public static String getFS() {
        return platformFileSeparator;
    }

    public static Insets getIconInset() {
        return platformIconInset;
    }
}

