/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.plugin;

import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.View;
import javax.swing.JDesktopPane;
import org.scec.geo3d.gui.MainWindow;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.gui.viewer.RenderEnabledCanvas3D;
import org.scec.geo3d.plugins.Plugin;

public class Geo3dInfo {
    private static GlobeView activeViewer;
    private static ViewingPlatform viewPlat;
    private static MainWindow mainWind;
    private static JDesktopPane desktop;
    private static Rectangle activeSize;
    private static BranchGroup pluginBranchGroup;
    private static ArrayList surfaces;
    private static ArrayList earthquakes;
    public static final Integer DOCLAYER;
    public static final Integer TOPLAYER;

    static {
        surfaces = new ArrayList();
        earthquakes = new ArrayList();
        DOCLAYER = new Integer(5);
        TOPLAYER = new Integer(10);
    }

    public static void setMainWindow(MainWindow mw) {
        mainWind = mw;
    }

    public static void setDesktop(JDesktopPane dp) {
        desktop = dp;
    }

    public static void setActiveViewer(GlobeView gv) {
        activeViewer = gv;
    }

    public static void setViewingPlatform(ViewingPlatform vp) {
        viewPlat = vp;
    }

    public static void setPluginBranchGroup(BranchGroup bg) {
        pluginBranchGroup = bg;
    }

    public static GlobeView getActiveViewer() {
        return activeViewer;
    }

    public static ViewingPlatform getViewingPlatform() {
        return viewPlat;
    }

    public static Canvas3D getCanvas() {
        return Geo3dInfo.getViewingPlatform().getUniverse().getCanvas();
    }

    public static RenderEnabledCanvas3D getRenderEnabledCanvas() {
        return (RenderEnabledCanvas3D)Geo3dInfo.getViewingPlatform().getUniverse().getCanvas();
    }

    public static View getView() {
        Viewer[] ViewerList = Geo3dInfo.getViewingPlatform().getViewers();
        return ViewerList[0].getView();
    }

    public static JDesktopPane getDesktop() {
        return desktop;
    }

    public static Rectangle getActiveSize() {
        return activeViewer.getBounds();
    }

    public static BranchGroup getPluginBranchGroup() {
        return pluginBranchGroup;
    }

    public static void setEarthquakes(ArrayList eq) {
        earthquakes = eq;
    }

    public static ArrayList getEarthquakes() {
        return earthquakes;
    }

    public static void update(Plugin p) {
        if (activeViewer != null) {
            activeViewer.update(p);
        }
    }

    public static File getCWD() {
        return new File(System.getProperty("user.dir"));
    }
}

