/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.scec.geo3d.plugins.Plugin;
import org.scec.geo3d.tools.plugin.PluginHandler;
import org.scec.geo3d.tools.plugin.PluginLoader;

public class PluginHandlerImpl
implements PluginHandler {
    protected String PLUGIN_DIRECTORY = "lib/plugins/";
    private int numPlugins;
    private int numAllPlugins;
    private Plugin[] plugins;
    private Plugin[] pluginsTurnedOn;
    protected String[] classNames;
    private String[] directoryFileNames;
    protected String[] jarFileNames;
    private ArrayList listOfClasses;
    private ArrayList listOfFileNames;
    private boolean loaded = false;
    private static PluginHandlerImpl singleton = null;

    protected PluginHandlerImpl() {
    }

    public static PluginHandlerImpl getInstance() {
        singleton = new PluginHandlerImpl();
        return singleton;
    }

    public static PluginHandlerImpl getLastInstance() {
        singleton = new PluginHandlerImpl();
        singleton.loadPlugins();
        return singleton;
    }

    public void loadPlugins() {
        if (!this.loaded) {
            this.retrievePluginDirectory();
            this.getJARFileList();
            this.instantiatePlugins();
            this.loadPrefs();
            this.loaded = true;
        }
    }

    protected void instantiatePlugins() {
        this.plugins = new Plugin[this.numAllPlugins];
        System.out.println(this.numAllPlugins);
        int i = 0;
        while (i < this.numAllPlugins) {
            Plugin plugin;
            PluginLoader pLoader;
            try {
                pLoader = new PluginLoader(String.valueOf(this.PLUGIN_DIRECTORY) + this.jarFileNames[i]);
            }
            catch (Exception e) {
                System.out.println("Can't load file " + this.jarFileNames[i] + ".");
                break;
            }
            try {
                plugin = (Plugin)pLoader.importClass(this.classNames[i]).newInstance();
            }
            catch (Exception e) {
                System.out.println("Can't load class " + this.classNames[i] + ".  Exception " + e + ".");
                break;
            }
            if (plugin != null) {
                this.plugins[i] = plugin;
            }
            ++i;
        }
    }

    protected void retrievePluginDirectory() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("JavaSource/org/scec/geo3d/tools/plugin/plugin_properties"));
            String line = br.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                String token = tokenizer.nextToken();
                if (token.equals("directory:")) {
                    this.PLUGIN_DIRECTORY = token = tokenizer.nextToken();
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadPrefs() {
        ArrayList<String> pluginsToLoadList = new ArrayList<String>();
        int i = 0;
        while (i < this.numAllPlugins) {
            pluginsToLoadList.add(this.plugins[i].getMetadata().getName());
            ++i;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader("conf/preferences.pref"));
            String dataLine = reader.readLine();
            while (dataLine != null) {
                StringTokenizer tokenizer = new StringTokenizer(dataLine);
                String pluginName = tokenizer.nextToken();
                String continuation = tokenizer.nextToken();
                while (!continuation.equals("true") && !continuation.equals("false")) {
                    pluginName = String.valueOf(pluginName) + " " + continuation;
                    continuation = tokenizer.nextToken();
                }
                if (continuation.equals("false")) {
                    pluginsToLoadList.remove(pluginName);
                }
                dataLine = reader.readLine();
            }
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex);
            this.numPlugins = this.numAllPlugins;
            this.pluginsTurnedOn = this.plugins;
            return;
        }
        this.numPlugins = pluginsToLoadList.size();
        this.pluginsTurnedOn = new Plugin[this.numPlugins];
        i = 0;
        while (i < this.numPlugins) {
            String name = (String)pluginsToLoadList.get(i);
            int j = 0;
            while (j < this.numAllPlugins) {
                if (name.equals(this.plugins[j].getMetadata().getName())) {
                    this.pluginsTurnedOn[i] = this.plugins[j];
                }
                ++j;
            }
            ++i;
        }
    }

    protected void getJARFileList() {
        this.listOfClasses = new ArrayList();
        this.listOfFileNames = new ArrayList();
        this.numAllPlugins = 0;
        File pluginDirectory = new File(this.PLUGIN_DIRECTORY);
        this.directoryFileNames = pluginDirectory.list();
        if (this.directoryFileNames != null) {
            int i = 0;
            while (i < this.directoryFileNames.length) {
                int index = this.directoryFileNames[i].indexOf(".jar");
                if (index != -1) {
                    System.out.println(this.directoryFileNames[i]);
                    this.listOfClasses.add(new String(this.directoryFileNames[i].substring(0, index)));
                    this.listOfFileNames.add(this.directoryFileNames[i]);
                    ++this.numAllPlugins;
                }
                ++i;
            }
            this.jarFileNames = new String[this.numAllPlugins];
            this.classNames = new String[this.numAllPlugins];
            i = 0;
            while (i < this.numAllPlugins) {
                this.classNames[i] = (String)this.listOfClasses.get(i);
                this.jarFileNames[i] = (String)this.listOfFileNames.get(i);
                ++i;
            }
        } else {
            System.out.println(pluginDirectory + " cannot be found.");
        }
    }

    public int getNumPlugins() {
        return this.numPlugins;
    }

    public int getNumAllPlugins() {
        return this.numAllPlugins;
    }

    public void setPluginDirectory(String dir) {
        this.PLUGIN_DIRECTORY = dir;
    }

    public Plugin[] getPlugins() {
        return this.pluginsTurnedOn;
    }

    public Plugin[] getAllPlugins() {
        return this.plugins;
    }
}

