/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.plugin;

import junit.framework.TestCase;
import org.scec.geo3d.plugins.Plugin;
import org.scec.geo3d.tools.plugin.PluginHandlerImpl;

public class PluginHandlerTest
extends TestCase {
    private String oldPath;
    private String newPath = "directory: Test/org/scec/geo3d/tools/plugin/";
    private PluginHandlerImpl handler;

    public void setUp() throws Exception {
        super.setUp();
        this.handler = PluginHandlerImpl.getInstance();
    }

    public void testReadingDirectory() throws Exception {
        this.handler.retrievePluginDirectory();
        PluginHandlerTest.assertTrue((boolean)this.handler.PLUGIN_DIRECTORY.equals("lib/plugins/"));
    }

    public void testReadingJars() throws Exception {
        this.handler.setPluginDirectory("Test/org/scec/geo3d/tools/plugin/");
        this.handler.getJARFileList();
        String[] jars = this.handler.jarFileNames;
        String[] classes = this.handler.classNames;
        PluginHandlerTest.assertEquals((int)jars.length, (int)1);
        PluginHandlerTest.assertEquals((int)classes.length, (int)1);
        PluginHandlerTest.assertEquals((String)jars[0], (String)"DummyJar.jar");
        PluginHandlerTest.assertEquals((String)classes[0], (String)"DummyJar");
    }

    public void testInstantiatingPlugins() throws Exception {
        this.handler.setPluginDirectory("Test/org/scec/geo3d/tools/plugin/");
        this.handler.getJARFileList();
        this.handler.instantiatePlugins();
        Plugin[] plugins = this.handler.getAllPlugins();
        PluginHandlerTest.assertEquals((int)plugins.length, (int)1);
        PluginHandlerTest.assertEquals((String)plugins[0].getMetadata().getName(), (String)"DummyJar");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

