/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginLoader
extends URLClassLoader {
    private File jarFile;

    public PluginLoader(String path) throws MalformedURLException {
        super(new URL[]{new File(path).toURL()});
        this.jarFile = new File(path);
    }

    public Class importClass(String className) throws ClassNotFoundException {
        String fullClassName = this.getClassName(className);
        if (fullClassName == "") {
            System.err.println("Expected class " + className + " not found in " + this.jarFile);
        }
        return super.loadClass(fullClassName);
    }

    private String getClassName(String className) {
        String entryName = "";
        int index = -1;
        try {
            JarFile jf = new JarFile(this.jarFile);
            Enumeration<JarEntry> e = jf.entries();
            String fileToSearchFor = "/" + className + ".class";
            while (index == -1) {
                entryName = e.nextElement().getName();
                index = entryName.indexOf(fileToSearchFor);
            }
            if (index == -1) {
                return "";
            }
            index = entryName.indexOf(".class");
            entryName = entryName.substring(0, index);
            entryName = entryName.replace('/', '.');
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " for file " + this.jarFile);
        }
        return entryName;
    }
}

