/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.stateVector;

import com.sun.j3d.utils.universe.MultiTransformGroup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scec.geo3d.gui.MainWindow;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.tools.exceptions.StateVectorException;

public class StateVector {
    private static Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.scec.geo3d.tools.stateVector.StateVector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void saveState(GlobeView geo3d, File stateVectorFile) throws StateVectorException {
        ArrayList menuStates = geo3d.getMenuStates();
        HashMap pluginStates = geo3d.getPluginStates();
        MultiTransformGroup mtg = geo3d.getMultiTransform();
        Element root = new Element("StateVector");
        Document saveState = new Document(root);
        Element viewRange = this.saveViewRange(geo3d.getViewRange());
        root.addContent((Content)viewRange);
        Element transforms = new Element("ViewTransforms");
        int i = 0;
        while (i < mtg.getNumTransforms()) {
            TransformGroup tg = mtg.getTransformGroup(i);
            Element itertrans = new Element("Transform");
            Transform3D trans = new Transform3D();
            tg.getTransform(trans);
            double[] tranlist = new double[16];
            trans.get(tranlist);
            int j = 0;
            while (j < 16) {
                Element dim = new Element("Dimension" + j);
                dim.setText(Double.toString(tranlist[j]));
                itertrans.addContent((Content)dim);
                ++j;
            }
            transforms.addContent((Content)itertrans);
            ++i;
        }
        root.addContent((Content)transforms);
        Element gridDisplay = this.getGridDisplayStatusElement(geo3d);
        root.addContent((Content)gridDisplay);
        Element backgroundColor = this.getBackgroundColorElement(geo3d);
        Element gridColor = this.getGridColorElement(geo3d);
        root.addContent((Content)backgroundColor);
        root.addContent((Content)gridColor);
        Element pluginList = new Element("Plugins");
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        int i2 = 0;
        while (i2 < menuStates.size()) {
            Element plugin = new Element("Plugin");
            Element name = new Element("Name");
            name.setText((String)menuStates.get(i2));
            plugin.addContent((Content)name);
            Element pluginState = new Element("State");
            if (pluginStates.containsKey(name.getText())) {
                pluginState.addContent((Content)((Element)pluginStates.get(name.getText())));
            }
            plugin.addContent((Content)pluginState);
            pluginList.addContent((Content)plugin);
            ++i2;
        }
        root.addContent((Content)pluginList);
        try {
            outputter.output(saveState, (OutputStream)new FileOutputStream(stateVectorFile));
        }
        catch (IOException e) {
            log.error((Object)("IOException in StateVector.saveState(): " + e.getMessage()));
            throw new StateVectorException("IOException in StateVector.saveState(): " + e.getMessage());
        }
    }

    public void loadState(MainWindow guiFrame, File loadFile) throws StateVectorException {
        SAXBuilder theBuilder = new SAXBuilder();
        try {
            Document vectorTree = theBuilder.build(loadFile);
            Element rootElement = vectorTree.getRootElement();
            MultiTransformGroup mtg = this.recreateViewingPlatform(rootElement.getChild("ViewTransforms"));
            ViewRange rangeData = this.recreateViewRange(rootElement.getChild("viewRange"));
            rootElement.getChild("gridDisplay");
            Color3f backgroundColor = this.recreateColor3f(rootElement.getChild("backgroundColor"));
            Color3f gridColor = this.recreateColor3f(rootElement.getChild("gridColor"));
            HashMap plugins = this.recreatePlugins(rootElement.getChild("Plugins"));
            guiFrame.createNewViewer(rangeData, mtg, backgroundColor, gridColor, plugins);
        }
        catch (JDOMException e) {
            log.error((Object)("JDOMException in StateVector.loadState(): " + e.getMessage()));
            throw new StateVectorException("JDOMException in StateVector.loadState(): " + e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)("IOException in StateVector.loadState(): " + e.getMessage()));
            throw new StateVectorException("IOException in StateVector.loadState(): " + e.getMessage());
        }
    }

    protected Color3f recreateColor3f(Element child) {
        float x = Float.parseFloat(child.getAttributeValue("x"));
        float y = Float.parseFloat(child.getAttributeValue("y"));
        float z = Float.parseFloat(child.getAttributeValue("z"));
        return new Color3f(x, y, z);
    }

    public ViewRange recreateViewRange(Element testViewRange) {
        int lowerLatitude = Integer.parseInt(testViewRange.getChild("lowerLatitude").getText());
        int upperLatitude = Integer.parseInt(testViewRange.getChild("upperLatitude").getText());
        int leftLongitude = Integer.parseInt(testViewRange.getChild("leftLongitude").getText());
        int rightLongitude = Integer.parseInt(testViewRange.getChild("rightLongitude").getText());
        return new ViewRange(lowerLatitude, upperLatitude, leftLongitude, rightLongitude);
    }

    protected HashMap recreatePlugins(Element pluginRoot) {
        HashMap<String, Element> childList = new HashMap<String, Element>();
        int i = 0;
        while (i < pluginRoot.getChildren().size()) {
            Element item = (Element)pluginRoot.getChildren().get(i);
            Element name = item.getChild("Name");
            String pluginName = name.getText();
            Element state = item.getChild("State");
            childList.put(pluginName, state);
            ++i;
        }
        return childList;
    }

    protected MultiTransformGroup recreateViewingPlatform(Element mtgRoot) {
        List child = mtgRoot.getChildren();
        MultiTransformGroup mtg = new MultiTransformGroup(child.size());
        int i = 0;
        while (i < child.size()) {
            Transform3D bld = this.getTransform3D((Element)child.get(i));
            mtg.getTransformGroup(i).setTransform(bld);
            Transform3D setTransform = new Transform3D();
            mtg.getTransformGroup(i).getTransform(setTransform);
            System.out.println(bld);
            System.out.println(setTransform);
            ++i;
        }
        return mtg;
    }

    protected Transform3D getTransform3D(Element trans) {
        double[] temp = new double[16];
        int i = 0;
        while (i < temp.length) {
            Element component = trans.getChild("Dimension" + i);
            String vectorChunk = component.getText();
            try {
                temp[i] = Double.parseDouble(vectorChunk);
            }
            catch (NumberFormatException e) {
                log.error((Object)("NumberFormatException in StateVector.recreateTransform3D(): " + e.getMessage()));
            }
            ++i;
        }
        return new Transform3D(temp);
    }

    private Element saveViewRange(ViewRange vr) {
        Element viewRangeRoot = new Element("viewRange");
        Element upperLatitude = new Element("lowerLatitude");
        upperLatitude.setText(vr.getLowerLatitudeAsString());
        Element lowerLatitude = new Element("upperLatitude");
        lowerLatitude.setText(vr.getUpperLatitudeAsString());
        Element leftLongitude = new Element("leftLongitude");
        leftLongitude.setText(vr.getLeftLongitudeAsString());
        Element rightLongitude = new Element("rightLongitude");
        rightLongitude.setText(vr.getRightLongitudeAsString());
        viewRangeRoot.addContent((Content)upperLatitude);
        viewRangeRoot.addContent((Content)lowerLatitude);
        viewRangeRoot.addContent((Content)leftLongitude);
        viewRangeRoot.addContent((Content)rightLongitude);
        return viewRangeRoot;
    }

    public Element getViewRangeForTest(ViewRange vr) {
        return this.saveViewRange(vr);
    }

    public Element getGridDisplayStatusElement(GlobeView viewer) {
        Element gridDisplay = new Element("gridDisplay");
        if (viewer.getGridDisplayBool()) {
            gridDisplay.setText("On");
        } else {
            gridDisplay.setText("Off");
        }
        return gridDisplay;
    }

    public Element getBackgroundColorElement(GlobeView viewer) {
        Element backgroundColor = new Element("backgroundColor");
        Color3f color = viewer.getBackgroundColor();
        backgroundColor.setAttribute("x", String.valueOf(color.x));
        backgroundColor.setAttribute("y", String.valueOf(color.y));
        backgroundColor.setAttribute("z", String.valueOf(color.z));
        return backgroundColor;
    }

    public Element getGridColorElement(GlobeView viewer) {
        Element gridColor = new Element("gridColor");
        Color3f color = viewer.getGridColor();
        gridColor.setAttribute("x", String.valueOf(color.x));
        gridColor.setAttribute("y", String.valueOf(color.y));
        gridColor.setAttribute("z", String.valueOf(color.z));
        return gridColor;
    }
}

