/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.stateVector;

import com.sun.j3d.utils.universe.MultiTransformGroup;
import java.io.File;
import java.util.HashMap;
import java.util.Random;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.vecmath.Color3f;
import junit.framework.TestCase;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Content;
import org.jdom.Element;
import org.scec.geo3d.gui.MainWindow;
import org.scec.geo3d.gui.ViewRange;
import org.scec.geo3d.gui.viewer.GlobeView;
import org.scec.geo3d.tools.Prefs;
import org.scec.geo3d.tools.plugin.Geo3dInfo;
import org.scec.geo3d.tools.stateVector.StateVector;

public class StateVectorTest
extends TestCase {
    private MainWindow window;
    private GlobeView viewer;
    private MultiTransformGroup mtg;
    private Transform3D transform;
    private StateVector sv;

    public void setUp() {
        Prefs.init();
        DOMConfigurator.configure((String)"conf/log_config.xml");
        this.window = new MainWindow();
        ViewRange viewRange = new ViewRange(32, 36, -122, -114);
        this.viewer = new GlobeView(viewRange);
        this.sv = new StateVector();
    }

    public void testSaveLoadTransforms() throws Exception {
        this.mtg = this.viewer.getMultiTransform();
        File f = new File("testTransform.xml");
        this.viewer.saveState(f);
        this.sv.loadState(this.window, f);
        MultiTransformGroup toTest = Geo3dInfo.getActiveViewer().getMultiTransform();
        StateVectorTest.assertEquals((int)toTest.getNumTransforms(), (int)this.mtg.getNumTransforms());
        int i = 0;
        while (i < toTest.getNumTransforms()) {
            TransformGroup t1 = toTest.getTransformGroup(i);
            TransformGroup t2 = this.mtg.getTransformGroup(i);
            Transform3D trans1 = new Transform3D();
            Transform3D trans2 = new Transform3D();
            t1.getTransform(trans1);
            t2.getTransform(trans2);
            double[] t1Double = new double[16];
            double[] t2Double = new double[16];
            trans1.get(t1Double);
            trans2.get(t2Double);
            int j = 0;
            while (j < 16) {
                StateVectorTest.assertEquals((double)t1Double[0], (double)t2Double[0], (double)1.0E-7);
                ++j;
            }
            ++i;
        }
    }

    public void testGetTransform3D() throws Exception {
        double[] transDouble = new double[16];
        int i = 0;
        while (i < 16) {
            transDouble[i] = i;
            ++i;
        }
        Element element = this.setUpTransformElement(transDouble);
        Transform3D returned = this.sv.getTransform3D(element);
        this.compareTransformToExpected(transDouble, returned);
    }

    private void compareTransformToExpected(double[] transDouble, Transform3D returned) {
        double[] retrieve = new double[16];
        returned.get(retrieve);
        int i = 0;
        while (i < 16) {
            StateVectorTest.assertEquals((double)retrieve[i], (double)transDouble[i], (double)1.0E-5);
            ++i;
        }
    }

    public void testRecreateViewingPlatform() throws Exception {
        Element root = new Element("root");
        Random rand = new Random();
        double[][] data = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {1.0, 2.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        int i = 0;
        while (i < 3) {
            Element trans = this.setUpTransformElement(data[i]);
            root.addContent((Content)trans);
            ++i;
        }
        MultiTransformGroup mtg = this.sv.recreateViewingPlatform(root);
        StateVectorTest.assertEquals((int)mtg.getNumTransforms(), (int)3);
        int i2 = 0;
        while (i2 < 3) {
            Transform3D trans = new Transform3D();
            mtg.getTransformGroup(i2).getTransform(trans);
            this.compareTransformToExpected(data[i2], trans);
            ++i2;
        }
    }

    private Element setUpTransformElement(double[] transDouble) throws Exception {
        Element element = new Element("transform");
        Transform3D trans = new Transform3D(transDouble);
        double[] retrieve = new double[16];
        trans.get(retrieve);
        int i = 0;
        while (i < 16) {
            Element dimElement = new Element("Dimension" + i);
            dimElement.setText(Double.toString(retrieve[i]));
            element.addContent((Content)dimElement);
            ++i;
        }
        return element;
    }

    public void testRecreatePlugins() throws Exception {
        Element root = new Element("Plugins");
        Element pluginElement = new Element("Plugin");
        Element name = new Element("Name");
        name.setText("TestPluginName");
        Element state = new Element("State");
        state.setText("TestPluginState");
        Element stateRootElement = new Element("TestRootElement");
        Element stateChildElement1 = new Element("TestChildElement1");
        Element stateChildElement2 = new Element("TestChildElement2");
        stateRootElement.addContent((Content)stateChildElement1);
        stateRootElement.addContent((Content)stateChildElement2);
        state.addContent((Content)stateRootElement);
        pluginElement.addContent((Content)name);
        pluginElement.addContent((Content)state);
        root.addContent((Content)pluginElement);
        HashMap testPlugins = this.sv.recreatePlugins(root);
        StateVectorTest.assertEquals((String)((Element)testPlugins.get(name.getText())).getChild("TestRootElement").getName(), (String)stateRootElement.getName());
    }

    public void testLoadState() throws Exception {
        Geo3dInfo.getDesktop().add(this.viewer);
        JMenuBar bar = this.viewer.getJMenuBar();
        JMenu object = bar.getMenu(2);
        JMenuItem item = (JMenuItem)object.getMenuComponent(0);
        JMenu extensions = bar.getMenu(bar.getMenuCount() - 1);
        StateVectorTest.assertEquals((String)"Extensions", (String)extensions.getText());
        item = (JMenuItem)extensions.getMenuComponent(0);
        this.viewer.addObjectPlugin(0);
        File f = new File("temp2.xml");
        this.viewer.saveState(f);
        this.sv.loadState(this.window, f);
        GlobeView newViewer = Geo3dInfo.getActiveViewer();
        StateVectorTest.assertEquals((Object)this.viewer, (Object)newViewer);
    }

    public void testSaveSoCalCoordinates() throws Exception {
        Element testViewRange = this.sv.getViewRangeForTest(this.viewer.getViewRange());
        StateVectorTest.assertEquals((String)"32", (String)testViewRange.getChild("lowerLatitude").getText());
        StateVectorTest.assertEquals((String)"36", (String)testViewRange.getChild("upperLatitude").getText());
        StateVectorTest.assertEquals((String)"-122", (String)testViewRange.getChild("leftLongitude").getText());
        StateVectorTest.assertEquals((String)"-114", (String)testViewRange.getChild("rightLongitude").getText());
    }

    public void testRecreateViewRange() throws Exception {
        Element testViewRange = this.sv.getViewRangeForTest(this.viewer.getViewRange());
        ViewRange vr = this.sv.recreateViewRange(testViewRange);
        StateVectorTest.assertEquals((int)32, (int)vr.getLowerLatitude());
        StateVectorTest.assertEquals((int)36, (int)vr.getUpperLatitude());
        StateVectorTest.assertEquals((int)-122, (int)vr.getLeftLongitude());
        StateVectorTest.assertEquals((int)-114, (int)vr.getRightLongitude());
    }

    public void testGridDisplay() throws Exception {
        Element testGridDisplay = this.sv.getGridDisplayStatusElement(this.viewer);
        StateVectorTest.assertEquals((String)"On", (String)testGridDisplay.getText());
    }

    public void testGetBackgroundGridColor() throws Exception {
        Color3f newColor = new Color3f(65.0f, 125.0f, 160.0f);
        this.viewer.changeBackgroundColorForStateRestoration(newColor);
        Element backgroundColor = this.sv.getBackgroundColorElement(this.viewer);
        StateVectorTest.assertEquals((String)String.valueOf(newColor.x), (String)backgroundColor.getAttributeValue("x"));
        StateVectorTest.assertEquals((String)String.valueOf(newColor.y), (String)backgroundColor.getAttributeValue("y"));
        StateVectorTest.assertEquals((String)String.valueOf(newColor.z), (String)backgroundColor.getAttributeValue("z"));
        this.viewer.changeGridColorForStateRestoration(newColor);
        Element gridColor = this.sv.getGridColorElement(this.viewer);
        StateVectorTest.assertEquals((String)String.valueOf(newColor.x), (String)gridColor.getAttributeValue("x"));
        StateVectorTest.assertEquals((String)String.valueOf(newColor.y), (String)gridColor.getAttributeValue("y"));
        StateVectorTest.assertEquals((String)String.valueOf(newColor.z), (String)gridColor.getAttributeValue("z"));
    }

    public void testRecreateColor() throws Exception {
        Element gridColor = new Element("gridColor");
        gridColor.setAttribute("x", "65.0");
        gridColor.setAttribute("y", "125.0");
        gridColor.setAttribute("z", "160.0");
        Color3f newColor = this.sv.recreateColor3f(gridColor);
        StateVectorTest.assertEquals((String)gridColor.getAttributeValue("x"), (String)String.valueOf(newColor.x));
        StateVectorTest.assertEquals((String)gridColor.getAttributeValue("y"), (String)String.valueOf(newColor.y));
        StateVectorTest.assertEquals((String)gridColor.getAttributeValue("z"), (String)String.valueOf(newColor.z));
    }
}

