/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.utm;

public class UTMZone {
    double longitude;
    double iZone;
    double spheroidRegion;

    public void setSpheroidRegion(double sph) {
        if (sph < 1.0 || sph > 20.0) {
            System.out.println("Error in Spheroid region value");
            this.spheroidRegion = 0.0;
        } else {
            this.spheroidRegion = sph;
        }
    }

    public int getSpheroidRegion() {
        return (int)this.spheroidRegion;
    }

    public String getSpheroidName() {
        String spheroidName = "";
        int sph = (int)this.spheroidRegion;
        switch (sph) {
            case 1: {
                spheroidName = " Clarke 1866 ";
                break;
            }
            case 2: {
                spheroidName = " Clarke 1880 ";
                break;
            }
            case 3: {
                spheroidName = " Bessel 1967 ";
                break;
            }
            case 4: {
                spheroidName = " New International 1967 ";
                break;
            }
            case 5: {
                spheroidName = " International 1909 ";
                break;
            }
            case 6: {
                spheroidName = " WGS 72 ";
                break;
            }
            case 7: {
                spheroidName = " Everest ";
                break;
            }
            case 8: {
                spheroidName = " WGS 66 ";
                break;
            }
            case 9: {
                spheroidName = " GRS 1980 ";
                break;
            }
            case 10: {
                spheroidName = " Airy ";
                break;
            }
            case 11: {
                spheroidName = " Modified Everest ";
                break;
            }
            case 12: {
                spheroidName = " Modified Airy ";
                break;
            }
            case 13: {
                spheroidName = " Walbeck ";
                break;
            }
            case 14: {
                spheroidName = " Southeast Asia ";
                break;
            }
            case 15: {
                spheroidName = " Australia National - South American 1969 ";
                break;
            }
            case 16: {
                spheroidName = " Krassovsky ";
                break;
            }
            case 17: {
                spheroidName = " Hough ";
                break;
            }
            case 18: {
                spheroidName = " Mercury 1960 (Fischer) ";
                break;
            }
            case 19: {
                spheroidName = " Modified Mercury 1968 (Fischer) ";
                break;
            }
            case 20: {
                spheroidName = " WGS 84 ";
            }
        }
        return spheroidName;
    }

    public void setLon(double lon) {
        this.longitude = lon;
    }

    public void setAllValues(double lon, double sph) {
        if (sph < 1.0 || sph > 20.0) {
            System.out.println("Error in Spheroid region value");
            this.spheroidRegion = 0.0;
        } else {
            this.spheroidRegion = sph;
        }
        this.longitude = lon;
    }

    public double getUTMZone() {
        double lon = this.longitude + 180.0;
        double val = Math.floor(lon / 6.0);
        this.iZone = val + 1.0;
        return this.iZone;
    }

    public static int calcUTMZone(double lat, double latMin, double lon, double lonMin) {
        String zoneLetterArray = "CDEFGHJKLMNPQUSTUVWX";
        lon += lonMin / 60.0;
        if (Math.abs(lat += latMin / 60.0) > 90.0 || Math.abs(lon) > 180.0) {
            System.out.println("Invalid coordinates");
            return -1;
        }
        if (lat < -80.0 || lat > 84.0) {
            System.out.println("Out of UTM Zones");
            return -2;
        }
        int hZone = (int)Math.ceil((lon + 180.0) / 6.0);
        int vZone = (int)Math.floor((lat + 80.0) / 8.0);
        char zoneLetter = "CDEFGHJKLMNPQUSTUVWX".charAt(vZone);
        if (zoneLetter == 'X') {
            if (hZone == 32 || hZone == 34 || hZone == 36) {
                hZone = lon % 6.0 < 3.0 ? --hZone : ++hZone;
            }
        } else if (zoneLetter == 'V' && hZone == 31 && lon % 6.0 >= 3.0) {
            ++hZone;
        }
        Integer zoneNum = new Integer(hZone);
        String utmZone = String.valueOf(zoneNum.toString()) + "CDEFGHJKLMNPQUSTUVWX".charAt(vZone);
        return zoneNum;
    }

    public UTMZone() {
    }

    public UTMZone(double lon, double sph) {
        this.longitude = lon;
        this.spheroidRegion = sph;
    }
}

