/*
 * Decompiled with CFR 0.152.
 */
package org.scec.geo3d.tools.utm;

import org.scec.geo3d.tools.utm.UTMZone;

public class convert {
    double[] AXIS = new double[]{6378206.4, 6378249.145, 6377397.155, 6378157.5, 6378388.0, 6378135.0, 6377276.3452, 6378145.0, 6378137.0, 6377563.396, 6377304.063, 6377341.89, 6376896.0, 6378155.0, 6378160.0, 6378245.0, 6378270.0, 6378166.0, 6378150.0, 6378137.0};
    double[] BXIS = new double[]{6356583.8, 6356514.86955, 6356078.96284, 6356772.2, 6356911.94613, 6356750.519915, 6356075.4133, 6356759.769356, 6356752.31414, 6356256.91, 6356103.039, 6356036.143, 6355834.8467, 6356773.3205, 6356774.719, 6356863.0188, 6356794.343479, 6356784.283666, 6356768.337303, 6356752.31414};
    double AK0 = 0.9996;
    double A;
    double B;
    double ES;
    double IZONE;
    double RADSEC = 206264.8062470964;
    double CVAL1;
    double CVAL2;
    double IIZONE = 100.0;
    double IUTZ = 0.0;
    double CM = 0.0;
    double spheroidRegion;
    double[] vt = new double[]{0.0, 0.0};

    public double[] LatLonToUTM() {
        this.vt[1] = 0.0;
        this.vt[0] = 0.0;
        double IIZ = 0.0;
        double secLAT = this.CVAL1 * 3600.0;
        double secLON = -(this.CVAL2 * 3600.0);
        UTMZone uz = new UTMZone(this.CVAL1, this.spheroidRegion);
        this.A = this.AXIS[uz.getSpheroidRegion() - 1];
        this.B = this.BXIS[uz.getSpheroidRegion() - 1];
        this.ES = (Math.pow(this.A, 2.0) - Math.pow(this.B, 2.0)) / Math.pow(this.A, 2.0);
        this.IZONE = this.IIZONE != 100.0 ? this.IIZONE : uz.getUTMZone();
        if (this.IZONE == 0.0) {
            IIZ = secLON / 21600.0;
            this.IZONE = 30.0 - IIZ;
            if (secLON < 0.0) {
                this.IZONE = 31.0 - IIZ;
            }
        }
        if (this.IZONE <= 30.0) {
            this.IUTZ = 30.0 - Math.abs(this.IZONE);
            this.CM = (this.IUTZ * 6.0 + 3.0) * 3600.0;
        } else {
            this.IUTZ = Math.abs(this.IZONE) - 30.0;
            this.CM = (this.IUTZ * 6.0 - 3.0) * -3600.0;
        }
        if (secLAT < 0.0) {
            this.IZONE = -Math.abs(this.IZONE);
        }
        if (this.IZONE < 0.0) {
            secLAT = -Math.abs(secLAT);
        }
        double PHI = secLAT / this.RADSEC;
        double DLAM = -(secLON - this.CM) / this.RADSEC;
        double EPRI = this.ES / (1.0 - this.ES);
        double EN = this.A / Math.sqrt(1.0 - this.ES * Math.pow(Math.sin(PHI), 2.0));
        double T = Math.pow(Math.tan(PHI), 2.0);
        double C = EPRI * Math.pow(Math.cos(PHI), 2.0);
        double AA = DLAM * Math.cos(PHI);
        double S2 = Math.sin(2.0 * PHI);
        double S4 = Math.sin(4.0 * PHI);
        double S6 = Math.sin(6.0 * PHI);
        double F1 = 1.0 - this.ES / 4.0 - 3.0 * this.ES * this.ES / 64.0 - 5.0 * this.ES * this.ES * this.ES / 256.0;
        double F2 = 3.0 * this.ES / 8.0 + 3.0 * this.ES * this.ES / 32.0 + 4.5 * this.ES * this.ES * this.ES / 1024.0;
        double F3 = 15.0 * this.ES * this.ES / 256.0 + 45.0 * this.ES * this.ES * this.ES / 1024.0;
        double F4 = 35.0 * this.ES * this.ES * this.ES / 3072.0;
        double EM = this.A * (F1 * PHI - F2 * S2 + F3 * S4 - F4 * S6);
        double XX = this.AK0 * EN * (AA + (1.0 - T + C) * Math.pow(AA, 3.0) / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * EPRI) * Math.pow(AA, 5.0) / 120.0);
        XX += 500000.0;
        double YY = this.AK0 * (EM + EN * Math.tan(PHI) * (AA * AA / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * Math.pow(AA, 4.0) / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * EPRI) * Math.pow(AA, 6.0) / 720.0));
        if (this.IZONE < 0.0 || secLAT < 0.0) {
            YY += 1.0E7;
        }
        if (this.vt[0] == 1.0 && this.vt[1] == 1.0) {
            return this.vt;
        }
        this.vt[0] = XX;
        this.vt[1] = YY;
        return this.vt;
    }

    public double[] UTMToLatLon() {
        this.vt[1] = 0.0;
        this.vt[0] = 0.0;
        UTMZone uz = new UTMZone();
        uz.setSpheroidRegion(this.spheroidRegion);
        this.A = this.AXIS[uz.getSpheroidRegion() - 1];
        this.B = this.BXIS[uz.getSpheroidRegion() - 1];
        this.ES = (Math.pow(this.A, 2.0) - Math.pow(this.B, 2.0)) / Math.pow(this.A, 2.0);
        this.IZONE = this.IIZONE;
        if (this.IZONE <= 30.0) {
            this.IUTZ = 30.0 - Math.abs(this.IZONE);
            this.CM = (this.IUTZ * 6.0 + 3.0) * 3600.0;
        } else {
            this.IUTZ = Math.abs(this.IZONE) - 30.0;
            this.CM = (this.IUTZ * 6.0 - 3.0) * -3600.0;
        }
        double YY = this.CVAL2;
        if (this.IZONE < 0.0) {
            YY -= 1.0E7;
        }
        double XX = this.CVAL1 - 500000.0;
        double EM = YY / this.AK0;
        double UM = EM / (this.A * (1.0 - this.ES / 4.0 - 3.0 * this.ES * this.ES / 64.0 - 5.0 * this.ES * this.ES * this.ES / 256.0));
        double E1 = (1.0 - Math.sqrt(1.0 - this.ES)) / (1.0 + Math.sqrt(1.0 - this.ES));
        double PHI1 = UM + (3.0 * E1 / 2.0 - 27.0 * Math.pow(E1, 3.0) / 32.0) * Math.sin(2.0 * UM) + (21.0 * E1 * E1 / 16.0 - 55.0 * Math.pow(E1, 4.0) / 32.0) * Math.sin(4.0 * UM) + 151.0 * Math.pow(E1, 3.0) / 96.0 * Math.sin(6.0 * UM);
        double EN = this.A / Math.sqrt(1.0 - this.ES * Math.pow(Math.sin(PHI1), 2.0));
        double T = Math.pow(Math.tan(PHI1), 2.0);
        double EPRI = this.ES / (1.0 - this.ES);
        double C = EPRI * Math.pow(Math.cos(PHI1), 2.0);
        double R = this.A * (1.0 - this.ES) / Math.pow(1.0 - this.ES * Math.pow(Math.sin(PHI1), 2.0), 1.5);
        double D = XX / (EN * this.AK0);
        double PHI = PHI1 - EN * Math.tan(PHI1) / R * (D * D / 2.0 - (5.0 + 3.0 * T + 10.0 * C - 4.0 * C * C - 9.0 * EPRI) * Math.pow(D, 4.0) / 24.0 + (61.0 + 90.0 * T + 298.0 * C + 45.0 * T * T - 252.0 * EPRI - 3.0 * C * C) * Math.pow(D, 6.0) / 720.0);
        double ALAM = this.CM / this.RADSEC - (D - (1.0 + 2.0 * T + C) * Math.pow(D, 3.0) / 6.0 + (5.0 - 2.0 * C + 28.0 * T - 3.0 * C * C + 8.0 * EPRI + 24.0 * T * T) * Math.pow(D, 5.0) / 120.0) / Math.cos(PHI1);
        double secLAT = PHI * this.RADSEC;
        double secLON = ALAM * this.RADSEC;
        double DLAM = -(secLON - this.CM) / this.RADSEC;
        double CONV = DLAM * (Math.sin(PHI) + 1.9587E-12 * Math.pow(DLAM, 2.0) * Math.sin(PHI) * Math.cos(PHI * PHI));
        double SLAT = secLAT / 3600.0;
        double SLON = -(secLON / 3600.0);
        if (this.vt[0] == 1.0 && this.vt[1] == 1.0) {
            return this.vt;
        }
        this.vt[0] = SLAT;
        this.vt[1] = SLON;
        if (Math.abs(secLAT) > 302400.0 || Math.abs(DLAM) > 0.16) {
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
            System.out.println("Error converting to UTM");
        }
        return this.vt;
    }

    public void setUTMxy(double val1, double val2) {
        this.CVAL1 = val1;
        this.CVAL2 = val2;
    }

    public void setLatLon(double val1, double val2) {
        this.CVAL1 = val1;
        this.CVAL2 = val2;
    }

    public void setUTMZone(double zone) {
        if (zone < 1.0 || zone > 60.0) {
            System.out.println("Error in zone value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.IIZONE = zone;
    }

    public void setSpheroid(double sph) {
        if (sph < 1.0 || sph > 20.0) {
            System.out.println("Error in Spheroid region value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.spheroidRegion = sph;
    }

    public void setAllValues(double val1, double val2, double sph, double zone) {
        this.CVAL1 = val1;
        this.CVAL2 = val2;
        if (zone < 1.0 || zone > 60.0) {
            System.out.println("Error in zone value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.IIZONE = zone;
        if (sph < 1.0 || sph > 20.0) {
            System.out.println("Error in Spheroid region value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.spheroidRegion = sph;
    }

    public convert() {
    }

    public convert(double val1, double val2, double sph) {
        this.CVAL1 = val1;
        this.CVAL2 = val2;
        if (sph < 1.0 || sph > 20.0) {
            System.out.println("Error in Spheroid region value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.spheroidRegion = sph;
    }

    public convert(double val1, double val2, double sph, double utmzone) {
        this.CVAL1 = val1;
        this.CVAL2 = val2;
        if (utmzone < 1.0 || utmzone > 60.0) {
            System.out.println("Error in zone value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.IIZONE = utmzone;
        if (sph < 1.0 || sph > 20.0) {
            System.out.println("Error in Spheroid region value");
            this.vt[1] = 1.0;
            this.vt[0] = 1.0;
        }
        this.spheroidRegion = sph;
    }
}

