#!/bin/tcsh

# dispatcher_five_year_V13.10.tcsh:
#
# Run daily Dispatcher for Global testing region to evaluate M7.5 and M8.0 five-year forecasts using PDE catalog
#

source ~/.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`


# Capture all output produced by Dispatcher into the daily log file
set logdir=$CSEP/dispatcher/logs/GlobalPDE/"$year"_"$month"
mkdir -p "$logdir"

set logfile="$logdir"/globalPDE_V13.10_"$year-$month-$day-$hour$min$sec"


# Invoke Dispatcher for "today" (with 31 day delay for the testing date):
nohup python $CENTERCODE/src/generic/Dispatcher.py --year="$year" --month="$month" --day="$day" --configFile=/usr/local/csep/configuration/testing-regions/GlobalPDE/cronjobs/dispatcher_five_year_V13.10.init.xml --waitingPeriod=31 --publishServer=csep-usc@cseppublishing.usc.edu --publishDirectory=/export/cseppublishing/csep/us/results/data/us/usc/globalPDE --logFile="$logfile" >& "$logfile" &
