import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 *
 * @author jzechar
 */
public class FileUtil {
    
    /** Creates a new instance of FileUtil */
    public FileUtil() {
    }
    
    /**
     * Combine the contents of the specified files into a single file
     *
     * @param files array of filepaths to combine
     * @param combinedFile path to file that will contain the combined contents of the specified file
     */
    public static void combineFiles(String[] files, String combinedFile){
        try {
            FileOutputStream oOutFIS = new FileOutputStream(combinedFile);
            BufferedOutputStream oOutBIS = new BufferedOutputStream(oOutFIS);
            BufferedWriter oWriter = new BufferedWriter(new OutputStreamWriter(oOutBIS));
            
            String sRecord = null;
            for (int i = 0; i < files.length; i++) {
                String currentPath = files[i];
                
                // Get a handle to the file
                FileInputStream oFIS = new FileInputStream(currentPath);
                BufferedInputStream oBIS = new BufferedInputStream(oFIS);
                BufferedReader oReader = new BufferedReader(new InputStreamReader(oBIS));
                
                // pass through the file and bin each value
                while ( (sRecord = oReader.readLine()) != null) {
                    oWriter.write(sRecord + "\n");
                    
                }
                oReader.close();
                oBIS.close();
                oFIS.close();
            }
            oWriter.close();
            oOutBIS.close();
            oOutFIS.close();
        } catch (Exception ex) {
            System.out.println("Error in FileUtil.combineFiles()");
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}