public class GeoUtil {

    public GeoUtil() {
    }

    /**
     * Compute the Kossobokov distance (in km) b/w two lat/lon points,
     * each of which is specified in decimal degrees.  This is the formula that
     * Volodya uses for M8 distances
     *
     * @param latOrigin first latitude point
     * @param lonOrigin first longitude point
     * @param latDestination second latitude point
     * @param lonDestination second longitude point
     * @return Vincenty distance b/w specified lat-lon points
     */
    public static float kossobokovDistanceBetweenPoints(float latOrigin,
            float lonOrigin, float latDestination, float lonDestination){
        float latDestinationRads = (float) Math.toRadians(latDestination);

//        D = SQRT((LAT-LA)^2+((LON-LO)*COS(PI*LAT/180))^2)*40000/360
        float distance = (float) Math.sqrt(
                (latOrigin - latDestination) * (latOrigin - latDestination) +
                ((lonOrigin - lonDestination) * Math.cos(latDestinationRads) *
                (lonOrigin - lonDestination) * Math.cos(latDestinationRads))
                ) * 40000f / 360f;
        return (distance);

    }
    /**
     * Compute the Vincenty distance (in km) b/w two lat/lon points, each of which is specified in decimal degrees.  We use the WGS-84 model for the Earth's ellipsoid.
     *
     * @param latOrigin first latitude point
     * @param lonOrigin first longitude point
     * @param latDestination second latitude point
     * @param lonDestination second longitude point
     * @return Vincenty distance b/w specified lat-lon points
     */
    public static float vincentyDistanceBetweenPoints(float latOrigin, float lonOrigin, float latDestination, float lonDestination) {
        double a = 6378.137;
        double b = 6356.7523142;
        double f = (a - b) / a;

        // The distance formula expects lat, lon in radians, so we need to convert them from degrees
        latOrigin = (float) Math.toRadians(latOrigin);
        lonOrigin = (float) Math.toRadians(lonOrigin);
        latDestination = (float) Math.toRadians(latDestination);
        lonDestination = (float) Math.toRadians(lonDestination);

        double L = lonOrigin - lonDestination;
        double U_1 = Math.atan((1 - f) * Math.tan(latOrigin));
        double U_2 = Math.atan((1 - f) * Math.tan(latDestination));

        double lambda = L;
        double lambdaPrime = 2 * Math.PI;
        double cosSquaredAlpha = 0;
        double sinSigma = 0;
        double cosSigma = 0;
        double cos2Sigma_m = 0;
        double sigma = 0;
        double epsilon = 1e-7;

        while (Math.abs(lambda - lambdaPrime) > epsilon) {
            double temp1 = Math.cos(U_2) * Math.sin(lambda);
            double temp2 = Math.cos(U_1) * Math.sin(U_2) - Math.sin(U_1) * Math.cos(U_2) * Math.cos(lambda);
            sinSigma = Math.sqrt(temp1 * temp1 + temp2 * temp2);
            cosSigma = Math.sin(U_1) * Math.sin(U_2) + Math.cos(U_1) * Math.cos(U_2) * Math.cos(lambda);
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = Math.cos(U_1) * Math.cos(U_2) * Math.sin(lambda) / (sinSigma + Double.MIN_VALUE);
            cosSquaredAlpha = 1 - sinAlpha * sinAlpha;
            cos2Sigma_m = Math.cos(sigma) - 2 * Math.sin(U_1) * Math.sin(U_2) / (cosSquaredAlpha + Double.MIN_VALUE);
            double C = f / 16 * cosSquaredAlpha * (4 + f * (4 - 3 * cosSquaredAlpha));
            lambdaPrime = lambda;
            lambda = L + (1 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2Sigma_m + C * cosSigma * (-1 + 2 * cos2Sigma_m * cos2Sigma_m)));
//            System.out.println("lambda = " + lambda);
        }

        double uSquared = cosSquaredAlpha * (a * a - b * b) / (b * b);
        double A = 1 + uSquared / 16384 * (4096 + uSquared * (-768 + uSquared * (320 - 175 * uSquared)));
        double B = uSquared / 1024 * (256 + uSquared * (74 - 47 * uSquared));
        double deltaSigma = B * sinSigma * (cos2Sigma_m + B / 4 * (cosSigma * (-1 + 2 * cos2Sigma_m * cos2Sigma_m - B / 6 *
                cos2Sigma_m * (-3 + 4 * sinSigma * sinSigma * (-3 + 4 * cos2Sigma_m * cos2Sigma_m)))));

        float distance = (float) (b * A * (sigma - deltaSigma));
//        if (distance > 20){
//            System.out.println("(lat1, lon1) = (" + Math.toDegrees(latOrigin) + ", " + Math.toDegrees(lonOrigin) + ")");
//            System.out.println("(lat2, lon2) = (" + Math.toDegrees(latDestination) + ", " + Math.toDegrees(lonDestination) + ")");
//            System.out.println("got here...");
//        }
//        if (distance )
        return (distance);
    }
}
