import java.io.OutputStreamWriter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.util.Properties;
import java.io.FileInputStream;
import java.util.Arrays;

public class Sandbox {

    public Sandbox() {
    }

    public static void main(String[] args) {
//        FileUtil of = new FileUtil();
//        String[] files = {"ehdf201301w.dat", "ehdf201302w.dat", "ehdf201303w.dat", "ehdf201304w.dat", "ehdf201305w.dat", "ehdf201306w.dat", "ehdf201307w.dat", "ehdf201308w.dat", "ehdf201309w.dat", "ehdf201310w.dat", "ehdf201311w.dat", "ehdf201312w.dat", "ehdf201313w.dat", "ehdf201314w.dat", "ehdf201315w.dat", "ehdf201316w.dat", "ehdf201317w.dat", "ehdf201318w.dat", "ehdf201319w.dat", "ehdf201320w.dat", "ehdf201321w.dat", "ehdf201322w.dat", "ehdf201323w.dat"};
//        of.combineFiles(files, "ehdf2013a.dat");
//        System.exit(-1);

        String parameterFilePath = args[0];
        Properties Props = new Properties();

        String alarmsPath = "";
        String alarmsStartDate = "";
        String alarmsEndDate = "";
        float alarmsMinMag = 0f;
        float alarmsMaxMag = 10f;
        float alarmsRadius = 0f;
        String catalogPath = "";
        String referenceCatalogStartDate = "";
        String resultsPath = "";
        short numberOfRandomBettors = 0;
        String seedFilePath = "";

        try {
            FileInputStream in = new FileInputStream(parameterFilePath);
            Props.load(in);
            in.close();
            in = null;

            alarmsPath = Props.getProperty("alarmsPath");
            alarmsStartDate = Props.getProperty("alarmsStartDate");
            alarmsEndDate = Props.getProperty("alarmsEndDate");
            alarmsMinMag = Float.parseFloat(Props.getProperty("alarmsMinMag"));
            alarmsMaxMag = Float.parseFloat(Props.getProperty("alarmsMaxMag"));
            alarmsRadius = Float.parseFloat(Props.getProperty("alarmsRadius"));

            catalogPath = Props.getProperty("catalogPath");
            referenceCatalogStartDate =
                    Props.getProperty("referenceCatalogStartDate");

            numberOfRandomBettors = Short.parseShort(
                    Props.getProperty("numberOfRandomBettors"));
            resultsPath = Props.getProperty("resultsPath");
            seedFilePath= Props.getProperty("pathToSeedFile");

        } catch (Exception ex) {
            System.out.println("Error in OptimizationTools.main(" +
                    parameterFilePath + ")");
            ex.printStackTrace();
            System.exit(-1);
        }

        M8Tools o = new M8Tools();
        M8Alarm[] alarms = o.AlarmsFromFile(alarmsPath, alarmsStartDate,
            alarmsEndDate, alarmsMinMag, alarmsMaxMag, alarmsRadius);
        Catalog referenceCatalog = new Catalog(catalogPath);
        Catalog targetCatalog = new Catalog(catalogPath);
        targetCatalog = targetCatalog.subcatalogByMagnitude(alarmsMinMag,
                alarmsMaxMag);
        targetCatalog = targetCatalog.subcatalogByTime(alarmsStartDate,
                alarmsEndDate);
//        targetCatalog.print();
//        System.exit(-1);
        int iAlarms = alarms.length;
        float totalWinnings = 0f;
        float[] referenceProbabilities = new float[iAlarms];
        boolean[] bets = new boolean[iAlarms];
        boolean[] outcomes = new boolean[iAlarms];
        try{
            FileOutputStream oOutFIS = new FileOutputStream(resultsPath);
            BufferedOutputStream oOutBIS = new BufferedOutputStream(oOutFIS);
            BufferedWriter oWriter = new BufferedWriter(
                    new OutputStreamWriter(oOutBIS));

            System.out.println("CI\tlon\tlat\tradius\tstart\tend\tmin_mag\t"
                    + "max_mag\tprob\tbet\toutcome\treturn");
            oWriter.write("lon\tlat\tradius\tstart\tend\tmin_mag\tmax_mag\t"
                    + "prob\tbet\toutcome\treturn\n");
            for (int i = 0; i < iAlarms; i++){
                M8Alarm alarm = alarms[i];
                referenceProbabilities[i] = alarm.referenceProbability(
                        referenceCatalog, referenceCatalogStartDate,
                        alarmsStartDate);
                int numberHits = M8Tools.numberOfTargetEqksWithinAlarmRegion(
                        targetCatalog, alarm.getCenterLat(),
                        alarm.getCenterLon(),alarmsRadius, alarmsMinMag,
                        alarmsMaxMag, alarmsStartDate, alarmsEndDate);
                outcomes[i] = false;
                if (numberHits > 0){
                    outcomes[i] = true;
                }
                bets[i] = alarm.isAlarmFlag();
                float winnings = GamblingTools.winningsForOneBet(
                        referenceProbabilities[i], bets[i], outcomes[i]);
                totalWinnings += winnings;

                System.out.print((i + 1) + ".\t" + alarm.getCenterLon() + "\t" +
                        alarm.getCenterLat() + "\t" + alarm.getRadius() + "\t" +
                        alarm.getStart() + "\t" + alarm.getEnd() + "\t" +
                        alarm.getMinMag() + "\t" + alarm.getMaxMag() + "\t" +
                        referenceProbabilities[i]);
                oWriter.write(alarm.getCenterLon() + "\t" +
                        alarm.getCenterLat() + "\t" + alarm.getRadius() + "\t" +
                        alarm.getStart() + "\t" + alarm.getEnd() + "\t" +
                        alarm.getMinMag() + "\t" + alarm.getMaxMag() + "\t" +
                        referenceProbabilities[i]);
                if (alarm.isRefProbFromSmallerEvents()){
                    System.out.print("*");
                    oWriter.write("*");
                }
                if (alarm.isRefProbFromZeroEvents()){
                    System.out.print("!");
                    oWriter.write("!");
                }
                System.out.println("\t" + bets[i] + "\t" + outcomes[i] + "\t"
                        + winnings);
                oWriter.write("\t" + bets[i] + "\t" + outcomes[i] + "\t"
                        + winnings + "\n");
            }
            System.out.println("total winnings = " + totalWinnings);
            oWriter.write("total winnings = " + totalWinnings + "\n");
            float[] winningsFromRandomGamblers =
                    GamblingTools.winningsForSeveralRandomBettors(
                    numberOfRandomBettors, referenceProbabilities, outcomes,
                    seedFilePath);
//            float avgWin = ArrayUtil.average(winningsFromRandomGamblers);
//            System.out.println("avgWin = " + avgWin);
            System.out.println("random bettor winnings = " +
                    Arrays.toString(winningsFromRandomGamblers));
            oWriter.write("random bettor winnings = " +
                    Arrays.toString(winningsFromRandomGamblers) + "\n");
            int numberOfBetterBettors = ArrayUtil.
                    numberOfEntriesAsLargeAsValue(winningsFromRandomGamblers,
                    totalWinnings);
            System.out.println(numberOfBetterBettors + " (out of " +
                    numberOfRandomBettors + ") random bettors were better "
                    + "than the alarms");
            oWriter.write(numberOfBetterBettors + " (out of " + 
                    numberOfRandomBettors + ") random bettors were better "
                    + "than the alarms");
            oWriter.close();
            oOutBIS.close();
            oOutFIS.close();

    } catch (Exception ex) {
            System.out.println("Error in OptimizationTools.main(" +
                    parameterFilePath + ")");
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}