"""
Module BogusThirtyMinutesModel2
"""

__version__ = "$Revision$"
__revision__ = "$Id$"


import sys, os, datetime, string
import numpy as np

import Environment, CSEPFile, CSEPTestCase
from Forecast import Forecast
from ThirtyMinutesForecast import ThirtyMinutesForecast
from OneDayModelInputPostProcess import OneDayModelInputPostProcess
from CSEPInputParams import CSEPInputParams


#--------------------------------------------------------------------------------
#
# BogusThirtyMinutesModel2 forecast model.
#
# This class is designed to test CSEP functionality of properly handling forecast
# models in the running system.
#
class BogusThirtyMinutesModel2 (ThirtyMinutesForecast):

    # Static data of the class
    
    # Keyword identifying type of the class
    Type = "BogusThirtyMinutes2"
    
    # Dictionary of command to determine external software 
    # version and flag if output of that command is redirected to the
    # stderr (True) or not (False) (java -version, for example). 
    __externalSofwarePackages = {}

    # Flag if input catalog is required to generate forecast
    RequireInputCatalog = True
    

    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.        
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for BogusForecastModel1 class"""
        
        ThirtyMinutesForecast.__init__(self, 
                                       dir_path)


    #--------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return self.Type


    #--------------------------------------------------------------------
    #
    # Write input parameter file for the model.
    #
    # Input: None
    #        
    def writeParameterFile (self):
        """ Format input parameter file for the model.
            Created file will be used by R script that invokes the
            model."""

        fhandle = Forecast.writeParameterFile(self)

        # Close the file
        fhandle.close()


    #---------------------------------------------------------------------------
    #
    # Invoke the model (simulate forecast generation by touching the file
    #
    # Input: None
    #        
    def run (self):
        """ Run forecast: copy example forecast file into expected filename"""
        
        Environment.invokeCommand('cp %s %s' %(os.path.join(CSEPTestCase.CSEPTestCase.ReferenceDataDir,
                                               'BogusThirtyMinutes1_8_1_2013.dat'),
                                               self.filename()))


    #---------------------------------------------------------------------------
    # Return flag that indicates if forecast model requires input catalog. 
    # Defauls is True meaning that forecast model requires input catalog 
    # from authorized data source.
    # 
    def requiresInputCatalog (self):
        """ Flag if forecast model requires input catalog. Default is True meaning  
            that forecast model requires input catalog from authorized data source."""
            
        return BogusThirtyMinutesModel2.RequireInputCatalog


    #---------------------------------------------------------------------------
    #
    # Return commands that should be used to capture version of external
    # software packages the model is dependent on. 
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    @staticmethod
    def externalSoftwareVersions ():
        """ Returns dictionary of command to determine external software 
            version and flag if output of that command is redirected to the
            stderr (True) or not (False) (java -version, for example)."""
        
        return BogusThirtyMinutesModel2.__externalSofwarePackages 

