"""
Module CruiseControlOptionParser
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

import sys, logging, argparse


# optparse module is depricated in Python 2.7, use argparse
class CruiseControlOptionParser (argparse.ArgumentParser):
   """ 2011/05/13: Before any imports of test modules, need to redirect logging
       to the file when tests are invoked by CruiseControl process, 
       otherwise StreamHandler is generated by default on first call
       to the logger. Any subsequent calls to logging.basicConfig won't have
       any effect since logging will have StreamHandler already set up by default
       behavior
   """
   
   #----------------------------------------------------------------------------
   def __init__ (self):
      """ Initialization for CruiseControlOptionParser class"""
      
      argparse.ArgumentParser.__init__(self)

      self.add_argument('--redirectLoggingOutput',
                        dest='log_file',
                        type=str,
                        default=None,
                        help='Redirect output to the file (default is to output \
logging messages to stdout)')
   
      self.add_argument("-v", "--verbose", 
                        dest="verbose", 
                        action="store_true",
                        default=False,
                        help="Enable verbose reporting. Added to support Python's \
'verbose' mode used by CSEP acceptance tests only.")
      
      args, extra_args = self.parse_known_args()
    

   #----------------------------------------------------------------------------
   def error(self, msg):
       """Overwrite error handler to allow use of 'FAIL' keyword to trigger
           failure in CruiseControl framework if python's argparse.error occurs."""
        
       sys.stderr.write('%s FAIL: %s\n' %(CruiseControlOptionParser.__name__, 
                                          msg))
       argparse.ArgumentParser.error(self, msg)
         

   #----------------------------------------------------------------------------
   def parse_known_args(self):
       """Parse command-line arguments and re-direct logging output to the file
          if specified"""
        
       args, extra_args = argparse.ArgumentParser.parse_known_args(self)
   
   
       if args.log_file is not None:
           # Set up the root logger
           date_format = '%a, %Y-%m-%d %H:%M:%S'
           message_format = '%(asctime)s %(name)s %(levelname)-8s %(message)s'
    
           logging.basicConfig(format = message_format,
                               level = logging.INFO,
                               datefmt = date_format,
                               filename = args.log_file,
                               filemode = 'w')

       # Remove option from sys.argv not to confuse unittest
       for index, each_arg in enumerate(sys.argv):
           if (args.log_file is not None) and (args.log_file in each_arg):
               del sys.argv[index]
               
       return (args, extra_args) 
