"""
Module ETASOneYearModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"


import os, datetime

import Environment, CSEPFile, CSEPLogging
from Forecast import Forecast
from OneYearForecast import OneYearForecast
from EEPASOneYearModel import EEPASOneYearModel


#--------------------------------------------------------------------------------
#
# ETAS-0F forecast model.
#
# This class is designed to invoke three-months PPE and ETAS forecast model. 
# It prepares input catalog data, formats control file with model parameters,
# and invokes the model. It places forecast file under user specified directory.
#
class ETASOneYearModel (EEPASOneYearModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = "ETAS" + OneYearForecast.Type
    
    
    #----------------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. EEPAS-ETAS models don't 
    #               require any configurable inputs by the CSEP system.
    #        param_file - Parameter file for a specific model configuration.
    #        use_weights - Flag if model shouuld use weights. Default is 0 (False).
    # 
    def __init__ (self, dir_path, args=None):
        """ Initialization for ETASModel class"""
        
        EEPASOneYearModel.__init__(self, 
                                   dir_path, 
                                   args,
                                   "nzetasoneyear.par")
        

    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return self.Type


    #---------------------------------------------------------------------------
    #
    # Write weight and likelihood directives if any are defined for the model
    #
    def writeWeightingLikelihood(self, fhandle):
        return fhandle
    

    #---------------------------------------------------------------------------
    #
    # Creates filename for PPE foreacast if it does not exist yet.
    #
    # Input:
    #        start_date - Start date of the forecast. Default is None.
    #
    # Output:
    #        Handle to the control file.
    def ppeForecastFile (self):
        """ Creates filename for PPE foreacast."""
        
        return self.filename().replace(self.type(), 
                                       self.type() + "PPE")
        

    #----------------------------------------------------------------------------
    #
    # Writes grid information that are specific to the model configuration.
    #
    # Input:
    #        fhandle - Handle to the open control file used to invoke the model.
    #
    # Output:
    #        Handle to the control file.
    #        
    def writeGrids (self, fhandle):
        """ Writes grid information that are specific to the model configuration."""

        fhandle.write("ETAGRID\n")
        
        return fhandle


    #---------------------------------------------------------------------------
    #
    # Return commands that should be used to capture version of external
    # software packages the model is dependent on. 
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    @staticmethod
    def externalSoftwareVersions ():
        """ Returns dictionary of command to determine external software 
            version and flag if output of that command is redirected to the
            stderr (True) or not (False) (java -version, for example)."""
        

        return {} 

