"""
Module SUPCanterburyOneYearModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

import os

import CSEPFile
from SUPCanterburyModel import SUPCanterburyModel
from Forecast import Forecast
from OneMonthForecast import OneMonthForecast
from CSEPStorage import CSEPStorage
from CatalogDataSource import CatalogDataSource


#-------------------------------------------------------------------------------
#
# SUP (stationary uniform Poisson forecast model) model for the Canterbury 
# experiment
#
# This class is designed to invoke one-year SUP forecast model. 
#
class SUPCanterburyOneMonthModel (OneMonthForecast, SUPCanterburyModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = SUPCanterburyModel.Type + OneMonthForecast.Type
    
    
    #---------------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for the class"""
        
        OneMonthForecast.__init__(self, 
                                  dir_path)
        SUPCanterburyModel.__init__(self, 
                                    self.inputCatalogFilename()) 
        

    #---------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return SUPCanterburyOneMonthModel.Type
    

    #---------------------------------------------------------------------------
    #
    # Write input parameter file for the model.
    #
    def writeParameterFile (self, 
                            filename = None):
        """ Format input parameter file for the model.
            Created file will be used by Fortran executable that invokes the
            model."""


        fhandle = Forecast.writeParameterFile(self)
        
        SUPCanterburyModel.writeFile(self,
                                     fhandle,
                                     self.catalogDir,
                                     self.start_date,
                                     self.end_date,
                                     self.filename())
        

    #----------------------------------------------------------------------------
    #
    # Prepare R execution script and invoke the model.
    #
    # Input: None
    #        
    def run (self):
        """ Generate forecast."""

        SUPCanterburyModel.invokeModel(self,
                                       self.catalogDir,
                                       self.inputCatalogFilename(),
                                       self.parameterFile)
        