#!/bin/tcsh

# batch_forecasts.tcsh:
#
# Evaluate forecasts using input catalog with lag of 11-16 years for Canterbury special study
#

source /data1/csep/CanterburyStudy/init.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`

# Capture all output produced by Dispatcher into the daily log file
set logfile=/data1/csep/CanterburyStudy/batchProcessing/logs/forecasts1997_2002_batch_"$year-$month-$day-$hour$min$sec"


# Invoke BatchProcessing for "today":
nohup python $CENTERCODE/src/generic/BatchProcessing.py --configFile=/data1/csep/CanterburyStudy/batchProcessing/configuration/batch_evaluate_lag17_25lag.init.xml --logFile="$logfile" >& "$logfile" &


