#!/bin/tcsh

# batch_forecasts.tcsh:
#
# Generate forecasts using input catalog up to 1991/09/03-2011/09/03 for Canterbury special study
#

source /data1/csep/CanterburyStudy/init.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`

# Capture all output produced by Dispatcher into the daily log file
set logfile=/data1/csep/CanterburyStudy/batchProcessing/logs/forecasts1991-2011_batch_"$year-$month-$day-$hour$min$sec"


# Invoke BatchProcessing for "today":
nohup python $CENTERCODE/src/generic/BatchProcessing.py --configFile=/data1/csep/CanterburyStudy/batchProcessing/configuration/batch_forecasts_catalog1991-2011.init.xml --logFile="$logfile" >& "$logfile" &


