#!/bin/tcsh

# batch_forecasts.tcsh:
#
# Generate forecasts using input catalog up to 1991/09/03-1995/09/03 for Canterbury special study:
# these forecasts were not generated due to "live" installation of NSHMBG model while batch processing
# was already running on omori
#

source /data1/csep/CanterburyStudy/init.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`

# Capture all output produced by Dispatcher into the daily log file
set logfile=/data1/csep/CanterburyStudy/batchProcessing/logs/forecasts1991-1995_batch_"$year-$month-$day-$hour$min$sec"


# Invoke BatchProcessing for "today":
nohup python $CENTERCODE/src/generic/BatchProcessing.py --configFile=/data1/csep/CanterburyStudy/batchProcessing/configuration/batch_forecasts_catalog1991-1995.init.xml --logFile="$logfile" >& "$logfile" &
