""" Copy configuration files to corresponding forecast groups directories."""

import shutil, os

CONFIG_FILE = 'forecastWithCatalog'
CONFIG_EXT = '.init.xml'
FORECAST_DIR = '/data1/csep/CanterburyStudy/forecasts'
GROUP_DIR = 'withCatalog'

for each_year in xrange(1986, 2012):

    config_file = CONFIG_FILE + repr(each_year) + CONFIG_EXT
    dest_file = os.path.join(FORECAST_DIR,
                             GROUP_DIR + repr(each_year),
                             'forecast.init.xml')
    print "Copying", config_file, "to", dest_file
    
    shutil.copyfile(config_file, 
                    dest_file)
