""" Create forecasts groups for evaluation of Canterbury special study forecasts
    (forecasts should be grouped by catalog lag in years):

    with0YearsLag/forecasts/archive: 1986_9 = withCatalog1986/forecasts/archive/1986_9
                                     1987_9 = withCatalog1987/forecasts/archive/1987_9
                                     ...
                                     2011_9 = withCatalog2011/forecasts/archive/2011_9

    with1YearLag/forecasts/archive: 1987_9 = withCatalog1986/forecasts/archive/1987_9
                                    1988_9 = withCatalog1987/forecasts/archive/1988_9
                                    ...
                                    2011_9 = withCatalog2010/forecasts/archive/2011_9

    with2YearLag/forecasts/archive: 1988_9 = withCatalog1986/forecasts/archive/1988_9
                                    1989_9 = withCatalog1987/forecasts/archive/1989_9
                                    ...
                                    2011_9 = withCatalog2009/forecasts/archive/2011_9
    
    ....
    
    with26YearLag/forecasts/archive: 2011_9 = withCatalog1986/forecasts/archive/2011_9
                                    
"""


import shutil, os

CONFIG_FILE = 'forecastWithCatalog'
CONFIG_EXT = '.init.xml'

FORECAST_DIR = '/data1/csep/CanterburyStudy/forecasts'
EVALUATION_DIR = '/data1/csep/CanterburyStudy/evaluation'

GROUP_DIR = 'withCatalog'

# Remember current directory
current_dir = os.getcwd()
first_year = 1986
last_year = 2011

dry_run = True

for each_index, each_year in enumerate(xrange(1986, 2012)):

    print "Index=", each_index, "Year=", each_year
    
    # Group directory
    group_name = "with%sYearLag" %each_index
    group_dir = os.path.join(EVALUATION_DIR,
                             group_name)
    group_archive_dir = os.path.join(group_dir,
                                     'forecasts',
                                     'archive')
    
    if dry_run is False: 
        os.makedirs(group_archive_dir)
        os.chdir(group_archive_dir)
    
    # Create soft links to existing FORECAST_DIR/withCatalog* archived directories
    # with the same lag in years
    group_start_year = each_year
    link_start_year = first_year
    
    while group_start_year <= last_year:

        # Create soft link to original forecast archive directory under
        # evaluation group
        original_dir = os.path.join(FORECAST_DIR,
                                    GROUP_DIR + '%s' %link_start_year,
                                    'forecasts',
                                    'archive')
        archive_group = '%s_9' %group_start_year
        
        print "Creating link %s (in %s) to %s" %(archive_group,
                                                 group_archive_dir,
                                                 os.path.join(original_dir,
                                                              archive_group))

        if dry_run is False:
            os.symlink(os.path.join(original_dir,
                                    archive_group),
                       archive_group)
         
        group_start_year += 1
        link_start_year += 1
    
    # Copy configuration file for the evaluation group
    config_file = os.path.join(current_dir,
                               CONFIG_FILE + repr(each_year) + CONFIG_EXT)
    dest_file = os.path.join(group_dir,
                             'forecast.init.xml')
    print "Copying", config_file, "to", dest_file
    if dry_run is False:
        shutil.copyfile(config_file, 
                        dest_file)
    print ""

if dry_run is False:
    os.chdir(current_dir)

