#!/bin/tcsh

# one_year_forecasts.tcsh:
#
# Generate forecasts using "best available" input catalog from GeoNet
#

source /home/csep/DarfieldExperiment/bestAvailableTC/init.nohash.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`
mkdir -p /home/csep/DarfieldExperiment/bestAvailableTC/logs
mkdir -p /home/csep/DarfieldExperiment/bestAvailableTC/batch/logs
mkdir -p /home/csep/DarfieldExperiment/bestAvailableTC/batch/runs

# Capture all output produced by Dispatcher into the daily log file
set logfile=/home/csep/DarfieldExperiment/bestAvailableTC/batch/logs/forecastsOneDayBestAvailableTC_"$year-$month-$day-$hour$min$sec"


# Invoke BatchProcessing for "today":
nohup python $CENTERCODE/src/generic/BatchProcessing.py --configFile=/home/csep/DarfieldExperiment/bestAvailableTC/batch/config/batch_one_day_forecasts_v3.init.xml --logFile="$logfile" >& "$logfile" &
