#!/bin/tcsh

# dispatcher_daily.csh:
#
# Run daily Dispatcher for one day models generation and evaluation
#

source /scratch/matthew/operations/csep/cshrc_csep

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`

# Capture all output produced by Dispatcher into the daily log file
set logdir=$CSEP/dispatcher/logs/"$year"_"$month"
mkdir -p "$logdir"

set logfile=$logdir/daily_"$year-$month-$day-$hour$min$sec"


# Invoke Dispatcher for "today" (with 31 day delay for the testing date):
nohup python $CENTERCODE/src/generic/Dispatcher.py --year="$year" --month="$month" --day="$day" --configFile=$CENTERCODE/src/SCECModels/NewZealand/configuration/crontab/dispatcher_daily.init.xml --waitingPeriod=31 --enableForecastXMLTemplate --enableForecastMap --publishServer=csep-nz@scec.usc.edu --publishDirectory=/var/www/html/csep/nz/results/data/nz/gns --logFile="$logfile" >& "$logfile" &


