function[mOutput] = getCatalog_Import_NZ(sFilename)


global ZMAP_Longitude;
global ZMAP_Latitude;
global ZMAP_DecimalYear;
global ZMAP_Month;
global ZMAP_Day;
global ZMAP_Magnitude;
global ZMAP_Depth;
global ZMAP_Hour;
global ZMAP_Minute;
global ZMAP_Second;

global ZMAP_HorizontalError;
global ZMAP_DepthError;
global ZMAP_MagnitudeError;
global ZMAP_NetworkName;


fid = fopen(sFilename);

C = textscan(fid, '%n%n%n%n%n%n%n%n%n%n%n%n%n%n', 'CollectOutput', 1);
fclose(fid);

% Create catalog in ZMAP format

nCols = 14;
[nRows, cols] = size(C{1});

mOutput = zeros(nRows, nCols);

% No need to populate empty catalog
if ~isempty(mOutput)

    % Longitude
    mOutput(:,ZMAP_Longitude) = C{1}(:,ZMAP_Longitude);
    
    % Latitude
    mOutput(:,ZMAP_Latitude) = C{1}(:,ZMAP_Latitude);

    % Decimal Year    
    mOutput(:,ZMAP_DecimalYear) = C{1}(:,ZMAP_DecimalYear);
    
    % Month
    mOutput(:,ZMAP_Month) = C{1}(:,ZMAP_Month);
    
    % Day
    mOutput(:,ZMAP_Day) = C{1}(:,ZMAP_Day);
    
    % Magnitude
    mOutput(:,ZMAP_Magnitude) = C{1}(:,ZMAP_Magnitude);
    
    % Depth
    mOutput(:,ZMAP_Depth) = C{1}(:,ZMAP_Depth);
    
    % Hour
    mOutput(:,ZMAP_Hour) = C{1}(:,ZMAP_Hour);
    
    % Minutes
    mOutput(:,ZMAP_Minute) = C{1}(:,ZMAP_Minute);
    
    % Seconds
    mOutput(:,ZMAP_Second) = C{1}(:,ZMAP_Second);

    % Horizontal error
    mOutput(:,ZMAP_HorizontalError) = C{1}(:,ZMAP_HorizontalError);

    % Events don't have horizontal error provided will have NaN values,
    % replace with default error    
    vSel = isnan(mOutput(:,ZMAP_HorizontalError));
    mOutput(vSel,ZMAP_HorizontalError) = 2;  % Default horizontal error

    % Depth error
    mOutput(:,ZMAP_DepthError) = C{1}(:,ZMAP_DepthError);

    % Events don't have depth error provided will have NaN values,
    % replace with default error    
    vSel = isnan(mOutput(:,ZMAP_DepthError));
    mOutput(vSel,ZMAP_DepthError) = 5;  % Default depth error

    % Magnitude error
    mOutput(:,ZMAP_MagnitudeError) = C{1}(:,ZMAP_MagnitudeError);

    % Events don't have depth error provided will have NaN values,
    % replace with default error    
    vSel = isnan(mOutput(:,ZMAP_MagnitudeError));
    mOutput(vSel,ZMAP_MagnitudeError) = 0.1;  % Default depth error

    mOutput(:,ZMAP_NetworkName) = 1;       % Seismic Network - always from Geonet

end;


% Condition data 
vSel = (mOutput(:, ZMAP_Magnitude) >= 0.0);
mOutput = mOutput(vSel, :);

% Check if downloaded catalog has valid error values (must be non-zero)

% Horizontal error can't be equal to zero
vSel = (mOutput(:, ZMAP_HorizontalError) == 0.0);
mOutput(vSel, ZMAP_HorizontalError) = 2.0;  % Default horizontal error

% Depth error can't be equal to zero
vSel = (mOutput(:, ZMAP_DepthError) == 0.0);
mOutput(vSel, ZMAP_DepthError) = 5.0;  % Default depth error

