""" Utility to create test and collection areas for Darfield region"""

__version__  = '$Id$'
__revision__ = '$Revision$'

import sys
import CSEPFile


def ext_range(start, end, step):
    while start <= end:
        yield start
        start += step


if __name__ == '__main__':

  # Darfield collection region in the following format:
  # min latitude, max latitude, min longitude, max longitude
  # -45.0   -42.0   170.0   174.5
  test_file = "getCatalog_CollectionArea_Darfield.dat"
  fhandle = CSEPFile.openFile(test_file,
                              CSEPFile.Mode.WRITE)
  
  for fLon in ext_range(170.05, 174.45, 0.1):
    for fLat in ext_range(-44.95, -42.049, 0.1):
      fhandle.write("%s\t%s\n" %(fLon, fLat))

  fhandle.close()
        
  # Darfield test region in the following format:
  # min latitude, max latitude, min longitude, max longitude
  
  # -44.5   -42.5   170.5   174.0
  test_file = "getCatalog_TestArea_Darfield.dat"
  fhandle = CSEPFile.openFile(test_file,
                              CSEPFile.Mode.WRITE)
  
  for fLon in ext_range(170.55, 173.95, 0.1):
    for fLat in ext_range(-44.45, -42.549, 0.1):
      fhandle.write("%s\t%s\n" %(fLon, fLat))

  fhandle.close()
