#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-


############################################################################
#    Copyright (C) 2007 by Danijel Schorlemmer                             #
#    ds@usc.edu                                                            #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

"""
Code adopted by Masha Liukis to generate master XML template for Darfield 
experiment.
"""

__version__  = '$Id: pov2cpt.py 240 2009-10-19 21:16:09Z danijel $'
__revision__ = '$Revision: 240 $'
__author__   = "Danijel Schorlemmer <ds@usc.edu>"
__license__  = "GPL"

import sys
import getopt

def main():
  # Set defaults
  ftOutput = sys.stdout
  
  sCmdParams = sys.argv[1:]
  opts, args = getopt.gnu_getopt(sCmdParams, 'ho', ['help', 'output='])
  
  for option, parameter in opts:
    if option in ['-o', '--output']:
        ftOutput = file(parameter, "w")
        
    if option in['-h', '--help']:
      print 'Creates the Darfield forecast template'
      print 'Version 1.0 [25.11.2013]'
      print 'Usage: create.forecast.template.darfield.py [OPTION]'
      print '   -o, --output=<filename>    output to file instead of stdout'
      sys.exit()


  ftOutput.write('<?xml version="1.0"?>' + '\n')
  ftOutput.write('<CSEPForecast xmlns="http://www.scec.org/xml-ns/csep/forecast/0.1">' + '\n')
  ftOutput.write('  <forecastData publicID="smi://org.scec/csep/forecast/1">' + '\n')
  ftOutput.write('    <modelName>Put your model name here</modelName>' + '\n')
  ftOutput.write('    <!-- version is a free-form string, but mandatory -->' + '\n')
  ftOutput.write('    <version>Put your version number here</version>' + '\n')
  ftOutput.write('    <author>Put your name here</author>' + '\n')
  ftOutput.write('    <!-- authorURI is optional -->' + '\n')
  ftOutput.write('    <authorURI>smi://org.scec/persons/familyname_firstname</authorURI>' + '\n')
  ftOutput.write('    <!-- issueDate has to be given in UTC -->' + '\n')
  ftOutput.write('    <issueDate>2013-11-19T09:09:07Z</issueDate>' + '\n')
  ftOutput.write('    <!-- forecastStartDate has to be given in UTC -->' + '\n')
  ftOutput.write('    <forecastStartDate>2010-09-03T16:35:42Z</forecastStartDate>' + '\n')
  ftOutput.write('    <forecastEndDate>2010-09-04T16:35:42Z</forecastEndDate>\n')
  ftOutput.write('    <defaultCellDimension lonRange="0.1" latRange="0.1"/>' + '\n')
  ftOutput.write('    <defaultMagBinDimension>0.1</defaultMagBinDimension>' + '\n')
  ftOutput.write('    <lastMagBinOpen>1</lastMagBinOpen>\n')
  ftOutput.write('    <depthLayer min="0" max="40">' + '\n')
  for fLon in ext_range(170.55, 173.95, 0.1):
    for fLat in ext_range(-44.45, -42.45, 0.1):
      sLine = '      <cell lon="' + str(fLon) + '" lat="' + str(fLat) + '">\n'
      for fMag in ext_range(4.0, 8.0, 0.1):
          sLine += '         <bin m="' + str(fMag) + '">0.0</bin>\n'
      sLine += '      </cell>\n'
      ftOutput.write(sLine)
  ftOutput.write('    </depthLayer>' + '\n')
  ftOutput.write('  </forecastData>' + '\n')
  ftOutput.write('</CSEPForecast>' + '\n')

    
# ---
def ext_range(start, end, step):
    while start <= end:
        yield start
        start += step

main()
