/*
 * setup_eqkfm.c
 *
 *  Created on: Jul 24, 2013
 *      Author: camcat
 */


#include "setup.h"


int setup_catalogetc(char *catname, char *focmeccat, char *fm_format, struct tm reftime, double dDCFS, double Mag_main, struct crust crst,
		struct catalog *cat, struct eqkfm **eqkfm1, double ***focmec,struct flags flag, int *NFM, int *Ntot, int *Nmain,
		double dt, double dM, double xytoll, double ztoll, double dR, double tw, double tstartLL, double tstartData, double Mc_source){
//  focmec will contain matrix with focal mechanisms (*NFM of them). can be null, and will be ignored.
//	double t0, double tw1, double tw2, double t1 =	tstartLL, tmain[0], tmain[0]+tw, fmax(tendLL,Tend)
//  dt, dM, xytoll, ztoll: expected difference b/t/ events from catalog and focmec catalog; dR= extra distance to be considered for sources.
//	focal mechanisms are ignored if focmeccat is NULL.
//  tstartLL: start of LL inversion (only focal mechanisms before this time will be included).
//  tstartData: time after which which events should be included as sources.


//todo make sure that first focal mechanism is the best oriented.
//todo only include as sources events large enough to affect more than 1 grid point...
//todo so far, many events are selected and  eqkfm[n].nsel=0 is used to deactivate them. This is a waste (donw this way to avoid messing up indices, but should be changed).
//todo check Mc_source works.

	struct eqkfm *eqkfm1fm;
	double tstartS, tendS, tstartCat, tendCat;
	int err=0, errP, NgridT=crst.N_allP;
	int Nfm;
	if (verbose_level>0) printf("Setting up catalog...\n");

	tstartS=tstartCat=tstartData;
	tendS=tendCat=0;		//this is the "IssueDate", up to which data is available.

	//select events within some tolerance level, since they will have to be matched with focal mechanisms.
	err+=readZMAP(cat, eqkfm1, Ntot, catname, crst, reftime, tstartS, tendS, tstartCat, tendCat, Mag_main, tw, fmax(xytoll, dR), fmax(ztoll, dR), dDCFS, 1);

	if (err) {
		if (verbose_level) printf("Errors in reading catalog file. Exiting.\n");
		fflush(stdout);
		if (flog) {
			fprintf(flog,"Errors in reading catalog file. Exiting.\n");
			fflush(flog);
		}
		return (1);
	}

	//fixme check that foc mec are read when aftershocks==1.
	if (flag.aftershocks){
		if (focmeccat){
			err+=readfocmec(focmeccat, fm_format, crst, fmax(xytoll, dR), fmax(ztoll, dR), dDCFS, reftime, tstartS, tendS, tendS, (*cat).Mc, focmec, NFM, &Nfm, &eqkfm1fm, 1, 1);
			errP=combine_eqkfm(*eqkfm1, eqkfm1fm, *Ntot, Nfm, tendS, dt, dM, xytoll, 1);
			//err+=(errP==NULL);	//commented since foc mec catalog may not be available.
		}
		if (flag.aftershocks) eqk_filter(eqkfm1, Ntot, (Mc_source>20) ? (*cat).Mc : Mc_source, crst.depmax+fmax(dR,ztoll),1);
		else eqk_filter(eqkfm1, Ntot, Mag_main, crst.depmax+fmax(dR,ztoll), 1);	//only keep mainshocks.

		eqkfm2dist((*eqkfm1), crst.lat, crst.lon, crst.depth, NgridT, *Ntot, 1);
	}

	else {
		err+=readfocmec(focmeccat, fm_format, crst, fmax(xytoll, dR), fmax(ztoll, dR), dDCFS, reftime, tstartS, tendS, tendS, Mag_main, focmec, NFM, &Nfm, &eqkfm1fm, 1, 1);
		errP=combine_eqkfm(*eqkfm1, eqkfm1fm, *Ntot, Nfm, tendS, dt, dM, xytoll, 1);
		//err+=(errP==NULL);
		eqk_filter(eqkfm1, Ntot, Mag_main, crst.depmax+fmax(dR,ztoll), 1);	//only keep mainshocks.
		eqkfm2dist((*eqkfm1), crst.lat, crst.lon, crst.depth, NgridT, *Ntot, 1);
	}

	if (Nmain) *Nmain=0;
	for (int i=0; i<(*Ntot); i++) {
		if ((*eqkfm1)[i].mag>=Mag_main) {
			(*eqkfm1)[i].is_mainshock=1;
			if (Nmain) *Nmain+=1;
		}
		else{
			if (flag.only_aftershocks_withfm && !(*eqkfm1)[i].is_slipmodel) (*eqkfm1)[i].nsel=0;
			if (flag.full_field==0) (*eqkfm1)[i].is_slipmodel=0;
		}
	}

	if (verbose_level>0) printf("%d events used for catalog, %d events used as sources, %d of which mainshocks.\n", (int) (*cat).Z, *Ntot, *Nmain);
	if (flog) {
		fprintf(flog,"%d events used for catalog, %d events used as sources, %d of which mainshocks.\n", (int) (*cat).Z, *Ntot, *Nmain);
		fflush(flog);
	}
	return (err!=0);

}

int setup_eqkfm(struct slipmodels_list list_slipmodels, struct crust crst, int resample, struct eqkfm **eqkfm0res){
//input models are the models to be used at a given time (NB: only one model per event).
//is_afterslip indicates that all models have same geometry: Nfaults and no_slipmodels only have 1 element.

	int Nm=list_slipmodels.NSM;
	double *tmain=list_slipmodels.tmain;
	char **slipmodels=list_slipmodels.slipmodels;
	char **multimodels=list_slipmodels.multimodels;
	int *no_slipmodels=list_slipmodels.no_slipmodels;
	double *disc=list_slipmodels.disc;
	int *Nfaults=list_slipmodels.Nfaults;
	int is_afterslip=list_slipmodels.is_afterslip;
	double d_touching_faults=3.0;	//todo: set somewhere else.
    int NFtot=0;
    int err=0;
    int nn2;

    if (is_afterslip==0) {
    	for (int nn=0; nn<Nm; nn++) {
        	if (farfalle) read_farfalle_eqkfm(slipmodels[nn], NULL, Nfaults+nn);
			else read_pscmp_eqkfm(slipmodels[nn], NULL, Nfaults+nn);
			NFtot+=Nfaults[nn];
    	}
    }
    else {
    	if (farfalle) err+=read_farfalle_eqkfm(slipmodels[0], NULL, Nfaults);
    	else err+=read_pscmp_eqkfm(slipmodels[0], NULL, Nfaults);
    	NFtot=Nfaults[0]*Nm;
    }

    *eqkfm0res=eqkfm_array(0, NFtot-1);

    //TODO: implement multiple slip models with non strike slip event.
    NFtot=0;
    for (int nn=0; nn<Nm; nn++){

    	nn2= is_afterslip? 0 : nn;	//for afterslip, all snapshots have same no. of slip models and faults.
    	//don't pass mmain since it should already be defined
    	err+=setup_eqkfm_element((*eqkfm0res)+NFtot, slipmodels[nn], multimodels[nn2], no_slipmodels[nn2], crst.mu, disc[nn2], tmain[nn], d_touching_faults, crst.N_allP, crst.list_allP, NULL, resample, (is_afterslip+1)%2, Nfaults+nn2, crst.lat0, crst.lon0);
		NFtot+=Nfaults[nn2];
	}

    return(err);
}

int setup_eqkfm_element(struct eqkfm *eqkfm0res, char *slipmodel, char *multimodels, int no_slipmodels, double mu, double disc,
		double tmain, double d_close, int nsel, int *sel_pts, double *mmain, int resample, int tap_bot, int *NF0, double lat0, double lon0){

	struct eqkfm *eqkfm0;
	int err=0, NF;

	err=read_eqkfm(slipmodel, &eqkfm0, &NF, mmain, mu);
	if (err){
		if (verbose_level>0) printf(" ** Error: Input slip model %s could not be read (setup_eqkfm_element). **\n", slipmodel);
		return (1);
	}
	which_taper(eqkfm0, NF, tap_bot, 0, d_close);

	(*eqkfm0).Nmod=no_slipmodels;
	if (no_slipmodels>1){
		if (NF>1) {
			if (verbose_level>0) printf("ERROR! Can not handle multiple input slip models on more than 1 fault, or with afterslip! Exit\n");
			return(1);
		}
		(*eqkfm0).stored_slip_str=dmatrix(1,no_slipmodels,1,(*eqkfm0).np_di*(*eqkfm0).np_st);
		read_matrix(multimodels, no_slipmodels,0,(*eqkfm0).stored_slip_str, (long *)0);
	}

	for (int nf=0; nf<NF; nf++) {
		eqkfm0[nf].t=tmain;
		eqkfm0[nf].nsel=nsel;
		eqkfm0[nf].selpoints=sel_pts;
    	latlon2localcartesian(eqkfm0[nf].lat, eqkfm0[nf].lon, lat0, lon0, &(eqkfm0[nf].y), &(eqkfm0[nf].x));
		for (int i=1; i<=(*eqkfm0).Nmod; i++){
			if (eqkfm0[nf].Nmod>1) eqkfm0[nf].slip_str=eqkfm0[nf].stored_slip_str[i];
			if (resample==1) err+=suomod1_resample(eqkfm0[nf], eqkfm0res+nf, disc, 0.0);	//create a slip model with right resolution.
			else err+=suomod1_taper(eqkfm0[nf], eqkfm0res+nf);	//just taper old slip model.
			if (eqkfm0[nf].Nmod>1) {
				if (i==1) (*eqkfm0res).stored_slip_str=dmatrix(1,eqkfm0[nf].Nmod,1,(*eqkfm0res).np_di*(*eqkfm0res).np_st);
				eqkfm0res[nf].stored_slip_str[i]=eqkfm0res[nf].slip_str;
			}
		}
	}

	if (NF0) *NF0=NF;
	return err;
}

int setup_CoeffsDCFS(struct Coeff_LinkList **Coefficients, struct pscmp **DCFS_out, struct crust crst, struct eqkfm *eqkfm0,
		struct eqkfm *eqkfm1, int Nm, int Ntot, int *Nfaults, int *which_main, double tstart, int afterslip){
	//set Ntot=0 if aftershocks should not be considered.
	//if afterslip==1, need to load Coeff for the first event (fixme: make this more flexible, afterslip should not have geometry contrained by first event).

	struct pscmp *DCFS;
    struct Coeff_LinkList *AllCoeff, *temp;
    int NFsofar=0, Nsel, Nsteps, NFtot, eq, need_this_event;
    double M0;

    //----------set up Coefficients----------------//

    if (Coefficients!=NULL){
    	if (flog) fprintf(flog, "Setting up okada coefficients for mainshocks, starting from t=%.5lf.\n", tstart);
		AllCoeff= malloc( sizeof(struct Coeff_LinkList));	//TODO deallocate at the end.
		temp= AllCoeff;
		for (int i=0; i<Nm; i++){
			//second condition since afterslip uses same geometry as first event.
			need_this_event= (eqkfm0[NFsofar].t>=tstart) || (afterslip && NFsofar==0);
			if (eqkfm0[NFsofar].is_slipmodel && need_this_event) {
				okadaCoeff(&(temp->Coeffs_st), &(temp->Coeffs_dip), eqkfm0+NFsofar, Nfaults[i], crst, crst.lat, crst.lon, crst.depth);
				if (flog){
					fprintf(flog, "Okada Coefficients calculated for mainshock at t=%.5lf\n", eqkfm0[NFsofar].t);
					fflush(flog);
				}
			}
			else temp->Coeffs_st=temp->Coeffs_dip=NULL;
			temp->NgridT=eqkfm0[0].nsel;
			temp->NF=Nfaults[i];
			temp->NP=0;
			for (int f=0; f<Nfaults[i]; f++) temp->NP+= eqkfm0[NFsofar+f].np_di*eqkfm0[NFsofar+f].np_st;
			temp->which_main=which_main[i];
			NFsofar+=Nfaults[i];
			if (i<Nm-1) {
				temp->next= malloc(sizeof(struct Coeff_LinkList));
				temp= temp->next;
			}
			else temp->next=(struct Coeff_LinkList *) 0;
		}
		*Coefficients=AllCoeff;
    }

    //--------------set up DCFS-------------------//

    if (DCFS_out!=NULL){
		Nsteps= (Ntot>Nm) ? Ntot : Nm;
		DCFS=pscmp_arrayinit(crst,0,Nsteps-1);

		for (int eq1=0; eq1<Ntot; eq1++){
			Nsel = eqkfm1[eq1].nsel;
			DCFS[eq1].NF=1;
			DCFS[eq1].index_cat=eqkfm1[eq1].index_cat;
			DCFS[eq1].which_pts=eqkfm1[eq1].selpoints;
			DCFS[eq1].fdist=eqkfm1[eq1].distance;
			DCFS[eq1].nsel=Nsel;
			DCFS[eq1].t=eqkfm1[eq1].t;
			DCFS[eq1].m=eqkfm1[eq1].mag;
			if (Nsel>0){
				DCFS[eq1].S = d3tensor(1,Nsel,1,3,1,3);
				DCFS[eq1].cmb=dvector(1,Nsel);
				for (int i=1; i<=Nsel; i++) DCFS[eq1].cmb[i]=0.0;
			}
		}

		NFtot=0;
		//substitute mainshocks:
		for (int eq1=0; eq1<Nm; eq1++){
			eq= which_main[eq1];
			Nsel = eqkfm0[NFtot].nsel;
			DCFS[eq].fdist=eqkfm0[NFtot].distance;
			DCFS[eq].index_cat=eqkfm0[NFtot].index_cat;
			DCFS[eq].which_pts=eqkfm0[NFtot].selpoints;
			DCFS[eq].t=eqkfm0[NFtot].t;
			M0=0.0;
			for (int f=0; f<Nfaults[eq1]; f++) M0+=pow(10,1.5*(eqkfm0[NFtot+f].mag+6));
			DCFS[eq].m=(2.0/3.0)*log10(M0)-6;
			DCFS[eq].NF=Nfaults[eq1];
			if (DCFS[eq].nsel!=Nsel){
				if (DCFS[eq].nsel>0){
					free_d3tensor(DCFS[eq].S,1,DCFS[eq].nsel,1,3,1,3);
					free_dvector(DCFS[eq].cmb,1,DCFS[eq].nsel);
				}
				DCFS[eq].nsel=Nsel;
				DCFS[eq].S = d3tensor(1,Nsel,1,3,1,3);
				DCFS[eq].cmb=dvector(1,Nsel);
				for (int i=1; i<=Nsel; i++) DCFS[eq].cmb[i]=0.0;
			}
			NFtot+=Nfaults[eq1];
		}

		*DCFS_out=DCFS;
    }

    if (flog){
    	fprintf(flog,"DCFS Coefficients structure calculated.\n");
    	fflush(flog);
    }
    return(0);
}

int setup_afterslip_evol(double Teq, double t0, double t1, double *Cs, double *ts, int Nfun, struct eqkfm **eqk_aft, double *t_afterslip, int Nas,int Nfaults,
		int afterslip, int *L, double **times2, double **tevol_afterslip, long *seed){

//if splines are, eqk_aft is substituted with more densily discretized version (L steps instead of Nas).
//Cs, ts, coefficients of temporal evolution functions (See Savage Parkfield paper). Nfun: no. of such funtions.
//t_afterslip indices: [0,1,2,...Nas-1].
// eq_aft has indices: [0...Nas*Nfaults-1].

	int L0=0, NFL, i;
	int splines;
	double TAU=200000, dtau=(afterslip==0)? 10000 : 700;
	double Kotau;
	double M0,mu;
	double smallstepstime=10;
	double now, prev, norm, curr;
	double Tendaft=t_afterslip[Nas-1];	//Time to which cumulative afterslip snapshot refers.
	struct eqkfm *eq_aft, *eqkfm_aftsplines;

	eq_aft= *eqk_aft;

	splines=(Nas>1)? 1 : 0;
	//todo find L first, then setup vectors.
	*times2=dvector(0,*L-1);
	*tevol_afterslip=dvector(0,*L-1);

	findtimestepsomori(Teq, t0, fmin(smallstepstime,t1), 0, 183, TAU, 0.3*dtau, 0.6, 0.001, (*times2)+1, &Kotau, L);
	if (smallstepstime<t1) findtimestepsomori(Teq, smallstepstime, t1, 0, 183, TAU, dtau, 0.6, 0.001, (*times2)+*L+1, &Kotau, &L0);
	*L+=L0+1;
	(*times2)[0]=Teq-1e-4;

	// Temporal evolution of afterslip.//
	M0=pow(10,1.5*(eq_aft[(Nas-1)*Nfaults].mag+6.0));
	mu=M0/(eq_aft[(Nas-1)*Nfaults].tot_slip*eq_aft[(Nas-1)*Nfaults].L*eq_aft[(Nas-1)*Nfaults].W*1e12);

	if (afterslip!=0){
		if (splines==0){
			norm=0.0;
			for (int i=0; i<Nfun; i++) norm+=Cs[i]*log(1+(Tendaft-Teq)/ts[i]);
			now=0.0;
			curr=0.0;

			for (int t=1; t<=*L; t++){
				prev=curr;
				now= (*times2)[t]-Teq;
				curr=0.0;
				for (int i=0; i<Nfun; i++) curr+=Cs[i]*log(1+now/ts[i]);
				(*tevol_afterslip)[t-1]= (curr-prev)/norm;
			}
		}
		else{
			//todo double check indexing of eqkfm_aftsplines (NB t_afterslip and afterslip_models has been changed, so indices are [0...Nas-1]).
			NFL=Nfaults*(*L);
			eqkfm_aftsplines=eqkfm_array(0,Nfaults*(*L+1));
			splines_eqkfm(eq_aft-1, Nas, Nfaults, t_afterslip-1, (*times2)-1, *L, eqkfm_aftsplines-1, seed);

			for (int f=0; f<Nfaults; f++) {
				for (int l=*L-1; l>=0; l--) eqkfm_aftsplines[Nfaults*l+f].tot_slip=0.0;
				copy_eqkfm_all(eqkfm_aftsplines[Nfaults*(*L-1)+f], eqkfm_aftsplines+NFL+f);
				eqkfm_aftsplines[NFL+f].slip_str=dvector(1,eq_aft[f].np_di*eq_aft[f].np_st);
				eqkfm_aftsplines[NFL+f].slip_dip=dvector(1,eq_aft[f].np_di*eq_aft[f].np_st);
				for (int p=1; p<=eq_aft[f].np_di*eq_aft[f].np_st; p++) {
					//copy cumulative value at the end of array (will be needed later to calculate random high freq. slip).
					eqkfm_aftsplines[NFL+f].slip_str[p]=eqkfm_aftsplines[Nfaults*(*L-1)+f].slip_str[p];
					eqkfm_aftsplines[NFL+f].slip_dip[p]=eqkfm_aftsplines[Nfaults*(*L-1)+f].slip_dip[p];
					eqkfm_aftsplines[NFL+f].tot_slip+=sqrt(pow(eqkfm_aftsplines[NFL+f].slip_str[p],2)+pow(eqkfm_aftsplines[NFL+f].slip_dip[p],2));
					for (int l=*L; l>1; l--) {
						i=Nfaults*(l-1)+f;
						eqkfm_aftsplines[i].slip_str[p]-=eqkfm_aftsplines[i-Nfaults].slip_str[p];
						eqkfm_aftsplines[i].slip_dip[p]-=eqkfm_aftsplines[i-Nfaults].slip_dip[p];
						eqkfm_aftsplines[i].tot_slip+=sqrt(pow(eqkfm_aftsplines[i].slip_str[p],2)+pow(eqkfm_aftsplines[i].slip_dip[p],2));
					}
				 }
				for (int l=0; l<NFL+Nfaults; l++){
					eqkfm_aftsplines[l].tot_slip*=(1.0/(eqkfm_aftsplines[l].np_di*eqkfm_aftsplines[l].np_st));
					M0=mu*eqkfm_aftsplines[l].tot_slip*eqkfm_aftsplines[l].L*eqkfm_aftsplines[l].W*1e12;
					eqkfm_aftsplines[l].mag=(2.0/3.0)*log10(M0)-6.0;
				}

			}
			*eqk_aft=eqkfm_aftsplines;
		}
	}

	else {
		for (int t=1; t<=*L; t++) (*tevol_afterslip)[t-1]=0;
	}

	return(0);
}

//obsolete?//

//int load_newdata(double *t0, double t1, struct set_of_models *allmodels, int Nmain, int *Nfaults, char **slipmodels, char **multimodels,
//		int *no_slipmodels, int *Nmain_now){
//
////updates names of most recen slip models available, no. of mainshocks, etc. Returns boolean indicating if there were changes.
//
//	int c;
//	int newdata=0, Npre=0;
//
//	for (int m=0; m<Nmain; m++){
//
//		if (allmodels[m].t0<=t1){
//			Npre+=1;
//			c=0;
//			while (c+1<allmodels[m].Nmod && allmodels[m].t_mod[c+1]<=t1) c++;
//			if (allmodels[m].t_mod[c]>*t0){
//				newdata=1;
//				strcpy(slipmodels[m],allmodels[m].filename[c]);
//				if (multimodels!=0) sprintf(multimodels[m],"/0");
//				no_slipmodels[m]=1;
//				Nfaults[m]=allmodels[m].NF_models[c];
//			}
//		}
//	}
//
//	*Nmain_now=Npre;
//	return newdata;
//
//}

//int mask_afterslip(double time, double *times, int L, double *evol_afterslip0, double **evol_afterslip, int *Lnow){
//
////Lnow contains no. of elements in evol_afterslip up to that point.
//
//	int counter=*Lnow;
//	if (*Lnow==L) return(0);	//all elements already included.
//
//	if (*evol_afterslip==0) {
//		(*evol_afterslip)=dvector(0,L-1);
//		for (int j=0; j<L; j++) (*evol_afterslip)[j]=0.0;
//	}
//	while (counter < L && times[counter]<=time) {
//		(*evol_afterslip)[counter]=evol_afterslip0[counter];
//		counter++;
//	}
//
//	return(0);
//}

