#include "print_output.h"

//void printCSEPforecast(char *filename, double *lats, double *lons, double *deps, double *mags, double *rates, double *mag_fact, int NG, int Nmag){
//
//	double Lat1,Lat2,Lon1,Lon2, D1, D2;
//	double dlat, dlon, ddep;
//	FILE *fout;
//	fout=fopen(filename,"w");
//	counter=1;
//	while (lons[counter]==lons[1]) counter++;
//	dlon= lons[counter]-lons[1];
//	counter=1;
//	while (lats[counter]==lats[1]) counter++;
//	dlat= lats[counter]-lats[1];
//	counter=1;
//	while (deps[counter]==deps[1]) counter++;
//	ddep= deps[counter]-deps[1];
//
//	for (int m=1; m<=Nmag; m++){
//		for (int k=1; k<=NG; k++){
//			Lon1=lons[k]-dlon/2.0;
//			Lon2=lons[k]+dlon/2.0;
//			Lat1=lats[k]-dlat/2.0;
//			Lat2=lats[k]+dlat/2.0;
//			D1=depths[k]-ddep/2.0;
//			D2=depths[k]+ddep/2.0;
//			M1=mags[m]-dmag/2.0;
//			M2=mags[m]+dmag/2.0;
//			fprintf(foutLoop2,"%.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \n", Lon1, Lon2, Lat1, Lat2, D1,D2, M1, M2, rates[k]*mag_fact[m]);
//		}
//	}
//	fclose(fout);
//
//	return;
//}

int sum_DCFS(struct pscmp *DCFS, double **cmb, int N, int Ntot){
//adds up all DCFS[0...N-1], and returns vector cmb containing cumulative field.
//Ntot: total no. of grid points.
//if *cmb==NULL memory is allocated, otherwise not (make sure vector has correct no. of elements).

	int i;

	if (*cmb==NULL) *cmb=dvector(1,Ntot);
	for (int k=1; k<=Ntot; k++) (*cmb)[k]=0.0;


	for (int n=0; n<N; n++){
		i=1;
		for (int k=1; k<=Ntot; k++){		//todo check if this works with DCFS.nsel<Ntot.
			if (i<=DCFS[n].nsel && DCFS[n].which_pts[i]==k) {
				(*cmb)[k]+=DCFS[n].cmb[i];
				i++;
			}
		}
	}

	return 0;

}

void printmatrix(double **S){
	//printout 3x3 matrix

	for (int ii=1; ii<=3; ii++) {
		for (int jj=1; jj<3; jj++) printf("%.3lf\t",S[ii][jj]);
		if (ii<3) printf("%.3lf\n",S[ii][3]);
		else  printf("%.3lf]\n",S[ii][3]);
	}

	return;

}

int print_cat(char *fname, struct catalog cat){
/*uses following format:
 * 1. Longitude [deg]
   2. Latitude [deg]
   3. Time (days)
   4. Magnitude
   5. Depth [km]
 *
 */

	FILE *fout;
	int Z=cat.Z;

	fout=fopen(fname,"w");
	for (int i=1; i<Z; i++) fprintf(fout, "%.3lf\t%.3lf\t%.3lf\t%.3lf\t%.3lf\n", cat.lon0[i], cat.lat0[i], cat.t[i], cat.mag[i], cat.depths0[i]);
	fprintf(fout, "%.3lf\t%.3lf\t%.3lf\t%.3lf\t%.3lf", cat.lon0[Z], cat.lat0[Z], cat.t[Z], cat.mag[Z], cat.depths0[Z]);
	fclose(fout);

	return 0;
}

int print_rate(char *fname, struct crust crst, double Mmin, double *rate){
/* line print_grid, but doesn't use struct pscmp.
 * if rate==NULL, will printout (crst.r0)*(crst.rate0)/Ntot.
 */

		double Lon1, Lon2, Lat1, Lat2, D1, D2;
		FILE *fout;
		int i, Ntot=crst.nLat*crst.nLon*crst.nD;
		double *r, r0;

		if (rate) {
			r=rate;
			r0=1.0*Ntot;	//since will printout rate/Ntot (due to definition of crst.rate0).
		}

		else {
			r=crst.rate0;
			r0=crst.r0;
		}


		fout=fopen(fname,"w");
		if (fout==NULL){
			if (verbose_level>0) printf("Error: file %s could not be opened (print_cmb). \n",fname);
			return(1);
		}
		i=1;
		for (int k=1; k<=Ntot; k++){		//todo check if this works with DCFS.nsel<Ntot.
			Lon1=crst.lon[k]-crst.dlon/2.0;
			Lon2=crst.lon[k]+crst.dlon/2.0;
			Lat1=crst.lat[k]-crst.dlat/2.0;
			Lat2=crst.lat[k]+crst.dlat/2.0;
			D1=crst.depth[k]-crst.ddepth/2.0;
			D2=crst.depth[k]+crst.ddepth/2.0;
			fprintf(fout,"%.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \n", Lon1, Lon2, Lat1, Lat2, D1,D2, Mmin, 8.0, r0*r[k]/(1.0*Ntot));
		}
		fclose(fout);

		return(0);
}


int print_grid(char *fname, struct pscmp DCFS, struct crust crst, double *rate){
/* if rate is a null pointer, prints out the coulomb stress field (DCFS.cmb).
 * uses refined grid geometry.
 */

	double *r;
	double Lon1, Lon2, Lat1, Lat2, D1, D2;
	FILE *fout;
	int i, Ntot=crst.nLat*crst.nLon*crst.nD;

	r=(rate==NULL) ? DCFS.cmb : rate;

	fout=fopen(fname,"w");
	if (fout==NULL){
		if (verbose_level>0) printf("Error: file %s could not be opened (print_cmb). \n",fname);
		return(1);
	}
	i=1;
	for (int k=1; k<=Ntot; k++){		//todo check if this works with DCFS.nsel<Ntot.
		Lon1=crst.lon[k]-crst.dlon/2.0;
		Lon2=crst.lon[k]+crst.dlon/2.0;
		Lat1=crst.lat[k]-crst.dlat/2.0;
		Lat2=crst.lat[k]+crst.dlat/2.0;
		D1=crst.depth[k]-crst.ddepth/2.0;
		D2=crst.depth[k]+crst.ddepth/2.0;
		if (i<=DCFS.nsel && DCFS.which_pts[i]==k) {
			//rate would contain all elements, but DCFS.cmb only those selected.
			if (rate) fprintf(fout,"%.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \n", Lon1, Lon2, Lat1, Lat2, D1,D2, 3.0, 8.0, r[k]);
			else fprintf(fout,"%.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \n", Lon1, Lon2, Lat1, Lat2, D1,D2, 3.0, 8.0, r[i]);
			i++;
		}
		else fprintf(fout,"%.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \t %.5e \n", Lon1, Lon2, Lat1, Lat2, D1,D2, 3.0, 8.0, 0.0);
	}
	fclose(fout);

	return(0);
}

int print_slipmodel(char* filename, struct eqkfm *eqfm1, int NF){
// filename with extension; NF=no. of faults (elements of eqkfm).

	FILE *fout;
	int err=0;

	fout=fopen(filename,"w");
	if (fout==NULL) {
		if (verbose_level>1) printf("Warning: file %s could not be written (by function: print_slipmode).\n",filename);
		return 1;
	}
	else{
		for (int f=0; f<NF; f++){
			switch (eqfm1[f].whichfm){
				case 1:
					fprintf(fout, "%d   %.4lf   %.4lf   %.3lf   %.2lf   %.2lf   %.3lf   %.3lf   %d   %d   %.5lf\n", f+1, eqfm1[f].lat, eqfm1[f].lon, eqfm1[f].depth, eqfm1[f].L, eqfm1[f].W, eqfm1[f].str1, eqfm1[f].dip1, eqfm1[f].np_st, eqfm1[f].np_di, eqfm1[f].t);
					break;
				case 2:
					fprintf(fout, "%d   %.4lf   %.4lf   %.3lf   %.2lf   %.2lf   %.3lf   %.3lf   %d   %d   %.5lf\n", f+1, eqfm1[f].lat, eqfm1[f].lon, eqfm1[f].depth, eqfm1[f].L, eqfm1[f].W, eqfm1[f].str2, eqfm1[f].dip2, eqfm1[f].np_st, eqfm1[f].np_di, eqfm1[f].t);
					break;
				case 0:
					if (verbose_level>1) printf("Warning: whichfm=0, using first plane (print_slipmodel).\n");
					fprintf(fout, "%d   %.4lf   %.4lf   %.3lf   %.2lf   %.2lf   %.3lf   %.3lf   %d   %d   %.5lf\n", f+1, eqfm1[f].lat, eqfm1[f].lon, eqfm1[f].depth, eqfm1[f].L, eqfm1[f].W, eqfm1[f].str1, eqfm1[f].dip1, eqfm1[f].np_st, eqfm1[f].np_di, eqfm1[f].t);
					break;
				default:
					if (verbose_level>1) printf("Warning: ambiguos focal plane  -> output not written (print_slipmodel).\n");
					err+=1;
					continue;		//associated with for loop (not switch).
			}
			for (int p=1; p<=eqfm1[f].np_st*eqfm1[f].np_di; p++) {
				fprintf(fout, "%12.5lf\t%12.5lf\t%12.5lf\t%12.5lf\t%12.5lf\n", eqfm1[f].pos_s[p], eqfm1[f].pos_d[p], eqfm1[f].slip_str[p], eqfm1[f].slip_dip[p], 0.0);
			}
		}
		fclose(fout);
	}
	return err;
}

//void printXMLforecast(char *filename, double *lats, double *lons, double *deps,  int Nlat, int Nlon, int Ndep, double Dmax, double Dmin, double *mags,
//		double *rates, double *mag_fact, int Nmag, double t0, double t1, struct tm nowtime, struct tm eqktime){
//	//t0, t1 in days.
//
//		xmlParserCtxtPtr ctxt; /* the parser context */
//	    xmlDocPtr doc; /* the resulting document tree */
//
//	    /* create a parser context */
//	    ctxt = xmlNewParserCtxt();
//	    if (ctxt == NULL) {
//	        fprintf(stderr, "Failed to allocate parser context\n");
//		return;
//	    }
//	    /* parse the file, activating the DTD validation option */
//	    doc = xmlCtxtReadFile(ctxt, filename, NULL, XML_PARSE_DTDVALID);
//
//
//
//	FILE *fout;
//	double dlat,dlon,dmag;
//	double rate;
//	char timenow[50], timestart[50], timeend[50];
//	struct tm tmstart, tmend;
//	int counter=1;
//
//	while (lons[counter]==lons[1]) counter++;
//	dlon= lons[counter]-lons[1];
//	counter=1;
//	while (lats[counter]==lats[1]) counter++;
//	dlat= lats[counter]-lats[1];
//	dmag=mags[2]=mags[1];
//
//	if (deps[Nlat*Nlon*Ndep]>Dmax || deps[1]<Dmin) printf("Warning: spatial domain of forecast different from the domain of CSEP forecast file!!\n");
//
//	tmstart=eqktime;
//	tmstart.tm_sec+=t0*DAY2SEC;
//	tmend=eqktime;
//	tmend.tm_sec+=t1*DAY2SEC;
//	tmstart.tm_isdst=eqktime.tm_isdst;
//	tmend.tm_isdst=eqktime.tm_isdst;
//	mktime(&tmstart);
//	mktime(&tmend);
//
//	strftime(timenow, 50, "%FT%T", &nowtime);
//	strftime(timestart, 50, "%FT%T", &tmstart);
//	strftime(timeend, 50, "%FT%T", &tmend);
//
//	fout=fopen(filename,"w");
//
//	fprintf(fout,"<?xml version='1.0' encoding='UTF-8'?>\n");
//	fprintf(fout,"<CSEPForecast xmlns='http://www.scec.org/xml-ns/csep/forecast/0.1'>\n");
//	fprintf(fout,"  <forecastData publicID='smi:org.scec/csep/forecast/1'>\n");
//	fprintf(fout,"    <modelName>unknown</modelName>\n");
//	fprintf(fout,"    <version>1.0</version>\n");
//	fprintf(fout,"    <author>Cattania, Hainzl</author>\n");
//	fprintf(fout,"    <issueDate>%sZ</issueDate>\n", timenow);
//	fprintf(fout,"    <forecastStartDate>%sZ</forecastStartDate>\n",timestart);
//	fprintf(fout,"    <forecastEndDate>%sZ</forecastEndDate>\n",timeend);
//	fprintf(fout,"    <defaultCellDimension latRange='%lf' lonRange='%lf'/>\n",dlat, dlon);
//	fprintf(fout,"    <defaultMagBinDimension>0.1</defaultMagBinDimension>\n");
//	fprintf(fout,"    <lastMagBinOpen>1</lastMagBinOpen>\n");
//	fprintf(fout,"    <depthLayer max='%.1lf' min='%.1lf'>\n",Dmax,Dmin);
//
//	for (int i=1; i<=Nlat*Nlon; i++){
//		rate=0.0;
//		for (int j=1; j<=Ndep; j++) rate+=rates[(j-1)*(Nlat*Nlon)+i];		//assumes that domain of forecasts corresponds to output domain.
//		fprintf(fout,"      <cell lat='%.2lf' lon='%.2lf'>\n",lats[i],lons[i]);
//		for (int m=1; m<=Nmag; m++) {
//			fprintf(fout,"      <bin m='%.1lf'>%lf</bin>\n",mags[m],rate*mag_fact[m]);
//		}
//		fprintf(fout,"      </cell>\n");
//	}
//	fprintf(fout,"  </depthLayer>\n");
//	fprintf(fout,"</forecastData>\n");
//	fprintf(fout,"</CSEPForecast>\n");
//	fclose(fout);
//
//    return;
//}
