/*
 * cmbopt. *
 *  Created on: Apr 25, 2013
 *      Author: camcat
 *      translated from fortran code pscmp (Ronjiang Wang).
 */

//#include "cmbopt.h"

double mscorr(double st1,double di1, double ra1, double st2, double di2, double ra2){

  //corralation between two source mechanism (st,di and ra in degree)
  double ncorr,tcorr;
  double st[2],di[2],ra[2],ns[3][2],ts[3][2],rst[3],rdi[3];
  int    i, j;

  st[1]=st1*DEG2RAD;
  di[1]=di1*DEG2RAD;
  ra[1]=ra1*DEG2RAD;
  st[2]=st2*DEG2RAD;
  di[2]=di2*DEG2RAD;
  ra[2]=ra2*DEG2RAD;
  
  for (j=0; j<2; j++){
    ns[1][j]=sin(di[j])*cos(st[j]+0.5*PI);
    ns[2][j]=sin(di[j])*sin(st[j]+0.5*PI);
    ns[3][j]=-cos(di[j]);
    rst[1]=cos(st[j]);
    rst[2]=sin(st[j]);
    rst[3]=0.0;
    rdi[1]=cos(di[j])*cos(st[j]+0.5*PI);
    rdi[2]=cos(di[j])*sin(st[j]+0.5*PI);
    rdi[3]=sin(di[j]);
    for (i=0; i<3; i++) ts[i][j]=rst[i]*cos(ra[j])-rdi[i]*sin(ra[j]);
  }
  ncorr=0.0;
  tcorr=0.0;
  for (i=0; i<3; i++){
    ncorr=ncorr+ns[i][1]*ns[i][2];
    tcorr=tcorr+ts[i][1]*ts[i][2];
  }
  return(ncorr*tcorr);
}


void roots3(double b, double c, double d, double *x){
  
  //finding 3 real roots of eq: x**3 + b*x**2 + c*x + d = 0
  // x is vector with indices [1,2,3].
  
  double p,q,n,u,delta;
  
  if(d==0.0){
    x[1]=0.0;
    p=b*b-4.0*c;
    if(p<0.0) printf("* Error in roots3: not all roots are real!*");
    else{
      x[2]=0.5*(-b+sqrt(p));
      x[3]=0.5*(-b-sqrt(p));
    }
  }
  else{
    p=c-b*b/3.0;
    q=d-b*(c-2.0*b*b/9.0)/3.0;
    if(4.0*pow(p,3)+27.0*pow(q,2)>0.0) printf("* Error in roots3: not all roots are real!*");
    else{
      n=sqrt(-4.0*p/3.0);
      u=acos(-0.5*q/sqrt(-pow(p,3)/27.0))/3.0;
      delta=8.0*atan(1.0)/3.0;
      x[1]=n*cos(u)-b/3.0;
      x[2]=n*cos(u+delta)-b/3.0;
      x[3]=n*cos(u+2.0*delta)-b/3.0;
    }
  }
  return;
}


void cmbopt(double sxx, double syy, double szz, double sxy, double syz, double szx, double p, double f, double *cmb,double *st1, double *di1, double *ra1, double *st2, double *di2, double *ra2){
/*  Calculates coulomb stress with the optimal orientation. Taken from Ronjiang Wang's fortran function in pscmp program.
 *
 * 	input:
	stress tensor components
	p=pore pressure
	f=friction coefficient

 *  output:
	max. Coulomb stress at the two optimally oriented fault planes
	strike, dip, rake of the two OOPs.
*/

  int    i, j, j0,j1,j2,jmin,jmax;
  double b,c,d,s1,s2,s3,snn,alpha,am,swap, sig;
  double cmb1,cmb2,cmb3,det1,det2,det3,detmax,rmax;
  double *s,**r,**ns,**ts;
  double msc1, msc2;

  double st0, di0, ra0;

  // dummy: str0, di0, rake0: a reference focal mechanism: output focal mechanisms str1, di1, rake1 refer to mechanism closer to this.
  st0=150.0; di0=90.0; ra0=0.0;

      s=dvector(1,3);
      r=dmatrix(1,3,1,3);
      ns=dmatrix(1,3,1,2);
      ts=dmatrix(1,3,1,3);

      if(sxy==0.0 && syz==0.0 && szx==0.0){
        s[1]=sxx;
        s[2]=syy;
        s[3]=szz;
      }
      else{
        b=-(sxx+syy+szz);
        c=sxx*syy+syy*szz+szz*sxx-pow(sxy,2)-pow(syz,2)-pow(szx,2);
        d=sxx*pow(syz,2)+syy*pow(szx,2)+szz*pow(sxy,2)-2.0*sxy*syz*szx-sxx*syy*szz;
        roots3(b,c,d,s);
      }
      cmb1=0.5*fabs(s[2]-s[3])*sqrt(1+f*f)+f*(0.5*(s[2]+s[3])+p);
      cmb2=0.5*fabs(s[3]-s[1])*sqrt(1+f*f)+f*(0.5*(s[3]+s[1])+p);
      cmb3=0.5*fabs(s[1]-s[2])*sqrt(1+f*f)+f*(0.5*(s[1]+s[2])+p);
      *cmb=fmax(cmb1,fmax(cmb2,cmb3));
      *st1=0.0;
      *di1=0.0;
      *ra1=0.0;
      *st2=0.0;
      *di2=0.0;
      *ra2=0.0;
      if(*cmb==cmb1){
        s3=s[1];
        s1=fmax(s[2],s[3]);
        s2=fmin(s[2],s[3]);
      }
      else if(*cmb==cmb2){
		s1=fmax(s[3],s[1]);
		s2=fmin(s[3],s[1]);
		s3=s[2];
      }
   	  else{
		s1=fmax(s[1],s[2]);
		s2=fmin(s[1],s[2]);
		s3=s[3];
      }
      sig=0.5*((s1-s2)*f/sqrt(1+f*f)+s1+s2);
      s[1]=s1;
      s[2]=s2;
      s[3]=s3;
//determine eigenvectors (the principal stress directions)
      j0=0;
      if(s[1]==s[2]){
        j0=3;
        j1=1;
        j2=2;
      }
      else if(s[2]==s[3]){
		j0=1;
		j1=2;
		j2=3;
	  }
      else if(s[3]==s[1]){
		j0=2;
		j1=1;
		j2=3;
      }

      if(j0==0){
        jmin=1;
        jmax=3;
      }
      else{
        jmin=j0;
        jmax=j0;
        printf("* Warning: more than two optimal rupture orientations! *");
      }
      for (j=jmin; j<=jmax; j++){
        det1=syz*syz-(syy-s[j])*(szz-s[j]);
        det2=szx*szx-(sxx-s[j])*(szz-s[j]);
        det3=sxy*sxy-(sxx-s[j])*(syy-s[j]);
        detmax=fmax(fabs(det1),fmax(fabs(det2),fabs(det3)));
        if(fabs(det1)==detmax){
          r[1][j]=det1;
          r[2][j]=(szz-s[j])*sxy-syz*szx;
          r[3][j]=(syy-s[j])*szx-syz*sxy;
        }
        else if(fabs(det2)==detmax){
          r[1][j]=(szz-s[j])*sxy-szx*syz;
          r[2][j]=det2;
          r[3][j]=(sxx-s[j])*syz-szx*sxy;
        }
        else{
          r[1][j]=(syy-s[j])*szx-sxy*syz;
          r[2][j]=(sxx-s[j])*syz-sxy*szx;
          r[3][j]=det3;
        }
      }
/*if any two eigenvalues are identical, their corresponding
eigenvectors should be redetermined by orthogonalizing
them to the 3. eigenvector as well as to each other*/

      if(j0 > 0){
        rmax=fmax(fabs(r[1][j0]),fmax(fabs(r[2][j0]),fabs(r[3][j0])));
        if(fabs(r[1][j0])==rmax){
          r[1][j1]=-r[2][j0];
          r[2][j1]=r[1][j0];
          r[3][j1]=0.0;
          r[1][j2]=-r[3][j0];
          r[2][j2]=0.0;
          r[3][j2]=r[1][j0];
          am=r[1][j1]*r[1][j2]/(pow(r[1][j1],2)+pow(r[2][j1],2));
          for (i=1; i<=3; i++) r[i][j2]=r[i][j2]-am*r[i][j1];
        }
        else if(fabs(r[2][j0])==rmax){
          r[1][j1]=r[2][j0];
          r[2][j1]=-r[1][j0];
          r[3][j1]=0.0;
          r[1][j2]=0.0;
          r[2][j2]=-r[3][j0];
          r[3][j2]=r[2][j0];
          am=r[2][j1]*r[2][j2]/(pow(r[1][j1],2)+pow(r[2][j1],2));
          for (i=1; i<=3; i++) r[i][j2]=r[i][j2]-am*r[i][j1];
        }
        else if(fabs(r[3][j0])==rmax){
          r[1][j1]=r[3][j0];
          r[2][j1]=0.0;
          r[3][j1]=-r[1][j0];
          r[1][j2]=0.0;
          r[2][j2]=r[3][j0];
          r[3][j2]=-r[2][j0];
          am=r[3][j1]*r[3][j2]/(pow(r[1][j1],2)+pow(r[3][j1],2));
          for (i=1; i<=3; i++) r[i][j2]=r[i][j2]-am*r[i][j1];
        }
      }
      for (j=1; j<=3; j++){
        am=sqrt(pow(r[1][j],2)+pow(r[2][j],2)+pow(r[3][j],2));
        for (i=1; i<=3; i++) r[i][j]=r[i][j]/am;
      }

      alpha=0.5*atan(1.0/f);
      snn=s[1]*pow(cos(alpha),2)+s[2]*pow(sin(alpha),2);
//determine the two optimal fault-plane normals
      for (i=1; i<=3; i++){
        ns[i][1]=r[i][1]*cos(alpha)+r[i][2]*sin(alpha);
        ns[i][2]=r[i][1]*cos(alpha)-r[i][2]*sin(alpha);
      }
//determine the direction of max. shear stress
      for (j=1; j<=2; j++){
        am=sqrt(pow(ns[1][j],2)+pow(ns[2][j],2)+pow(ns[3][j],2));
        if (ns[3][j] > 0.0) am=-am;
        for (i=1; i<=3; i++) ns[i][j]=ns[i][j]/am;

        ts[1][j]=(sxx-snn)*ns[1][j]+sxy*ns[2][j]+szx*ns[3][j];
        ts[2][j]=sxy*ns[1][j]+(syy-snn)*ns[2][j]+syz*ns[3][j];
        ts[3][j]=szx*ns[1][j]+syz*ns[2][j]+(szz-snn)*ns[3][j];
        am=sqrt(pow(ts[1][j],2)+pow(ts[2][j],2)+pow(ts[3][j],2));
        for (i=1; i<=3; i++) ts[i][j]=ts[i][j]/am;
      }

//determine the two optimal focal mechanisms

      *st1=fmod(atan2(ns[2][1],ns[1][1])*180.0/PI+270.0,360.0);
	  *di1=acos(-ns[3][1])*180.0/PI;
      s1=cos((*st1)*PI/180.0);
      s2=sin((*st1)*PI/180.0);
      *ra1=acos(fmin(fmax(s1*ts[1][1]+s2*ts[2][1],-1.0),1.0))*180.0/PI;

      if (ts[3][1] > 0.0) *ra1=-(*ra1);
      *st2=fmod(atan2(ns[2][2],ns[1][2])*180.0/PI+270.0,360.0);
	  *di2=acos(-ns[3][2])*180.0/PI;
      s1=cos((*st2)*PI/180.0);
      s2=sin((*st2)*PI/180.0);
      *ra2=acos(fmin(fmax(s1*ts[1][2]+s2*ts[2][2],-1.0),1.0))*180.0/PI;
      if(ts[3][2] > 0.0) *ra2=-(*ra2);
      msc1=mscorr(st0,di0,ra0,*st1,*di1,*ra1);
      msc2=mscorr(st0,di0,ra0,*st2,*di2,*ra2);
      if(msc1<msc2){
        swap=*st1;
        *st1=*st2;
        *st2=swap;
        swap=*di1;
        *di1=*di2;
        *di2=swap;
        swap=*ra1;
        *ra1=*ra2;
        *ra2=swap;
      }

      free_dvector(s,1,3);
      free_dmatrix(r,1,3,1,3);
      free_dmatrix(ns,1,3,1,2);
      free_dmatrix(ts,1,3,1,2);
      return;
}
