/******************************************************************************
  "defines.h"

  project:  Simulation and parameter estimation using ETAS and shakemaps
   author:  Christoph Bach
            Sebastian Hainzl
     date:  2010-07-30
******************************************************************************/

#ifndef DEFINES_H
#define DEFINES_H

#define log10(A) (log(A)/log(10))
#define sq(A) ((A)*(A))
#define sign(A) ((int) (A/fabs(A)))
#define max(A,B) (A>B)? A : B
#define eps0 1.0e-3
#define PI (3.141592653589793)
#define pi (3.141592653589793)
#define EUL (2.718281828459)
#define ASIZE 100000
#define CSIZE 512
#define Re (6370)
#define DEG2RAD  (0.0174532925)
#define KM2M     (1000.0)
#define RAD2DEG  (57.2957795147)
#define SEC2DAY	(1.0/(24.0*3600.0))
#define T2SEC(x) (x/(double)CLOCKS_PER_SEC)
#define tol0 1e-10	//tolerance for double comparison.

//todo: should put values that can be changed somewhere else? (or use global variables instead).

#define check_if_snapshot_filename "snapshot.info"	//file which exists only if at least one forecast has been already been produced, and contains time to which other files gammas and LL) refer.
#define LLsnapshot_filename "LL.dat"	//file which exists only if at least one forecast has been already been produced, and contains time to which other files gammas and LL) refer.
#define gammas_filename "gammas.dat"	//file which exists only if at least one forecast has been already been produced, and contains time to which other files gammas and LL) refer.
#define old_LLfolder "output/oldLL"
#define logfolder "output/log/"

/*	verbose_level: only global variable. settings:
 *
 * 	0: output nothing.
 *  1: output to screen: main operations and errors which lead to abort.
 *  2: output to screen: also minor errors and warnings. (also writes log file).
 *  3: output modified slip models, stress fields etc. (produces several files!)
 *  4: output even more files (e.g. Fourier values etc...)
 *
 * */	//todo implement these!!

extern int verbose_level;
extern int gridPMax;	//todo global variables are bad...
extern double DCFS_cap;

struct set_of_models{
	double t0;	//event time;
	int Nmod;
	double *t_mod;	//time when the model is available;
	char **filename;
	int *NF_models;	//no. of faults for each model;
	struct eqkfm *set_of_eqkfm; //contains all models (size: sum(NF_model)).
};

//Linked list with okada coefficients between fault patches and cells. Each element represents one earthquake (also with multiple faults).
struct Coeff_LinkList{
	int NF;				// tot. no of faults;
	int which_main;		// index of pscmp DCFS to which earthquake refer;
	int NP;				// tot. no. of patches (sum of no. of patches of individual faults);
	int NgridT;			// no. of grid cells.
	float ***Coeffs_st, ***Coeffs_dip;	// Coefficient for strike slip, dip slip displacements.
	struct Coeff_LinkList *next;	// pointer to next element.
};

// earthquake catalog.
struct catalog{
	//properties of earthquakes:
	double Mc;
	double *t;			//time
	double *mag;		//magnitude;
	double *lat0;
	double *lon0;
	double *x0;
	double *y0;
	double *depths0;
	int *ngrid;			//no. of of cells associated with each earthquake
	int **ngridpoints;	//indices of cells associated with each earthquake:	ngridpoints[eqk][cell_index].
	double **weights;	//weight of cells associated with each earthquake:	weights[eqk][cell_weight].
//list of cell centers coordinates (same as in pscmp structures).
	//todo comment these out (crst contains all these).
//	double *latgrid;
//	double *longrid;
//	double *layers;		//depths.
//	double *xgrid;
//	double *ygrid;
//	double dAeq;
//	double *dAgrid;
	struct crust *pcrst;
	//general catalog properties:
	long Z;
	double tstart;
	double tend;
//	double latmin;
//	double latmax;
//	double lonmin;
//	double lonmax;
//	double depthmin;
//	double depthmax;
};

struct pscmp{
	double m;			// event magnitude
	double t;			// event time
	double dlat;		// spacing (lat)
	double dlon;		// ...
	double ddepth;		// ...
	double *lat;		// latitude of all grid cell centers.
	double *lon;		// longitude of all grid cell centers.
	double *depth;		// depth of all grid cell centers.
	double *fdist;		// distance to fault
//	double *east;
//	double *north;
	double ***S;		// stress tensor S[cell_index][i][j].	cell_index: 1...nsel.
	double ***S1;		// also stess tensor, may be used if 2 foc. mec. are available.
	double *cmb;		// coulomb stress cmb[cell_index], cell_index: 1...nsel.
	double *cmb0;		// stores undisturbed cmb field (if the only source of errors is the grid point uncertainty).
	double *Dcmb;		// stores range of cmb field (if the only source of errors is the grid point uncertainty).
	long    Z;
//	double east_min;
//	double east_max;
//	double north_min;
//	double north_max;
	//these may be used to save focal mechanism parameters of OOPs.
	double *st1;
	double *di1;
	double *ra1;
	double *st2;
	double *di2;
	double *ra2;
	int nsel;			//no. of cell points affected by this event.
	int *which_pts;		//indices of cell points affected by this event (relative to arrays lat, lon, depth). range: 1...nsel.
	int nLat,nLon,nD;	//no. of cells with unique lat, lon, depth (describing overall geometry).
    int index_cat;		//index of event in catalog (only for the catalog used for LL calculation). set to 0 if event is not in catalog.
    int NF; 			//number of faults of mainshock (i.e. no. of eqkfm object mapping to this event).
};

struct dist{
	double mag;
	double t;
//	double dlat;
//	double dlon;
//	double ddepth;
//	double *lat;
//	double *lon;
//	double *depth;
//	double *east;
//	double *north;
	double *dist;
//	long    Z;
//	double east_min;
//	double east_max;
//	double north_min;
//	double north_max;
//	double VOL;
	int *which_pts;
	int nsel;
    int index_cat;	//index of event in catalog (only for the catalog used for LL calculation). set to 0 if event is not in catalog.
};

//describes elastic properties of the entire crustal volume.
struct crust{
	//physical properties:
	double str0, dip0, rake0; // orientation of best oriented mechanism in regional stress field: this is redundant given stress tensor below, but easier to keep if for later.
	double fric;		// coefficient of friction.
	double skepton;		// skeption coefficient
	double **S;			// regional stress tensor;
	double lambda;		// lame' parameter
	double mu;			// lame' parameter
	// coords. of domain
	double lat0, lon0;
	double 	latmin, \
			latmax, \
			lonmin, \
			lonmax, \
			depmin, \
			depmax;
	// grid for forecast:
	int nLat_out, \
		nLon_out, \
		nD_out;
	double dlat_out;
	double dlon_out;
	double ddepth_out;
	// grid for calculations:
	int N_allP;			// no. of points (should be same as DCFS0).
	int *list_allP;		// list. of points (should be same as DCFS0): [1,2,3,...N_allP].
	double dlat;		// spacing (lat)
	double dlon;		// ...
	double ddepth;		// ...
	int nLat;
	int nLon;
	int nD;
	double *lat;		// latitude of all grid cell centers.
	double *lon;		// longitude of all grid cell centers.
	double *depth;		// depth of all grid cell centers.
	double *dAgrid;
	double *x;
	double *y;
};

struct slipmodels_list{
	int is_afterslip;
	int NSM;	//no. of events.
	int *Nfaults;
	int *no_slipmodels;
	double *tmain;	//times.
	double *mmain;	//magnitudes.
	double *disc;
	char **slipmodels;
	char **multimodels;
};

//structure describing a single fault earthquake (arrays can be used to describe multiple fault events).
struct eqkfm{	//for events on multiple faults, use a list of these.
	int is_mainshock;	//mainshock with multiple patches (treated differently when calculating DCFS).
	int is_slipmodel;	//if set to 0, focal mechanism is not available.
	int np_st, np_di;	//no. of patches along strile, no. of patches along dip,
	int whichfm;		//index of foc. mec. to use (0=both;1;2).
	int nsel;			//no. of cell points affected by this event.
	int noise;			// flag (if set, tot_slip refers to model from which noise was generated):
	int Nmod;			//several slip models may be stored.
	int *taper;		// taper [1...4]=top,bottom,right,left.
	double t;		//time of event.
	double lat;		//0_lat in Wang input file;
	double lon; 	//0_lat in Wang input file;
	double depth; 	//0_lat in Wang input file;
	double mag;		//magnitude
	double tot_slip;//tot. slip on the fault (sum of scalar value of slip for each patch).
	double L;		//fault length
	double W;		//fault width
	//focal mechanism parameters for both possible planes:
	double str1;
	double str2;
	double dip1;
	double dip2;
	double rake1;
	double rake2;
	//vector containing one element per patch:
	double *slip_str;	//slip along strike
	double *slip_dip;	//slip along dip
	double *strikes;	//strike of patch (not used)
	double *dips;		//dip of patch (not used)
    double *pos_s;		//along strike distance from point: lat,lon (0 for single patch events);
    double *pos_d;		//along dip distance from point: lat,lon (0 for single patch events);
    double *distance;
    double **stored_slip_str;	//to store multiple slip models.
    double **stored_slip_dip;	//to store multiple slip models.
    int *selpoints;		//indices of cell points affected by this event.
    int index_cat;		//index of event in catalog.
};

//obsolete structure.
struct ETASparameter{
	double mu;
	double K;
	double c;
	double alpha;
	double p;
	double q;
	double d;
	double K1; //K/pow(c, p);
};

#endif //DEFINES_H
