
#ifndef DEFINES_H

#define DEFINES_H
#define DEG2RAD  (0.0174532925)

struct eqkfm{	//for events on multiple faults, use a list of these.
	int is_mainshock;	//mainshock with multiple patches (treated differently when calculating DCFS).
	int is_slipmodel;	//if set to 0, focal mechanism is not available.
	int np_st, np_di;	//no. of patches along strile, no. of patches along dip,
	int whichfm;		//index of foc. mec. to use (0=both;1;2).
	int nsel;			//no. of cell points affected by this event.
	int noise;			// flag (if set, tot_slip refers to model from which noise was generated):
	int Nmod;			//several slip models may be stored.
	int *taper;		// taper [1...4]=top,bottom,right,left.
	double t;		//time of event.
	double lat;		//0_lat in Wang input file;
	double lon; 	//0_lat in Wang input file;
	double depth; 	//0_lat in Wang input file;
	double mag;		//magnitude
	double tot_slip;//tot. slip on the fault (sum of scalar value of slip for each patch).
	double L;		//fault length
	double W;		//fault width
	//focal mechanism parameters for both possible planes:
	double str1;
	double str2;
	double dip1;
	double dip2;
	double rake1;
	double rake2;
	//vector containing one element per patch:
	double *slip_str;	//slip along strike
	double *slip_dip;	//slip along dip
	double *strikes;	//strike of patch (not used)
	double *dips;		//dip of patch (not used)
    double *pos_s;		//along strike distance from point: lat,lon (0 for single patch events);
    double *pos_d;		//along dip distance from point: lat,lon (0 for single patch events);
    double *distance;
    double **stored_slip_str;	//to store multiple slip models.
    double **stored_slip_dip;	//to store multiple slip models.
    int *selpoints;		//indices of cell points affected by this event.
    int index_cat;		//index of event in catalog.
};

#endif //DEFINES_H

