/*
 * dist2fault.c
 *
 *  Created on: Apr 18, 2013
 *      Author: camcat
 */

#include "dist2fault.h"

#include "moreutil.c"

void dist2line(double *P, double *A, double *B, int d3, int finitesegment, double *D, double *d){
  // Translated from matlab function with same name.
  
  double a,b,l, ap, bp, cosalpha, cal;
  double *L, *AP, *BP;
  int    k;
  
  L=dvector(1,d3);
  AP=dvector(1,d3);
  BP=dvector(1,d3);
  
  norm(A,&a,d3);
  norm(B,&b,d3);
  for (k=1; k<=d3; k++) {
    L[k]=B[k]-A[k];
    AP[k]=A[k]-P[k];
    BP[k]=B[k]-P[k];
  }
  
  norm(L,&l,d3);
  norm(AP,&ap,d3);
  norm(BP,&bp,d3);
  
  vdotv(AP,L,&cal,d3);
  cosalpha=cal/(ap*l);
  
  for (k=1; k<=d3; k++) D[k]=A[k]-L[k]*(ap*cosalpha/l) - P[k];
  norm(D,d,d3);
  
  if (finitesegment==1){
    if ((pow(ap,2)-pow(*d,2))>pow(l,2) || (pow(bp,2)-pow(*d,2))>pow(l,2)){
      for (k=1; k<=d3; k++) D[k]= (ap<bp)? A[k]-P[k] : B[k]-P[k];
      norm(D,d,d3);
    }
  }
}

double *dist2fault(double *lats, double *lons, double *depths, int NP, double strike0, double dip0,
		double Lat0, double Lon0, double D0, double *pos_s, double *pos_d){

/* Assumes rectangular fault.
 *
 * input:
 * lats, lons, depths: vectors [1...NP], containing coordinates of grid points for which distance should be calculated.
 * Lat0, Lon0, D0: coordinates of a reference point on the fault plane.
 * pos_s[0,1]: distances along strike from the reference point to the sides edges of the fault.
 * pos_d[0,1]: distances along dip from the reference point to the top/bottom edges of the fault.
 *
 * output:
 * vector with indices [1...NP] containing distance (NB: positive or negative on opposite sides of the fault!).
 */

  double *dist;
  double *dipV, *A, *A0, *B, *B0, *P, *J, *D;
  double l, d, dir, dz1, dz2, Dmin, Dmax, Depth;
  double strike, dip;
  int    j, k;

  strike=strike0*DEG2RAD;
  dip=dip0*DEG2RAD;
  
  dist=dvector(1,NP);
  dipV=dvector(1,3);
  A=dvector(1,3);
  A0=dvector(1,3);
  B=dvector(1,3);
  B0=dvector(1,3);
  J=dvector(1,2);
  P=dvector(1,3);
  D=dvector(1,3);
  
  // top/bottom depth.
  dz1=sin(dip)*pos_d[0];
  dz2=sin(dip)*pos_d[1];
  Dmin=D0+dz1;
  Dmax=D0+dz2;
  
  // coordinates of top corners:
  A0[1]=pos_s[0]*sin(strike)+pos_d[0]*cos(dip)*cos(strike);	//x coordinate: east.
  A0[2]=pos_s[0]*cos(strike)-pos_d[0]*cos(dip)*sin(strike);
  A0[3]=Dmin;
  B0[1]=pos_s[1]*sin(strike)+pos_d[0]*cos(dip)*cos(strike);
  B0[2]=pos_s[1]*cos(strike)-pos_d[0]*cos(dip)*sin(strike);
  B0[3]=Dmin;
  
  //dip vector
  dipV[1]=cos(dip)*sin(strike+PI/2.0);
  dipV[2]=cos(dip)*cos(strike+PI/2.0);
  dipV[3]=sin(dip);
  
  for (k=1; k<=NP; k++){
    P[1]=Re*(lons[k]-Lon0)*PI/180*cos(Lat0*PI/180);
    P[2]=Re*(lats[k]-Lat0)*PI/180;
    P[3]=depths[k];
    
    dist2line(P,A0,B0,2,0,J, &l);
    vdotv(J,dipV,&dir,2);
    l=-l*(dir/fabs(dir));
    
    Depth=P[3]-Dmin+l*sin(dip)*cos(dip)-(P[3]-Dmin)*cos(dip)*cos(dip);
    
    if (Depth>Dmax-Dmin) Depth=Dmax-Dmin;
    else if (Depth<0) Depth=0;
    
    for (j=1; j<=3; j++) {		//A, B become coordinates of points at correct depth.
      A[j]= A0[j]+(Depth/sin(dip))*dipV[j];
      B[j]= B0[j]+(Depth/sin(dip))*dipV[j];
    }
    
    dist2line(P,A,B,3,1,D, &d);
    
    vdotv(D,dipV,&dir,2);
    dist[k]=-d*(dir/fabs(dir));	//wedge: +ve, below: -ve. (may be different in Matlab version).
    
  }
  
  return dist;
}

