
/*
 * read_slipmodel.h
 *
 *  Created on: Jan 16, 2013
 *      Author: camcat
 */

#ifndef READ_SLIPMODEL_H_
#define READ_SLIPMODEL_H_


#endif /* READ_SLIPMODEL_H_ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//int read_farfalle0(char * file, double *lambda, double *mu, double *fric, double *skepton, double *str0, double *di0, double *rake0);


double **mtimesm3(double **m1, double **m2){
  //indices: [1...3].
  
  double **m3;
  int    i, j, k;

  m3=dmatrix(1,3,1,3);
  
  for (i=1; i<=3; i++){
    for (j=1; j<=3; j++){
      m3[i][j]=0;
      for (k=1; k<=3; k++){
	m3[i][j]+=m1[i][k]*m2[k][j];
      }
    } 
  }
  return m3;
}

double **prestress_eigen(double *s, double *str, double *dip){
        //calculates stress tensor knowing magnitude and orientation of principal stresses (s[X], str[X], dip[X], X=0,1,2).

 double **Q, **QT, **L, **S;
 int    i, j;

 Q=dmatrix(1,3,1,3);
 QT=dmatrix(1,3,1,3);
 L=dmatrix(1,3,1,3);
 
 for (i=1; i<=3; i++){
   for (j=1; j<=3; j++){
     L[i][j]=0;
   }
 }
 
 for (i=1; i<=3; i++){
   L[i][i]=s[i-1];
   Q[1][i]=QT[i][1]=cos(DEG2RAD*str[i-1])*cos(DEG2RAD*dip[i-1]);
   Q[2][i]=QT[i][2]=sin(DEG2RAD*str[i-1])*cos(DEG2RAD*dip[i-1]);
   Q[3][i]=QT[i][3]=sin(DEG2RAD*dip[i-1]);
 }
 
 S=mtimesm3(mtimesm3(Q, L), QT);
 return S;
}



int read_farfalle0(char *file, double *lambda, double *mu, double *fric, double *skempton, double ***S)
{
  //S is given as a tensor with indices [1...3][1...3].
  FILE *fin;
  int Nchar=200, err=0, junk, i;
  char line[Nchar], slipmodelfile[160];
  char *pch;
  char key[]="Friction";
  double s[3];	//regional stress field description (values);
  double st[3];	//regional stress field description (strikes);
  double di[3];	//regional stress field description (dips);
  double dum;
  
  fin=fopen(file,"r");
  if (fin==NULL) return (1);
  
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin); //useless field (controls Farfalle output).
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin);
  err+=ferror(fin);
  sscanf(line,"%lf %lf", lambda, mu);   // [MPa]
  *lambda *= pow(10.0,6.0);              // --> [Pa]
  *mu     *= pow(10.0,6.0);              // --> [Pa]
  
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin); //useless field ('Adding regional stress field').
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin);
  err+=ferror(fin);
  sscanf(line,"%lf %lf %lf", s, s+1, s+2);
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin);
  err+=ferror(fin);
  sscanf(line,"%lf %lf", st, di);
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin);
  err+=ferror(fin);
  sscanf(line,"%lf %lf", st+1, di+1);
  line[0]='!';
  while (line[0]=='!') fgets(line,Nchar,fin);
  err+=ferror(fin);
  sscanf(line,"%lf %lf", st+2, di+2);
  
  pch=strstr(line,key);
  while(pch == NULL){
    fgets(line,Nchar,fin);
    pch=strstr(line,key);  
  }
  fgets(line,Nchar,fin);	// friction and skempton parameters
  sscanf(line,"%lf %lf", fric, skempton);
  
  fclose(fin);
  
  *S=prestress_eigen(s, st, di);
  
  return (err!=0);  
}

