/*
/*
 * main.c
 *
 *  Created on: Sep 11, 2013
 *      Author: camcat
 */

#include "read_write_models.h"

int read_farfalle_eqkfm(char *fname, struct eqkfm **eqfm_out, int *NF_out){

	FILE *fin;
	struct eqkfm *eqfm;
	int NF, NP, nchar=200;
	char line[nchar];
	double dlen, dwid;
	double *slips, *rakes;
	double junk;
	double plength, pwidth;
	long file_pos;
	int f, w, l, p;

	fin=fopen(fname,"r");
	if (fin==NULL){
		printf("Invalid input file.\n");
		return (1);	//return error code.
	}

	else {
		fgets(line,nchar,fin);
		fgets(line,nchar,fin);
		sscanf(line,"%d",&NF);
		eqfm=eqkfm_array(0,NF-1);
		for (f=0; f<NF; f++){
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf %lf",&(eqfm[f].lat), &(eqfm[f].lon), &(eqfm[f].depth));
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			eqfm[f].whichfm=1;
			sscanf(line,"%lf %lf",&(eqfm[f].str1), &(eqfm[f].dip1));
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf",&(eqfm[f].L), &plength);
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf",&(eqfm[f].W), &pwidth);
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%d %d",&(eqfm[f].np_st), &(eqfm[f].np_di));
			NP=eqfm[f].np_st*eqfm[f].np_di;
			eqfm[f].pos_s=dvector(1,NP);
			eqfm[f].pos_d=dvector(1,NP);
			eqfm[f].slip_str=dvector(1,NP);
			eqfm[f].slip_dip=dvector(1,NP);
			if (f==0 | NP>eqfm[f-1].np_st*eqfm[f-1].np_di){
				if (f!=0){
					free_dvector(slips, 1,1);
					free_dvector(rakes, 1,1);
				}
				slips=dvector(1,NP);
				rakes=dvector(1,NP);
			}
			fgets(line,nchar,fin);
			file_pos=ftell(fin);
			dlen=eqfm[f].L/eqfm[f].np_st;
			dwid=eqfm[f].W/eqfm[f].np_di;
			for (w=1; w<=eqfm[f].np_di; w++){
				for (l=1; l<=eqfm[f].np_st; l++){
					fscanf(fin, "%lf", slips+(w-1)*eqfm[f].np_st+l);
					//if points refer to center of the faut:
					//eqfm[f].pos_s[(w-1)*eqfm[f].np_st+l]=-0.5*eqfm[f].L+(l-0.5)*dlen;
					//eqfm[f].pos_d[(w-1)*eqfm[f].np_st+l]=-0.5*eqfm[f].W+(w-0.5)*dwid;

					//if points refer to top left corner of the fault:
					//eqfm[f].pos_s[(w-1)*eqfm[f].np_st+l]=(l-0.5)*dlen;
					//eqfm[f].pos_d[(w-1)*eqfm[f].np_st+l]=(w-0.5)*dwid;

					/* Abi's email "The hypocenter is the reference point. Then, you draw a line in the strike direction,
					 * and the distance between the hypocenter and the end of the fault is the partial length.
					 * The partial width is the distance to the top of the fault.
					 * It is the end that goes in the opposite direction of the strike, starting from the reference point, if I remember well,
					 * so that you always start drawing the fault in the direction of the strike.*/
					eqfm[f].pos_s[(w-1)*eqfm[f].np_st+l]=(l-0.5)*dlen-plength;
					eqfm[f].pos_d[(w-1)*eqfm[f].np_st+l]=(w-0.5)*dwid-pwidth;
				}
			}
			fseek(fin,file_pos, SEEK_SET);		//since fscanf sometimes reads until next line, sometimes not (depending on small differences in the file, e.g. spaces).
			for (w=1; w<=eqfm[f].np_di; w++) fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			for (w=1; w<=eqfm[f].np_di; w++) fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			file_pos=ftell(fin);
			for (w=1; w<=eqfm[f].np_di; w++){
				for (l=1; l<=eqfm[f].np_st; l++){
					fscanf(fin, "%lf", rakes+(w-1)*eqfm[f].np_st+l);
				}
			}
			fseek(fin,file_pos, SEEK_SET);		//since fscanf sometimes reads until next line, sometimes not (depending on small differences in the file, e.g. spaces).
			for (w=1; w<=eqfm[f].np_di; w++) fgets(line,nchar,fin);

			for (p=1; p<=NP; p++) {
				eqfm[f].slip_str[p]=slips[p]*cos(DEG2RAD*rakes[p]);
				eqfm[f].slip_dip[p]=-slips[p]*sin(DEG2RAD*rakes[p]);
			}
		}

		*eqfm_out=eqfm;
		*NF_out=NF;
	}
	return(0);
}

int read_farfalle(char *fname){

	FILE *fin;
	int nchar=200, Nmax_patches=5000;	//max no. of character expected on a line, and max no. patches a slip model can have.
	char line [nchar];
	int NF;
	int *npl, *npw;	//no of patches along length, width. array since one value per fault.
	double *lat, *lon, *dep;	//of a point on the fault (center?). array since one value per fault.
	double *str, *dip;			//of a point fault. array since one value per fault.
	double *len, *wid;			//of a point fault. array since one value per fault.
	double dlen, dwid;
	double plength, pwidth;
	double **slip;
	double **rake;
	double **pos_l;
	double **pos_w;
	long file_pos;
	int f, w, l;

	fin=fopen(fname,"r");
	if (fin==NULL){
		return (1);	//return error code.
	}

	else {
		fgets(line,nchar,fin);
		fgets(line,nchar,fin);
		sscanf(line,"%d",&NF);
		npl=ivector(1,NF);
		npw=ivector(1,NF);
		lat=dvector(1,NF);
		lon=dvector(1,NF);
		dep=dvector(1,NF);
		str=dvector(1,NF);
		dip=dvector(1,NF);
		len=dvector(1,NF);
		wid=dvector(1,NF);
		slip=dmatrix(1,NF, 1, Nmax_patches);
		rake=dmatrix(1,NF, 1, Nmax_patches);
		pos_w=dmatrix(1,NF, 1, Nmax_patches);
		pos_l=dmatrix(1,NF, 1, Nmax_patches);
		for (f=1; f<=NF; f++){
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf %lf",lat+f, lon+f, dep+f);
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf",str+f, dip+f);
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf",len+f, &plength);
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%lf %lf",wid+f, &pwidth);
			fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			sscanf(line,"%d %d",npl+f, npw+f);
			if (npl[f]*npw[f]>Nmax_patches){
				printf("Nmax_patches too small in read_farfalle - exiting!\n");
				return (1);
			}
			fgets(line,nchar,fin);
			file_pos=ftell(fin);
			dlen=len[f]/(1.0*npl[f]);
			dwid=wid[f]/(1.0*npw[f]);
			for (w=1; w<=npw[f]; w++){
				for (l=1; l<=npl[f]; l++){
					fscanf(fin, "%lf", slip[f]+(w-1)*npl[f]+l);

					//if points refer to center of the faut:
					//pos_l[f][(w-1)*npl[f]+l]=-0.5*len[f]+(l-0.5)*dlen;
					//pos_w[f][(w-1)*npl[f]+l]=-0.5*wid[f]+(l-0.5)*dwid;

					//if points refer to top left corner of the fault:
					//pos_l[f][(w-1)*npl[f]+l]=(l-0.5)*dlen;
					//pos_w[f][(w-1)*npl[f]+l]=(w-0.5)*dwid;

					/* Abi's email "The hypocenter is the reference point. Then, you draw a line in the strike direction,
					 * and the distance between the hypocenter and the end of the fault is the partial length.
					 * The partial width is the distance to the top of the fault.
					 * It is the end that goes in the opposite direction of the strike, starting from the reference point, if I remember well,
					 * so that you always start drawing the fault in the direction of the strike.*/
					pos_l[f][(w-1)*npl[f]+l]=(l-0.5)*dlen-plength;
					pos_w[f][(w-1)*npl[f]+l]=(w-0.5)*dwid-pwidth;
				}
			}
			fseek(fin,file_pos, SEEK_SET);		//since fscanf sometimes reads until next line, sometimes not (depending on small differences in the file, e.g. spaces).
			for (w=1; w<=npw[f]; w++) fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			for (w=1; w<=npw[f]; w++) fgets(line,nchar,fin);
			fgets(line,nchar,fin);
			file_pos=ftell(fin);
			for (w=1; w<=npw[f]; w++){
				for (l=1; l<=npl[f]; l++){
					fscanf(fin, "%lf", rake[f]+(w-1)*npl[f]+l);
				}
			}
			fseek(fin,file_pos, SEEK_SET);		//since fscanf sometimes reads until next line, sometimes not (depending on small differences in the file, e.g. spaces).
			for (w=1; w<=npw[f]; w++) fgets(line,nchar,fin);
		}


		for (f=1; f<=NF; f++){
			printf("Fault no. %d, Lat=%.3lf, Lon=%.3lf, Dep=%.3lf, length=%.3lf, width=%.3lf, strike=%.3lf, dip=%.3lf \n", f, lat[f], lon[f], dep[f], len[f], wid[f], str[f], dip[f]);
			printf("Slip:\n");
			int c=1;
			for (w=1; w<=npw[f]; w++){
				for (l=1; l<=npl[f]; l++) {
					printf("%.5lf\t", slip[f][c]);
					c+=1;
				}
				printf("\n");
			}
			printf("Rake:\n");
			c=1;
			for (w=1; w<=npw[f]; w++){
				for (l=1; l<=npl[f]; l++) {
					printf("%.5lf\t", rake[f][c]);
					c+=1;
				}
				printf("\n");
			}
		}
	}
	return(0);

}

int print_slipmodel(char* filename, struct eqkfm *eqfm1, int NF){
// filename with extension; NF=no. of faults (elements of eqkfm).

	FILE *fout;
	int err=0;
	int p, f;

	fout=fopen(filename,"a");
	if (fout==NULL) {
		printf("Warning: file %s could not be written (by function: print_slipmode).\n",filename);
		return 1;
	}
	else{
		for (f=0; f<NF; f++){

			switch (eqfm1[f].whichfm){
				case 1:
					fprintf(fout, "%d   %.4lf   %.4lf   %.3lf   %.2lf   %.2lf   %.3lf   %.3lf   %d   %d   %.5lf\n", f+1, eqfm1[f].lat, eqfm1[f].lon, eqfm1[f].depth, eqfm1[f].L, eqfm1[f].W, eqfm1[f].str1, eqfm1[f].dip1, eqfm1[f].np_st, eqfm1[f].np_di, eqfm1[f].t);
					break;
				case 2:
					fprintf(fout, "%d   %.4lf   %.4lf   %.3lf   %.2lf   %.2lf   %.3lf   %.3lf   %d   %d   %.5lf\n", f+1, eqfm1[f].lat, eqfm1[f].lon, eqfm1[f].depth, eqfm1[f].L, eqfm1[f].W, eqfm1[f].str2, eqfm1[f].dip2, eqfm1[f].np_st, eqfm1[f].np_di, eqfm1[f].t);
					break;
				case 0:
					printf("Warning: whichfm=0, using first plane (print_slipmodel).\n");
					fprintf(fout, "%d   %.4lf   %.4lf   %.3lf   %.2lf   %.2lf   %.3lf   %.3lf   %d   %d   %.5lf\n", f+1, eqfm1[f].lat, eqfm1[f].lon, eqfm1[f].depth, eqfm1[f].L, eqfm1[f].W, eqfm1[f].str1, eqfm1[f].dip1, eqfm1[f].np_st, eqfm1[f].np_di, eqfm1[f].t);
					break;
				default:
					printf("Warning: ambiguos focal plane  -> output not written (print_slipmodel).\n");
					err+=1;
					continue;		//associated with for loop (not switch).
			}
			for (p=1; p<=eqfm1[f].np_st*eqfm1[f].np_di; p++) {
				fprintf(fout, "%12.5lf\t%12.5lf\t%12.5lf\t%12.5lf\t%12.5lf\n", eqfm1[f].pos_s[p], eqfm1[f].pos_d[p], eqfm1[f].slip_str[p], eqfm1[f].slip_dip[p], 0.0);
			}
		}
		fclose(fout);
	}
	return err;
}
