/*
 * main.c
 *
 *  Created on: Sep 11, 2013
 *      Author: camcat
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "recipes/nrutil.c"
#include "recipes/eakfm_array.c"  
#include "recipes/read_write_models.c"
#include "recipes/read_farfalle0.c"
#include "recipes/dist2fault.c"
#include "recipes/cmbopt.c"

static double  *gridlat, *gridlon;             //  Ngrid latitude and longitude grid points for parameter estimation and forecast
static int     Ngrid;
static double  dlat, dlon;


void readgrid(char *inputfile)
{
  FILE   *fin;
  char   sdum[100];
  double dum;
  int    n, idum, Nlat, Nlon;

  fin=fopen(inputfile,"r");

  fscanf(fin,"%s",&sdum);   fscanf(fin,"%d", &Ngrid); 
  gridlat = dvector(1,Ngrid);
  gridlon = dvector(1,Ngrid);

  for(n=1;n<=Ngrid;n++){ 
    fscanf(fin,"%d",&idum);  
    fscanf(fin,"%lf",&gridlon[n]); 
    fscanf(fin,"%lf",&gridlat[n]); 
    fscanf(fin,"%lf",&dum); 
  }
  fclose(fin);
}


int main(){

  struct eqkfm *eqfm;

  FILE    *fout, *fin1, *fin2;
  char    farfalleheaderfile[120], slipmodelfile[120], slipmodellist[160], pscmpfile[120], gridfile[160], probfile[160], outname[160], sdum[100], befehl[160], line[200];
  char    executabledirectory[200];
  double  **S;	                //stress tensor
  double  porepressure=0;	//pore pressure.
  double  *d, *rdist, *probmain, *deps, *minmaxL, *minmaxW;
  double  minL, maxL, minW, maxW, xL, xW, L, W, dL, dW;
  double  lambda, mu, friction, Skempton, mag, time, dumlat, dumlon, prob, dd;
  double  strike0, dip0, rake0, strike1, dip1, rake1, strike2, dip2, rake2;
  double  cmb;
  int     err=0;
  int     i, n, p, nz, idum, nslip, NF, NSLIP, z1, z2, NL, NW, nselect;

  printf("\n");   
  scanf("%s",  &farfalleheaderfile);
  printf("%s\n",farfalleheaderfile);
  scanf("%s",  &slipmodellist);
  printf("%s\n",slipmodellist);

   // read  Ngrid, lat[i], lon[i], dlat, dlon
  scanf("%s", &gridfile);

  readgrid(gridfile);
  printf("%s read\n",gridfile);

  // read directory of local executable files:
  scanf("%s",&executabledirectory);

  // minimum and maximum depth for CFS- and nearest-distance-calculation (integers [km]):
  z1 = 1;
  z2 = 15;

  sprintf(pscmpfile,"output/pscmp.inp");
  sprintf(probfile, "output/probvalues.out");

  probmain = dvector(1,Ngrid);
  rdist    = dvector(1,Ngrid);
  d        = dvector(1,Ngrid);
  deps     = dvector(1,Ngrid);

  minmaxL  = dvector(0,1);
  minmaxW  = dvector(0,1);


  err=read_farfalle0(farfalleheaderfile,&lambda,&mu,&friction,&Skempton,&S);

  printf("\t read_farfalle0: lambda=%e  mu=%e  friction=%.2lf  Skempton=%.2lf\n",lambda,mu,friction,Skempton);   

  fin1=fopen(slipmodellist,"r");
  fscanf(fin1,"%d",&NSLIP);

  for(nslip=1;nslip<=NSLIP;nslip++){
    fscanf(fin1,"%d",&idum);
    fscanf(fin1,"%d",&idum);
    fscanf(fin1,"%s",&slipmodelfile);
 
    err=read_farfalle_eqkfm(slipmodelfile, &eqfm, &NF);

    cmbopt(S[1][1],S[2][2],S[3][3],S[1][2],S[2][3],S[3][1],porepressure,friction,&cmb,&strike1,&dip1,&rake1,&strike2,&dip2,&rake2);
   
    for(i=1;i<=Ngrid;i++) probmain[i]=0.0;

    for(nselect=1;nselect<=2;nselect++){

      if(nselect==1){ strike0=strike1; dip0=dip1; rake0=rake1; }
      if(nselect==2){ strike0=strike2; dip0=dip2; rake0=rake2; }

      printf("strike0=%lf  dip0=%lf  rake0=%lf\n",strike0,dip0,rake0);

      fout=fopen(pscmpfile,"w");
      fprintf(fout,"# lambda     mu  \n");
      fprintf(fout," %lf   %lf\n",lambda,mu);
      fprintf(fout,"# friction, skempton, strike, dip, rake, sigma1, sigma2, sigma3\n");
      fprintf(fout," 1  %.3lf  %.3lf  %.3lf  %.3lf  %.3lf  0.000E+00  0.000E+00  0.000E+00\n",friction,Skempton,strike0,dip0,rake0);
      fprintf(fout,"#===============================================================================\n");
      fprintf(fout," %d                                                                             \n",NF);
      fprintf(fout,"#-------------------------------------------------------------------------------\n");
      fprintf(fout,"# n   O_lat   O_lon    O_depth length  width strike dip   np_st np_di start_time\n");
      fprintf(fout,"# [-] [deg]   [deg]    [km]    [km]     [km] [deg]  [deg] [-]   [-]   [day]     \n");
      fprintf(fout,"#     pos_s   pos_d    slp_stk slp_dip open                                     \n");
      fprintf(fout,"#     [km]    [km]     [m]     [m]     [m]                                      \n");
      fprintf(fout,"#-------------------------------------------------------------------------------\n");
      fclose(fout);
      err+=print_slipmodel(pscmpfile,eqfm,NF);
      
      //printf("lambda=%lf  mu=%lf  friction=%lf  Skempton=%lf  strike=%lf  dip=%lf  rake=%lf\n",lambda,mu,friction,Skempton,strike0,dip0,rake0);
      printf("\n\t Inputfile of slipmodelfile=%s rewritten into %s\n\n",slipmodelfile,pscmpfile);
      
      
      
      // ******** PERFORM EXTERNAL STRESS CALCULATION ***********************  
      sprintf(outname,"output/run_BACHcalculation.sh");
      fout=fopen(outname,"w");
      fprintf(fout,"#! /bin/bash\n\n");
      fprintf(fout,"# * INPUT: pscmpfile\n");
      fprintf(fout,"# *        minimum depth [km]\n");
      fprintf(fout,"# *        maximum depth [km]\n");
      fprintf(fout,"# *        delta depth   [km]\n");
      fprintf(fout,"# *        number of receiver mechanisms\n");
      fprintf(fout,"# *        uncertainty [°]\n\n");
      fprintf(fout,"(echo \"./%s\"; echo \"./%s\";  echo \"./%s\"; echo %d; echo %d; echo 1; echo 100; echo 20) | %s/calculate_CHRISTOPH_probmaps\n",pscmpfile,gridfile,probfile,z1,z2,executabledirectory);
      fclose(fout);
      sprintf(befehl,"chmod u+x %s",outname);
      system(befehl); 
      sprintf(befehl,"./%s",outname);
      system(befehl);
      // ********************************************************************  
      
      
      // ******** READ PROBABILITY VALUES ***********************************  
      fin2=fopen(probfile,"r");
      for(n=1;n<=4;n++) fscanf(fin2,"%s",&sdum);
      for(i=1;i<=Ngrid;i++){
	fscanf(fin2,"%lf",&dumlat);
	fscanf(fin2,"%lf",&dumlon);
	fscanf(fin2,"%lf",&prob);
	if(dumlat==gridlat[i] && dumlon==gridlon[i]) probmain[i]+=0.5*prob;
	else{ printf("\n\n\t ATTENTION: i=%d  dumlat=%lf  gridlat=%lf  dumlon=%lf  gridlon=%lf\n\n",i,dumlat,gridlat[i],dumlon,gridlon[i]); exit(1); }
      }
      fclose(fin2);
      printf("\t mainshock-probmap %s read\n",probfile);
      // ********************************************************************  
    }
      
    // ******** CALCULATE NEAREST DISTANCES *******************************
    for(i=1;i<=Ngrid;i++) rdist[i]=1e10;    
    
    for(nz=z1;nz<=z2;nz++){
      
      for(i=1;i<=Ngrid;i++) deps[i]=1.0*nz;
	
      for(n=0;n<NF;n++){
	
	L=eqfm[n].L;
	W=eqfm[n].W;
	
	NL=eqfm[n].np_st;
	NW=eqfm[n].np_di;
	
	dL=L/(1.0*NL);
	dW=W/(1.0*NW);
	
	minL=1e10; maxL=-1e10;
	minW=1e10; maxW=-1e10;
	
	for(p=1;p<=NL*NW;p++){
	  xL=eqfm[n].pos_s[p];
	  xW=eqfm[n].pos_d[p];  
	  if(xL<minL) minL=xL;
	  if(xL>maxL) maxL=xL;
	  if(xW<minW) minW=xW;
	  if(xW>maxW) maxW=xW;
	}
	minL-=0.5*dL;
	maxL+=0.5*dL;
	minW-=0.5*dW;
	maxW+=0.5*dW;
	
	minmaxL[0]=minL;
	minmaxL[1]=maxL;
	minmaxW[0]=minW;
	minmaxW[1]=maxW;
	
	d = dist2fault(gridlat,gridlon,deps,Ngrid,eqfm[n].str1,eqfm[n].dip1,eqfm[n].lat,eqfm[n].lon,eqfm[n].depth,minmaxL,minmaxW);
	
	for(i=1;i<=Ngrid;i++){
	  dd=fabs(d[i]);
	  if(dd<fabs(rdist[i])) rdist[i]=d[i];
	}
      }
    }
    // ********************************************************************  
    
    
    // ******** WRITE FILES WITH GRIDPOINTS  PROBABILITY & NEAREST DISTANCE  *******************************
    sprintf(outname,"output/slipmodel%d_probr",nslip);
    fout=fopen(outname,"w");
    
    // if date instead of time is given:
    // calculatejulday(yy,mm,dd,hh,min,sec,&time);
    fprintf(fout,"Event-Index(all-events)____mainshockindex_indmain= %d\n",idum);
    for(i=1;i<=Ngrid;i++) fprintf(fout,"%d\t%lf\t%lf\t%e\t%lf\n",i,gridlat[i],gridlon[i],probmain[i],fabs(rdist[i]));
    fclose(fout);
    // *****************************************************************************************************  
    
  }
  fclose(fin1);

  
  free_dvector(probmain,1,Ngrid);
  free_dvector(rdist,1,Ngrid);
  free_dvector(deps,1,Ngrid);

  printf("\n");

  return(err==0);

}
