double calculate_timeintegral(int j, double Na, double c, double p, double *dc, double *dp)
{
  double   sum, dc1, dp1, norm, dumc1, dumc2, dump1, dump2;
  double   ti1, ti2, t1, t2, tt1, tt2, dum1, dum2, integtime, TT1, TT2;
  int      i, i0, ii, count, sett;

 // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));
  // derivative of c regarding norm:
  dumc2 =  - sq(norm) * pow(1.0+Tafter/c,-p) * (1.0-p) * Tafter/sq(c);
  // derivative of p regarding norm:
  dump2  =  - sq(norm) * log(1.0+Tafter/c) * pow(1.0+Tafter/c,1.0-p);

  dc1=0.0;
  dp1=0.0; 
  sum=0.0;
  
  ti1=tall[j];

  if(t[1]>=tall[j]+Tafter){
  
    if(T1<tall[j]+Tafter){
    
      ti2=tall[j]+Tafter;

    // loop over completeness periods
      for(ii=1;ii<=NK;ii++){ 
	TT1 = tc[1][ii];
	TT2 = tc[2][ii];
      
	if(TT1<ti2 && TT2>ti1){
	  if(ti1<TT1) t1=TT1;
	  else        t1=ti1;
	  if(ti2>TT2) t2=TT2;
	  else        t2=ti2;
	
	  // fraction of Na in [t1,tend]:
	  tt1  = 1.0+(t1-tall[j])/c;
	  tt2  = 1.0+(t2-tall[j])/c;
	  dum1 = pow(tt1,1.0-p);
	  dum2 = pow(tt2,1.0-p);
	  integtime = dum1 - dum2;
	  
	  sum += spaceweightall[j][1] * Na * norm * integtime;
	  //printf("j=%d  i=%d  spaceweightall=%lf  Na=%lf  norm=%lf  integtime=%lf  --> sum=%e\n",j,1,spaceweightall[j][1],Na,norm,integtime,sum);
	  
	  // derivative of c regarding integtime:
	  dumc1 = - (1.0-p) * pow(c,-2.0) * ( pow(tt1,-p)*(t1-tall[j]) - pow(tt2,-p)*(t2-tall[j]) );
	  
	  // combination:
	  dc1 +=  spaceweightall[j][1] * Na * (norm*dumc1 + dumc2*integtime);
	  
	  // derivative of p regarding integtime:
	  dump1 = - ( dum1*log(tt1) - dum2*log(tt2) );
	  
	  // combination:
	  dp1 +=  spaceweightall[j][1] * Na * (norm*dump1 + dump2*integtime);
	}
      }
    }
  }
  else{

    i0=Z;  // for the case that j=Zall

    for(i=1;i<=Z;i++) if(t[i]>tall[j] && t[i]<tall[j]+Tafter){
      
      i0=i;
      
      ti2=t[i];
      
      // loop over completeness periods
      for(ii=1;ii<=NK;ii++){ 
	TT1 = tc[1][ii];
	TT2 = tc[2][ii];
	
	if(TT1<ti2 && TT2>ti1){
	  if(ti1<TT1) t1=TT1;
	  else        t1=ti1;
	  if(ti2>TT2) t2=TT2;
	  else        t2=ti2;
	  
	  // fraction of Na in [t1,tend]:
	  tt1  = 1.0+(t1-tall[j])/c;
	  tt2  = 1.0+(t2-tall[j])/c;
	  dum1 = pow(tt1,1.0-p);
	  dum2 = pow(tt2,1.0-p);
	  integtime = dum1 - dum2;
	  
	  sum += spaceweightall[j][i] * Na * norm * integtime;
	  //printf("j=%d  i=%d  spaceweightall=%lf  Na=%lf  norm=%lf  integtime=%lf  --> sum=%e\n",j,i,spaceweightall[j][i],Na,norm,integtime,sum);
	  
	  // derivative of c regarding integtime:
	  dumc1 = - (1.0-p) * pow(c,-2.0) * ( pow(tt1,-p)*(t1-tall[j]) - pow(tt2,-p)*(t2-tall[j]) );
	  
	  // combination:
	  dc1 +=  spaceweightall[j][i] * Na * (norm*dumc1 + dumc2*integtime);
	  
	  // derivative of p regarding integtime:
	  dump1 = - ( dum1*log(tt1) - dum2*log(tt2) );
	  
	  // combination:
	  dp1 +=  spaceweightall[j][i] * Na * (norm*dump1 + dump2*integtime);
	}
      }
      ti1=ti2;
    }
  }
  
  if(i0<Z) i0++;
  
  // now for triggering of event j after largest time t[i]<tall[j]+Tafter until tall[j]+Tafter :
  if(tall[j]+Tafter>ti1){
    
    ti2=tall[j]+Tafter;
    
    for(ii=1;ii<=NK;ii++){
      TT1 = tc[1][ii];
      TT2 = tc[2][ii];
      if(TT2>ti1){
	if(ti1<TT1) t1=TT1;
	else        t1=ti1;
	if(ti2>TT2) t2=TT2;
	else        t2=ti2;
	
	// fraction of Na in [t1,tend]:
	tt1  = 1.0+(t1-tall[j])/c;
	tt2  = 1.0+(t2-tall[j])/c;
	dum1 = pow(tt1,1.0-p);
	dum2 = pow(tt2,1.0-p);
	integtime = dum1 - dum2;
	
	sum += spaceweightall[j][i0] * Na * norm * integtime;
	
	// derivative of c regarding integtime:
	dumc1 = - (1.0-p) * pow(c,-2.0) * ( pow(tt1,-p)*(t1-tall[j]) - pow(tt2,-p)*(t2-tall[j]) );
	
	// combination:
	dc1 +=  spaceweightall[j][i0] * Na * (norm*dumc1 + dumc2*integtime);
	
	// derivative of p regarding integtime:
	dump1 = - ( dum1*log(tt1) - dum2*log(tt2) );
	
	// combination:
	dp1 +=  spaceweightall[j][i0] * Na * (norm*dump1 + dump2*integtime);
      }
    }
  }
  
  *dc=dc1;
  *dp=dp1;

  //if(sett==1){ printf(" ........... sum=%lf\n\n",sum); exit(1); }

  if(sum==0) printf("*************** j=%d  tall[j]=%lf  tall[j]+Tafter=%lf  t[1]=%lf  t[Z]=%lf  spaceweightall[j][Z]=%lf.... ti1=%lf sum=%lf\n",j,tall[j],tall[j]+Tafter,t[1],t[Z],spaceweightall[j][Z],ti1,sum); 
   
  return sum;
}
