double timeintegral(int j, double TIME, double Na, double c, double p)
{
  double   sum, norm;
  double   ti1, ti2, t1, t2, tt1, tt2, dum1, dum2, integtime, TT1, TT2, dtt;
  int      i, ii, count;

 // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

  sum=0.0;
  
  ti1=tall[j];
  for(i=1;i<=Z;i++) if(ti1<TIME) if(t[i]>tall[j] && t[i]<=tall[j]+Tafter){
    ti2=t[i];
    // loop over completeness periods
    for(ii=1;ii<=NK;ii++){ 
      TT1 = tc[1][ii];
      TT2 = tc[2][ii];
      
      if(TT1<ti2 && TT2>ti1){
	if(ti1<TT1) t1=TT1;
	else        t1=ti1;
	if(ti2>TT2) t2=TT2;
	else        t2=ti2;
	
	// fraction of Na in [t1,tend]:
	tt1  = 1.0+(t1-tall[j])/c;
	tt2  = 1.0+(t2-tall[j])/c;

	dum1 = pow(tt1,1.0-p);
	dum2 = pow(tt2,1.0-p);
	integtime = dum1 - dum2;
	
	//dtt = tt2-tt1;
	//integtime = dum1*(1-pow(tt2/tt1,1.0-p));

	sum += spaceweightall[j][i] * Na * norm * integtime;
      }
    }
    ti1=ti2;
  }
  // now for triggering of event j after time t[Z]:
  i=Z;
  ti1=t[i];
  if(TIME>ti1){
    for(ii=1;ii<=NK;ii++){
      TT1 = tc[1][ii];
      TT2 = tc[2][ii];
      if(TT1<TIME && TT2>ti1){
	if(TT2>TIME) TT2=TIME;
	if(ti1<TT1) t1=TT1;
	else        t1=ti1;
	if(tall[j]+Tafter>TT2) t2=TT2;
	else                   t2=tall[j]+Tafter;
	// fraction of Na in [t1,tend]:
	tt1  = 1.0+(t1-tall[j])/c;
	tt2  = 1.0+(t2-tall[j])/c;
	dum1 = pow(tt1,1.0-p);
	dum2 = pow(tt2,1.0-p);
	integtime = dum1 - dum2;
	
	//dtt = tt2-tt1;
	//integtime = dum1*(1-pow(tt2/tt1,1.0-p));
	
	sum += spaceweightall[j][i] * Na * norm * integtime;
      }
    }
  }
  return sum;
}


void  calculatetransformedtime_dtcomplete(char *outname, double mu, double c, double p, double M0, double N0, double alpha)
{
  FILE     *fout;
  double   sum, mag,  Na, time, timesum, dc, dp, TT1, TT2;
  int      i, j, k;

  fout=fopen(outname,"w");

  for(k=1;k<=Z;k++){
    time=t[k];
    
    // loop over completeness periods
    timesum=0.0;
    for(i=1;i<=NK;i++) if(tc[1][i]<time){
      TT1 = tc[1][i];
      if(tc[2][i]<=time) TT2 = tc[2][i];
      else               TT2 = time;
      timesum += TT2-TT1;
    }

    sum=mu*timesum;

    for(i=1;i<=Zall;i++) if(tall[i]<time){

      mag = mall[i];

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0 * pow(10.0,alpha*(mag-Mcut));
    
      sum += timeintegral(i,time,Na,c,p);
    }
    fprintf(fout,"%d\t%lf\t%lf\n",k,t[k],sum);
  }
  fclose(fout);
  printf("\n\t Output-File %s written\n\n",outname);
}
