
  /* minimization by davidon-fletcher-powell procedure */


void linear_nospace(double *xp, double *h, double *ramm, double *eee, int npara0, int *igg){

  /*  this subroutine performs the linear search along the direction spe */
  /*      by the vector h */

  /*      inputs: */
  /*         x:       vector of position */
  /*         h:       search direction */
  /*         k:       dimension of vector x */
  
  /*      outputs: */
  /*         ram:     optimal step width */
  /*         e2:      minimum function value */
  /*         ig:      error code */

  double *x1, *g;
  double a1, a2, a3, b1, b2, ee;
  double const2, hnorm, e1, e2, e3, ram, ram1, ram2, ram3;
  int    i, ireturn, ifg, ig, isw, ipr, sub;

  if(setprint==1) printf("linear search...\n");

  ram= *ramm;
  ee = *eee;

  x1  = dvector(1,npara0);
  g   = dvector(1,npara0);

  isw = 1;
  ipr = 7;
  if( ram <= 1.0e-30 )  ram = 0.01;
  const2 = 1.0e-60;

  ram2 = ram;
  hnorm = 0.0;
  for(i=1;i<=npara0;i++){
    hnorm += h[i]*h[i];
    x1[i]  = xp[i] + ram2*h[i];
  }
  hnorm = sqrt( hnorm );


  e1 =ee;
  ram1 = 0.0;

  /* for(i=1;i<=npara0;i++) if(setprint==1) printf("x1[%d]=%lf  %lf\n",i,x1[i],sq(x1[i])); */
  LogLike_nospace(x1,&e2,g,&ig);

  if(ipr==7)  if(setprint==1) printf(" lambda =%18.10e\t\t e2 =%25.17e\n",ram2,e2);

  if(ig==1 || e2>e1) goto fuenfzig;

 dreissig:
    ram3 = ram2*2.0;
    for(i=1;i<=npara0;i++) x1[i] = xp[i] + ram3*h[i];
    LogLike_nospace(x1,&e3,g,&ig);
    
    if( ig==1 )  goto  fuenfhundert;
    
    if( ipr>=7 ) if(setprint==1) printf(" lambda =%18.10e\t\t e3 =%25.17e\n",ram3,e3);
    if( e3 > e2 ) goto siebzig;
    ram1 = ram2;
    ram2 = ram3;
    e1 = e2;
    e2 = e3;
    
    goto dreissig;
    
 fuenfzig:
    
    ram3 = ram2;
    e3 = e2;
    ram2 = ram3*0.1;
    
    if( ram2*hnorm < const2 )  goto  vierhundert;
    
    for(i=1;i<=npara0;i++) x1[i] = xp[i] + ram2*h[i];
    LogLike_nospace(x1,&e2,g,&ig);
    
    if( ipr>=7 ) if(setprint==1) printf(" lambda =%18.10e\t\t e4 =%25.17e\n",ram2,e2);

    if( e2>e1 )  goto fuenfzig;
    
    
 siebzig:
    ireturn=80;
    goto zweihundert;
    
 achtzig:
      for(i=1;i<=npara0;i++) x1[i] = xp[i] + ram*h[i];
      LogLike_nospace(x1,&ee,g,&ig);
      if( ipr>=7 ) if(setprint==1) printf(" lambda =%18.10e\t\t e5 =%25.17e\n",ram,ee);
      
      ifg = 0;
      sub=200;
      
 fuenfundneunzig:
      ireturn=130;
      if( ram > ram2 )  goto hundertzehn;
      if( ee >= e2 )    goto hundert;
      ram3 = ram2;
      ram2 = ram;
      e3 =e2;
      e2 =ee;
      
      if(sub==200) goto zweihundert;
      if(sub==300) goto dreihundert;
      
 hundert:
      ram1 = ram;
      e1 = ee;
      if(sub==200) goto zweihundert;
      if(sub==300) goto dreihundert;
      
 hundertzehn:
      if( ee <= e2 )  goto hundertzwanzig;
      ram3 = ram;
      e3 = ee;
      if(sub==200) goto zweihundert;
      if(sub==300) goto dreihundert;
      
 hundertzwanzig:
      ram1 = ram2;
      ram2 = ram;
      e1 = e2;
      e2 = ee;
      if(sub==200) goto zweihundert;
      if(sub==300) goto dreihundert;
      
 hundertdreissig:
      for(i=1;i<=npara0;i++) x1[i] = xp[i] + ram*h[i];
      LogLike_nospace(x1,&ee,g,&ig);
      if( ipr>=7 ) if(setprint==1) printf(" lambda =%18.10e\t\t e6 =%25.17e\n",ram,ee);
      
      sub=200;
      ifg = ifg+1;
      ifg = 0;
      if( ifg==1 )  goto fuenfundneunzig;
      
      if( e2 < ee )  ram = ram2;
      goto raus;
      
      /* -------  internal subroutine sub1  ------- */
 zweihundert:
      a1 = (ram3-ram2)*e1;
      a2 = (ram1-ram3)*e2;
      a3 = (ram2-ram1)*e3;
      b2 = (a1+a2+a3)*2.0;
      b1 = a1*(ram3+ram2) + a2*(ram1+ram3) + a3*(ram2+ram1);
      if( b2 == 0.0 )  goto zweihundertzehn;
      ram = b1 /b2;
      
      if(ireturn==80)  goto achtzig;
      if(ireturn==130) goto hundertdreissig;
      
 zweihundertzehn:
      ig = 1;
      ram = ram2;
      goto raus;
      
      /* -------  internal subroutine sub2  ------- */
 dreihundert:
      if( ram3-ram2 > ram2-ram1 )  goto dreihundertzehn;
      ram = (ram1+ram2)*0.5;
      if(ireturn==80)  goto achtzig;
      if(ireturn==130) goto hundertdreissig;
      
 dreihundertzehn:
      ram = (ram2+ram3)*0.5;
      if(ireturn==80)  goto achtzig;
      if(ireturn==130) goto hundertdreissig;
      
 vierhundert:
      ram = 0.0;
      goto raus;
      /*  ------------------------------------------------------------ */
      
 fuenfhundert:
      ram = (ram2+ram3)*0.5;
 fuenfhundertzehn:
      for(i=1;i<=npara0;i++) x1[i] = xp[i] + ram*h[i];
      LogLike_nospace(x1,&e3,g,&ig);
      if( ipr>=7 ) if(setprint==1) printf(" lambda =%18.10e\t\t e7 =%25.17e\n",ram,e3);
      
      if( ig==1 )  goto fuenfhundertvierzig;
      if( e3>e2 )  goto fuenfhundertdreissig;
      ram1 = ram2;
      ram2 = ram;
      e1 = e2;
      e2 = e3;
      goto fuenfhundert;
      
 fuenfhundertdreissig:
      ram3 = ram;
      goto siebzig;
      
 fuenfhundertvierzig:  
      ram = (ram2+ram)*0.5;
      goto fuenfhundertzehn;


 raus:
      *eee =ee;
      *ramm=ram;
      *igg=ig;

      free_dvector(x1,1,npara0);
      free_dvector(g,1,npara0);
}
/* *************************************************************************** */
/* *************************************************************************** */


void davidn_nospace(double *xp, int npara0){

  double **h, *g, *g0, *s, *dx, *wrk, *yy;
  double  tau1, tau2, eps1, eps2, const1, ramda;
  double  sum, s1, s2, stem, ss, ds2, gtem, ed, xm, xmb;
  int    i, j, ig, ic, icc, isw;

  tau1= 1.0e-5;
  tau2= 1.0e-5;
  eps1= 1.0e-5;
  eps2= 1.0e-5;
  
  /*   ACHTUNG: hier kann die Stabilität eingestellt werden:  */
  /*          if NAN --> ramda kleiner wählen */
  /*       ramda = 0.5d0   orginal Wert */
  /* ramda = 0.5e-7; */
  ramda = 0.5e-7;
  /* -------------------------------------------- */
  const1 = 1.0e-70;

  h   = dmatrix(1,npara0,1,npara0);
  g   = dvector(1,npara0);
  g0  = dvector(1,npara0);
  s   = dvector(1,npara0);
  dx  = dvector(1,npara0);
  wrk = dvector(1,npara0);
  yy  = dvector(1,npara0);

  for(i=1;i<=npara0;i++){
    for(j=1;j<=npara0;j++) h[i][j]=0.0;
    g0[i]  =0.0;
    s[i]   =0.0;
    dx[i]  =0.0;
    h[i][i]=1.0;
  }
  isw=0;
 /*  if(setprint==1) printf("1.hallo %lf  %lf %lf %lf %lf %lf %lf\n",xp[1],xp[2],xp[3],xp[4],xp[5],xp[6],xp[7]); */  
  LogLike_nospace(xp,&xm,g,&ig);
  if(setprint==1) printf("1. LL=%lf\n",xm);  

  for(icc=1;icc<=npara0;icc++){

    for(ic=1;ic<=npara0;ic++){

      /* if(setprint==1) printf("icc=%d  ic=%d\n",icc,ic); */

      if( ic!=1 || icc!=1 ){
	for(i=1;i<=npara0;i++) yy[i] = g[i] - g0[i];
	for(i=1;i<=npara0;i++){
	  sum=0.0;
	  for(j=1;j<=npara0;j++) sum += yy[j] * h[i][j];
	  wrk[i] = sum;
	}
	s1 = 0.0;
	s2 = 0.0;
	for(i=1;i<=npara0;i++){
	  s1 = s1 + wrk[i] * yy[i];
	  s2 = s2 + dx[i]  * yy[i];
	  /* if(ic==2) if(setprint==1) printf("i=%d  s1=%lf  s2=%lf\n",i,s1,s2); */
	}
	/* if(ic==2) exit(1); */

	if( s1<=const1 || s2<=const1 )  goto raus;
 
	/* update the inverse of hessian matrix */
	
	if( s1>s2 ){
	  /*  ---  davidon-fletcher-powell type correction  --- */
	  for(i=1;i<=npara0;i++) for(j=i;j<=npara0;j++){
	    h[i][j] = h[i][j] + dx[i]*dx[j]/s2 - wrk[i]*wrk[j]/s1;
	    h[j][i] = h[i][j];
	    /* if(ic==2) if(setprint==1) printf("A  i=%d j=%d sum=%lf\n",i,j,h[i][j]); */
	  }
	}
	/* go to  120 */
	else{
	  /* ---  fletcher type correction  --- */
	  
	  stem = s1 / s2 + 1.0;
	  for(i=1;i<=npara0;i++) for(j=i;j<=npara0;j++){
	    h[i][j] = h[i][j]- (dx[i]*wrk[j]+wrk[i]*dx[j]-dx[i]*dx[j]*stem)/s2;
	    h[j][i] = h[i][j];
	    /* if(ic==2) if(setprint==1) printf("B  i=%d j=%d sum=%lf\n",i,j,h[i][j]); */
	  }
	}
      }
     
      ss = 0.0;
      for(i=1;i<=npara0;i++){
	sum = 0.0;
	for(j=1;j<=npara0;j++) sum += h[i][j]*g[j];
	ss += sum*sum;
	s[i] = -sum;
	/* if(setprint==1) printf("i=%d  sum=%lf\n",i,sum);  */
      }

      s1 = 0.0;
      s2 = 0.0;
      for(i=1;i<=npara0;i++){
	s1 += s[i]*g[i];
	s2 += g[i]*g[i];
      }
      ds2 = sqrt(s2);
      gtem = fabs(s1) / ds2;
      
      if( gtem <= tau1 ||  ds2 <= tau2 )  goto  raus;
      
      if( s1>=0.0 ){  
	for(i=1;i<=npara0;i++){
	  for(j=1;j<=npara0;j++) h[i][j] = 0.0;
	  h[i][i] = 1.0;
	  s[i] = -s[i];
	}
      }
    
      ed = xm;
      /* linear_nospace  search */
/*       if(ic==2){ */
/* 	for(i=1;i<=npara0;i++) if(setprint==1) printf("i=%d  p=%lf  s=%lf\n",i,xp[i],s[i]);  */
/* 	exit(1); */
/*       } */
      linear_nospace( xp,s,&ramda,&ed,npara0,&ig);

      if(setprint==1) printf("lambda =%15.7e\t -LL =%23.15e  %9.2e  %9.2e\n",ramda,ed,s1,s2);
/*       for(i=1;i<=npara0;i++) if(setprint==1) printf("i=%d  p=%lf  s=%lf\n",i,xp[i],s[i]); */
/*       exit(1); */

      s1 = 0.0;
      for(i=1;i<=npara0;i++){
	dx[i] = s[i] * ramda;
	s1    = s1 + dx[i] * dx[i];
	g0[i] = g[i];
	xp[i]  = xp[i] + dx[i];
      }
      xmb = xm;
      isw = 0;
      
      LogLike_nospace(xp,&xm,g,&ig);
      
      s2 = 0.0;
      for(i=1;i<=npara0;i++) s2 = s2 + g[i]*g[i];

      /* if(setprint==1) printf("LL=%lf\n",xm); */
/*       for(i=1;i<=npara0;i++) if(setprint==1) printf("i=%d  p=%lf  s=%lf\n",i,xp[i],g[i]);  */

/*       if(setprint==1) printf("s2=%lf  %lf   %lf\n",s2,sqrt(s2),tau2); */
/*       if(setprint==1) printf("xmb/xm-1=%lf  %lf  %lf  %lf\n",xmb/xm-1,eps2,sqrt(s1),eps2); */
      
      if(sqrt(s2)<= tau2) if( xmb/xm-1.0 < eps1 &&  sqrt(s1) < eps2 )  goto raus;
    }
  }
 raus:
  if(setprint==1) printf("-----  x  -----\n");
  for(i=1;i<=npara0;i++) if(setprint==1) printf("\t%lf",sq(xp[i]));
  if(setprint==1) printf("\n***  gradient  ***\n" );
  for(i=1;i<=npara0;i++) if(setprint==1) printf("\t%9.2e",g[i]);


  free_dmatrix(h,1,npara0,1,npara0);
  free_dvector(g,1,npara0);
  free_dvector(g0,1,npara0);
  free_dvector(s,1,npara0);
  free_dvector(dx,1,npara0);
  free_dvector(wrk,1,npara0);
  free_dvector(yy,1,npara0);

}


