void smooth(int Nnearest, double *weight, double *res, long *seed0)
{
  double  *rr, *xxlat, *xxlon, *reshelp, dum, r, R, norm;
  int     i, j, k, n, NN;
  long    seed;

  seed = *seed0;

  xxlat   = dvector(1,Z);
  xxlon   = dvector(1,Z);
  rr      = dvector(1,Z);  
  reshelp = dvector(1,Ngrid);

  NN=0;
  for(i=1;i<=Z;i++){
    dum = ran1(&seed);
    if(dum<=weight[i]){
      NN++;
      xxlat[NN]=lat[i];
      xxlon[NN]=lon[i];
    }
  }

  if(NN>=Nsmoothmin){

    for(n=1;n<=Ngrid;n++) res[n]=0.0;
  
    for(i=1;i<=NN;i++){
      
      // calculate distance R to the Nnearest background-event:
      k=0;
      for(j=1;j<=NN;j++) if(i!=j){
	k++;
	rr[k]=distance(xxlat[i],xxlon[i],xxlat[j],xxlon[j]);  
      }
      sortd(k,rr);
      R=rr[Nnearest];
      if(R<locerror) R=locerror;
      
      // use R for Gaussian-smoothing of this event:
      norm=0.0; 
      for(n=1;n<=Ngrid;n++){ r=distance(xxlat[i],xxlon[i],gridlat[n],gridlon[n]); dum=exp(-0.5*sq(r/R)); reshelp[n]=dum; norm+=dum; }
      for(n=1;n<=Ngrid;n++) res[n] += reshelp[n]/(norm*NN);
    }
  }
  else for(n=1;n<=Ngrid;n++) res[n]=1.0/(1.0*Ngrid);

  free_dvector(xxlat,1,Z);
  free_dvector(xxlon,1,Z);
  free_dvector(rr,1,Z);  
  free_dvector(reshelp,1,Ngrid);

  *seed0 = seed;
}

void calculatebackgroundweights(double mu, double c, double p, double M0, double N0, double alpha, double *weight){
  double  norm, Na, mag, lambda, mu0, rr, fr, fr1, ftt, dum;
  int     i, k, ii, jj, igrid, count, NE;

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

  for(i=1;i<=Z;i++){
    
    igrid = indgrid[i];   // grid-point-index of this event
  
    if(spacebackground==1) mu0 = mu*probback[igrid]/dvol[igrid];
    else                   mu0 = mu*1.0/vol;
    
    lambda = mu0;
    for(k=1;k<=Zall;k++) if(tall[k]<t[i] && tall[k]+Tafter>=t[i]){

      mag = mall[k];

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0 * pow(10.0,alpha*(mag-Mcut));
      

      if(useMainshockprobmaps==0 || setmain[k]==0){
	NE = Nepi[k]; 

	count=0; for(ii=1;ii<=NE;ii++){ jj=Indexepi[k][ii]; if(tall[jj]<t[i]) count++; }

	fr = 0.0;
	for(ii=1;ii<=NE;ii++){
	  jj = Indexepi[k][ii];
	  if(tall[jj]<t[i]){
	    rr=distance(lat[i],lon[i],latall[jj],lonall[jj]); 
 	    if(count<NDLmin) fspatialdL(mag,rr,&fr1);
	    else             fspatial(rr,&fr1);
	    fr += fr1;
	  }
	}
	fr /= 1.0*count;
      }
      else if(setmain[k]>=1){
	ii=setmain[k];
	if(useMainshockprobmaps==1)      fr=probmain[ii][igrid]/dvol[igrid];
	else if(useMainshockprobmaps==2) fr=probmaindist[ii][igrid]/dvol[igrid];
      }

      // normalized function for Tafter:
      ftt  = norm * (p-1.0) * pow(c,p-1.0) / pow(c+t[i]-tall[k],p);

      lambda += fr * Na * ftt;
    }

    weight[i] = mu0/lambda;
  }
}


void  decluster(){
  FILE   *fout;
  char   outname[160];
  double *weight, *helpback;
  double mu, c, p, M0, N0, alpha, norm;
  int    i, n, Nnearest, NSUR;
  long   seed;

  NSUR     = 1000;
  Nnearest = 4;       // smoothing distance is calculated for distance to the Nnearest neighbor (see Helmstetter et al. SRL 2007)

  seed=9024702;

  mu    = MUvalue;
  c     = Cvalue;
  p     = Pvalue;
  M0    = M0value;          
  N0    = N0value;           
  alpha = ALPHAvalue;     
 
  // calculate probability for each event to be background: 
  weight = dvector(1,Z);
  calculatebackgroundweights(mu,c,p,M0,N0,alpha,weight);

  helpback=dvector(1,Ngrid);

  for(n=1;n<=Ngrid;n++) probback[n]=0.0;
  for(i=1;i<=NSUR;i++){
    smooth(Nnearest,weight,helpback,&seed);
    for(n=1;n<=Ngrid;n++) probback[n] += helpback[n]/(1.0*NSUR);
  }
  norm=0.0;
  for(n=1;n<=Ngrid;n++) norm += probback[n];
  if(norm!=1.0) for(n=1;n<=Ngrid;n++) probback[n] /= norm;

  sprintf(outname,"output/estimated-background-probmap.out");
  fout=fopen(outname,"w"); 
  for(n=1;n<=Ngrid;n++) fprintf(fout,"%lf\t%lf\t%e\n",gridlat[n],gridlon[n],probback[n]);
  fclose(fout);
  printf("\t output-File %s written\n",outname);

  free_dvector(helpback,1,Ngrid);
  free_dvector(weight,1,Z);
}

