

double  LLvalueM0(double *vi, double integvi, double timesum, double mu, double M0, double *dLL){
  double LL, dum;
  int    i;

  LL=0.0; *dLL=0.0;
  for(i=1;i<=Z;i++) if(t[i]>=T1 && t[i]<=T2){
    if(setRETAS==1) dum=mu+vi[i]/M0;
    else            dum=mu+M0*vi[i];
    LL   += log(dum);
    *dLL += vi[i]/dum;
  }
    
  LL -= mu*timesum;
  if(setRETAS==1) LL -= integvi/M0;
  else            LL -= M0*integvi;
  *dLL -= integvi;

  if(setRETAS==1) *dLL *= -1.0/sq(M0);

  return LL;
}


void LLoptimizeM0(double mu, double c, double p, double *M0res, double *N0res, double alpha, double *LLvalue){
  double  *vi, integvi, norm, Na, mag, lambda, ftt, dc, dp;
  double  TT1, TT2, M0, M00, dM0, LL, LL0, dLL, timesum;
  int     i, j, k, setgo;

  if(setRETAS==1) M0 = *M0res;
  else            M0 = *N0res;

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));


  // calculation of vi(t) = trigger(t)/M0:
  vi = dvector(1,Z);

  for(i=1;i<=Z;i++) if(t[i]>=T1 && t[i]<=T2) {
    lambda=0.0;
    for(j=1;j<=Zall;j++) if(tall[j]<t[i] && tall[j]+Tafter>=t[i]){
      mag = mall[j];

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag);
	else           Na = C*Cstar*pow(10.0,alpha0*mag);
      }
      else             Na = pow(10.0,alpha*(mag-Mcut));
      
      // accounting for the percentage triggered within the LL-space:
      Na *= spaceweightall[j][i];           
      //if(Na<=0) printf("i=%d  j=%d Na=%lf   spaceweightall[j][i]=%lf\n",i,j,Na,spaceweightall[j][i]);

      // normalized function for Tafter = infinity:
      ftt  = (p-1.0) * pow(c,p-1.0) / pow(c+t[i]-tall[j],p);
      lambda += Na * norm * ftt;
    }
    vi[i]=lambda;
  }
  
  // loop over completeness periods
  timesum=0.0;
  for(k=1;k<=NK;k++){
    TT1 = tc[1][k];
    TT2 = tc[2][k];
    timesum += TT2-TT1;
  }

  // integral of vi(t) over time:
  integvi=0.0;  
  for(i=1;i<=Zall;i++) if(tall[i]<=T2){

    mag = mall[i];
    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag);
      else           Na = C*Cstar*pow(10.0,alpha0*mag);
    }
    else             Na = pow(10.0,alpha*(mag-Mcut));
    
    integvi += calculate_timeintegral(i,Na,c,p,&dc,&dp);
  }
  
  LL=LLvalueM0(vi,integvi,timesum,mu,M0,&dLL);
  
  dM0 = 0.01*M0*dLL/fabs(dLL);
  
  setgo=1;
  while(setgo==1){
    M00 = M0 + dM0;  
    LL0=LLvalueM0(vi,integvi,timesum,mu,M00,&dLL); 
    if(LL0>LL){ LL=LL0; M0=M00; }
    else setgo=0;
  }


  if(setRETAS==1) *M0res = M0;
  else            *N0res = M0;

  *LLvalue = LL;

  free_dvector(vi,1,Z);
}


void LLoptimize_nospace_select(double *mu, double *c, double *p, double *M0, double *N0, double *alpha, int set1, int set2, int set3, int set4, int set5, int set6, double *LL){
  double   *ghelp, *xp, *xpara, nLL;
  int      i, k, npara;
 
  // PARAMETER for davidn-search of LL for given Mstar:
  npara = 6;
  set   = ivector(1,npara);
  xp    = dvector(1,npara);
  ghelp = dvector(1,npara);
  xpara = dvector(1,npara);

  xpara[1]=*mu;      set[1]=set1; 
  xpara[2]=*c;       set[2]=set2; 
  xpara[3]=*p;       set[3]=set3; 
  xpara[4]=*M0;      set[4]=set4;   
  xpara[5]=*N0;      set[5]=set5;
  xpara[6]=*alpha;   set[6]=set6;


  /* PARAMETER-ESTIMATION_____________ */
  for(i=1;i<=npara;i++) xp[i]=sqrt(xpara[i]);
  for(i=1;i<=2;i++) davidn_nospace(xp,npara);
  for(i=1;i<=npara;i++) xpara[i]=sq(xp[i]);
  LogLike_nospace(xp,&nLL,ghelp,&i);

  *mu    = xpara[1];
  *c     = xpara[2];
  *p     = xpara[3];
  *M0    = xpara[4];
  *N0    = xpara[5];
  *alpha = xpara[6];

  *LL = -nLL;

  free_ivector(set,1,npara);
  free_dvector(xp,1,npara);
  free_dvector(ghelp,1,npara);
  free_dvector(xpara,1,npara);
}


void LLoptimize_space_select(double *mu, double *c, double *p, double *M0, double *N0, double *alpha, int set1, int set2, int set3, int set4, int set5, int set6, double *LL){
  double   *ghelp, *xp, *xpara, nLL;
  int      i, k, npara;

  // PARAMETER for davidn-search of LL for given Mstar:
  npara = 6;
  set   = ivector(1,npara);
  xp    = dvector(1,npara);
  ghelp = dvector(1,npara);
  xpara = dvector(1,npara);

  // PARAMETER-ESTIMATION_____________:
  xpara[1]=*mu;      set[1]=set1; 
  xpara[2]=*c;       set[2]=set2; 
  xpara[3]=*p;       set[3]=set3; 
  xpara[4]=*M0;      set[4]=set4;   
  xpara[5]=*N0;      set[5]=set5;
  xpara[6]=*alpha;   set[6]=set6;

  for(i=1;i<=npara;i++) xp[i]=sqrt(xpara[i]);
  for(i=1;i<=2;i++) davidn(xp,npara);
  for(i=1;i<=npara;i++) xpara[i]=sq(xp[i]);
  LogLike(xp,&nLL,ghelp,&i);

  *mu    = xpara[1];
  *c     = xpara[2];
  *p     = xpara[3];
  *M0    = xpara[4];  
  *N0    = xpara[5];
  *alpha = xpara[6];
  *LL = -nLL;

  free_ivector(set,1,npara);
  free_dvector(xp,1,npara);
  free_dvector(ghelp,1,npara);
  free_dvector(xpara,1,npara);
}

void calculateNdirect(double mu, double c, double p, double M0, double N0, double alpha)
{
  double  **vi;
  double  norm, mu0, mag, Na, fr, fr1, ftt, lambda, w0, w1, max, rr, dum;
  int     i, k, ii, jj, indk, idum, igrid, count, NE;


  vi = dmatrix(1,Zall,1,Zall);

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

  for(i=1;i<=Zall;i++){
    
    igrid = indgridall[i];   // grid-point-index of this event

    for(k=1;k<=i-1;k++){
      mag = mall[k];

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0 * pow(10.0,alpha*(mag-Mcut));

      if(useMainshockprobmaps==0 || setmain[k]==0){
	NE    = Nepi[k]; 

	count=0; for(ii=1;ii<=NE;ii++){ jj=Indexepi[k][ii]; if(tall[jj]<t[i]) count++; }

	fr=0.0;
	for(ii=1;ii<=NE;ii++){
	  jj = Indexepi[k][ii];
	  if(tall[jj]<tall[i]){
	    rr=distance(latall[i],lonall[i],latall[jj],lonall[jj]);  
	    if(count<NDLmin) fspatialdL(mag,rr,&fr1);
	    else             fspatial(rr,&fr1);
	    fr += fr1;
	  }
	}
	fr /= 1.0*count;
      }
      else if(setmain[k]>=1){
	ii=setmain[k];
	if(useMainshockprobmaps==1)      fr=probmain[ii][igrid]/dvol[igrid];
	else if(useMainshockprobmaps==2) fr=probmaindist[ii][igrid]/dvol[igrid];
      }

      // normalized function for Tafter:
      ftt  = norm * (p-1.0) * pow(c,p-1.0) / pow(c+tall[i]-tall[k],p);

      vi[i][k]   = fr * Na * ftt;
    }
  }

  // now reset Nepi and Indexepi:
  for(i=1;i<=Zall;i++){ Nepi[i]=1; Indexepi[i][1]=i; }

  for(i=1;i<=Zall;i++){
    
    igrid = indgridall[i];   // grid-point-index of this event
    if(spacebackground==1) mu0 = mu*probback[igrid]/dvol[igrid];
    else                   mu0 = mu*1.0/vol;
    
    lambda = mu0;
    for(k=1;k<=i-1;k++) lambda += vi[i][k];
    
    w0  = mu0/lambda;
    max = 0.0;
    for(k=1;k<=i-1;k++){
      w1 = vi[i][k]/lambda;
      if(w1>w0) if(w1>max){ max=w1; indk=k; }
    }
    if(max>0.0){
      Nepi[indk]++;
      idum=Nepi[indk];
      Indexepi[indk][idum]=i;
      //printf("i=%d/%d --> k=%d  (m[k]=%.2lf  Nepi[k]=%d)\n",i,Zall,indk,mall[indk],Nepi[indk]); 
    }
  }

  // recalculate spatial weights because distribution of sources for aftershock-triggering for each event might have changed:
  calculatespaceweights();

  free_dmatrix(vi,1,Zall,1,Zall);
}

void optimize_nospaceparameter(int *indmag, double *mu0, double *c0, double *p0, double *M00, double *N00, double *alpha00, double *LL){
  double    LL0, LL00, LLvalue, dLLloop, dLL, dLLmin, mu, c, p, M0, N0, alpha, Mmax, mag;
  int    i, k, nmag, indlargest, nloop, iteration, setmu, setc, setp, setM0, setN0, setalpha;

  printf("optimize parameters mu, c, p, M0 without spatial information with dM changes:\n");

  mu    = *mu0;
  c     = *c0;
  p     = *p0;
  M0    = *M00;
  N0    = *N00;
  alpha = *alpha00;

  dLLmin=0.1;

  // optimize all parameters:
  setmu=1; setc=1; setp=1; setM0=1; setN0=1;  setalpha=1; 
  LLoptimize_nospace_select(&mu,&c,&p,&M0,&N0,&alpha,setmu,setc,setp,setM0,setN0,setalpha,&LLvalue); 
  
  if(setRETAS==1){
    Mmax=Mmaxvalue(M0);
    printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf  (--> Mmax=%.2lf)  LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
  }
  else  printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf  alpha=%lf  LL=%lf\n",0,mu,c,p,N0,alpha,LLvalue);   


  nloop=0;
  dLLloop=10.0;
  while(dLLloop>dLLmin){
    nloop++;
    
    LL00 = LLvalue;
    LL0  = LL00;
    
    for(nmag=1;nmag<=Nlargest;nmag++){
      
      indlargest = indmag[nmag];

      iteration=0;
      
      dLL = 10.0;
      while(dLL>dLLmin){
	iteration++;
	
	LogLike_nospace_magoptimization(indlargest,mu,c,p,M0,N0,alpha,&mag); 
	//printf("nloop=%d: ....................  LL=%lf --> m=%.2lf\n",nloop,LLvalue,mag);   
	LLoptimizeM0(mu,c,p,&M0,&N0,alpha,&LLvalue);
	//printf("nloop=%d: nlargest=%d iteration=%d  mu=%lf  c=%lf   p=%lf  M0=%lf  LL=%lf --> m=%.2lf\n",nloop,nmag,iteration,mu,c,p,M0,LLvalue,mag);   
	
	dLL=LLvalue-LL0;   
	LL0=LLvalue;
      }
    } 
    if(setRETAS==1){
      Mmax=Mmaxvalue(M0);
      printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf  (--> Mmax=%.2lf)  LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
    }
    else printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf  alpha=%lf  LL=%lf\n",nloop,mu,c,p,N0,alpha,LLvalue);

    dLLloop=LLvalue-LL00;
    if(LLvalue>LL00) LL00=LLvalue;
  }

  *mu0     = mu;
  *c0      = c;
  *p0      = p;
  *M00     = M0;
  *N00     = N0;
  *alpha00 = alpha;
  *LL      = LL00;
}

double ratio_model_obs(double mu, double c, double p, double M0, double N0, double alpha)
{
  double   sum, mag, Na, norm, timesum, ratio, dc, dp, TT1, TT2;
  int      i, j, count;

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

  sum=0.0;
  for(j=1;j<=Zall;j++){
    mag = mall[j];
    
    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
      else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
    }
    else             Na = N0*pow(10.0,alpha*(mag-Mcut));
  
    sum += calculate_timeintegral(j,Na,c,p,&dc,&dp);
  }

  // loop over completeness periods
  timesum=0.0;
  for(i=1;i<=NK;i++){
    TT1 = tc[1][i];
    TT2 = tc[2][i];
    timesum += TT2-TT1;
  }

  count=0; for(i=1;i<=Z;i++) if(t[i]>=T1 && t[i]<=T2) count++;
  
  ratio = sum/(1.0*count-mu*timesum);
  //printf("count=%d  sum=%lf  ratio=%lf\n",count,sum+mu*timesum,ratio);
  return ratio;
}


void estimation_parameter(char *suffx)
{
  FILE     *fout, *fout1;
  char     outname[160], outname1[160];
  double   *mallorg, *weight, timeweight, Na, time, tt1, tt2, mu, c, p, M0, N0, alpha, Mmax, dLL, dLLmin, LL0, LLvalue, ratio;
  double   dum, dM, dMmin;
  int      *ind, *indmag, nmag, indlargest;
  int      i, nloop, setmu, setc, setp, setM0, setN0, setalpha, setq, setd, count;

  dLLmin=0.1;
 
  // ************** calculate the magnitude range of the events (excluding the last ones):
  // if too small than do not estimate trigger parameters:
  dMmin=2.5;
  dM=0.0; for(i=1;i<=Z-10;i++){ dum=m[i]-Mcut; if(dum>dM) dM=dum; }
  printf("magnitude range = %.2lf  dMmin=%lf\n",dM,dMmin);
  // ************************************************************************************


  sprintf(outname,"output/parameter-%s.out",suffx);
  fout=fopen(outname,"w"); 
  if(setRETAS==1) fprintf(fout,"#-loop      mu        c          p      M0        LL\n"); 
  else            fprintf(fout,"#-loop      mu        c          p      N0     alpha       LL\n"); 
  fclose(fout);


  // ****** set start values *********************************************************************************************:
  mu    = 0.1*Z/(T2-T1);
  c     = 0.01;  // [days]
  p     = 1.1;
  //M0    = pow(10.0,1.5*(Mmin+3)); 
  Mmax  = 7.5;
  M0    = pow(10.0,1.5*Mmin)*(bvalue/(1.5-bvalue))*(pow(10.0,(1.5-bvalue)*(Mmax-Mmin))-1.0)/(1.0-pow(10.0,-bvalue*(Mmax-Mmin)));
  N0    = pow(10.0,-1.2*bvalue);   // events triggered by an event with mag=Mcut: start value = Bath law with alpha=bvalue
  alpha = bvalue;
  if(setRETAS==1) printf("start values: mu=%lf  c=%lf   p=%lf  M0=%lf  (bvalue=%.1lf Mmin=%.1lf Mmax=%.1lf)\n\n",mu,c,p,M0,bvalue,Mmin,Mmax); 
  else            printf("start values: mu=%lf  c=%lf   p=%lf  N0=%lf  alpha=%lf\n\n",mu,c,p,N0,alpha);   


  nloop=0;

  // (1) ****** NO-SPACE estimation *******************************************************************************************:
  if(Z<Zmin1){
    // optimize only parameters mu 
    setmu=1; setc=0; setp=0; setM0=0; setN0=0;  setalpha=0; 
    LLoptimize_nospace_select(&mu,&c,&p,&M0,&N0,&alpha,setmu,setc,setp,setM0,setN0,setalpha,&LLvalue); 
   if(setRETAS==1){
      Mmax=Mmaxvalue(M0);
      printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf  (--> Mmax=%.2lf)  LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
    }
    else printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf  alpha=%lf  LL=%lf\n",nloop,mu,c,p,N0,alpha,LLvalue);
  }
  else{
    if(Z<Zmin2 || dM<dMmin){
      // optimize only parameters mu and N0/M0:
      setmu=1; setc=0; setp=0; setM0=1; setN0=1;  setalpha=0; 
      LLoptimize_nospace_select(&mu,&c,&p,&M0,&N0,&alpha,setmu,setc,setp,setM0,setN0,setalpha,&LLvalue); 
      if(setRETAS==1){
	Mmax=Mmaxvalue(M0);
	printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf  (--> Mmax=%.2lf)  LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
      }
      else printf("\t nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf  alpha=%lf  LL=%lf\n",nloop,mu,c,p,N0,alpha,LLvalue);
    }   
    else if(Z>=Zmin2){
      //     -----> ETAS parameters + dM-changes (of the Nlargest events) *********************************************************:
      mallorg = dvector(1,Nlargest);
      weight  = dvector(1,Zall);
      ind     = ivector(1,Zall);
      indmag  = ivector(1,Nlargest);
      
      //indexxd(Zall,mall,ind);
      
      for(i=1;i<=Zall;i++){
	// total number of aftershocks:
	if(setRETAS==1){
	  if(mall[i]<=Mstar) Na = C*pow(10.0,1.5*mall[i])/M0;
	  else               Na = C*Cstar*pow(10.0,alpha0*mall[i])/M0;
	}
	else                 Na = N0*pow(10.0,alpha*(mall[i]-Mcut));
	// fraction of events occurring inside [T1 T2+T]:
	time = T1-tall[i];  if(time<0.0) time=0.0;
	tt1  = 1.0+time/c;
	tt2  = 1.0+(time+T2+T-T1)/c;
	timeweight = pow(tt1,1.0-p)-pow(tt2,1.0-p); 
	// number of aftershocks of event i within LL-space: 
	weight[i] = Na * xweightDL[i] * timeweight;
      }
      indexxd(Zall,weight,ind);
      printf(" ... event-selection for optimization of the magnitude are selected according their weight in the LLspace\n\n");
      
      nmag=0; count=Zall;
      while(count>=1 && nmag<Nlargest){
	indlargest = ind[count];
	nmag++;
	indmag[nmag]=indlargest; 
	mallorg[nmag] = mall[indlargest]; 
	// printf("nmag=%d  indmag=%d  m=%lf\n",nmag,indmag[nmag],mall[indlargest]);
	count--;
      }
      if(nmag<Nlargest){ printf("\n\n\t ATTENTION: nmag=%d < Nlargest=%d  --> Nlargest=%d\n\n",nmag,Nlargest,nmag); Nlargest=nmag; }
      
      //for(nmag=1;nmag<=Nlargest;nmag++){ indlargest = ind[Zall+1-nmag];   indmag[nmag]=indlargest; mallorg[nmag] = mall[indlargest]; }
      
      optimize_nospaceparameter(indmag,&mu,&c,&p,&M0,&N0,&alpha,&LLvalue);
      
      sprintf(outname1,"output/magchanges-%s.out",suffx);
      fout1=fopen(outname1,"w"); 
      fprintf(fout1,"#  index   original-Mag     new-Mag\n");
      for(nmag=1;nmag<=Nlargest;nmag++){ indlargest=indmag[nmag];  fprintf(fout1,"%d\t%d\t%lf\t%lf\n",nmag,indmag[nmag],mallorg[nmag],mall[indlargest]); }
      fclose(fout1);
      printf("\n\t output-File %s written\n\n",outname1);
      
      free_ivector(ind,1,Zall);     
      free_dvector(weight,1,Zall);  
      free_ivector(indmag,1,Nlargest);
      free_dvector(mallorg,1,Nlargest);
    }

    if(setRETAS==1){
      Mmax=Mmaxvalue(M0);
      printf("nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf (--> Mmax=%.2lf)    LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
      fout=fopen(outname,"a");  fprintf(fout,"%d \t %lf\t%lf\t%lf\t%lf  \t %lf\n",nloop,mu,c,p,M0,LLvalue); fclose(fout);
    }
    else{
      printf("nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf   alpha=%lf    LL=%lf\n",nloop,mu,c,p,N0,alpha,LLvalue);   
      fout=fopen(outname,"a");  fprintf(fout,"%d \t %lf\t%lf\t%lf\t%lf\t%lf  \t %lf\n",nloop,mu,c,p,N0,alpha,LLvalue); fclose(fout);
    }

    // (2) ****** LOOP TO FIND DIRECT AFTERSHOCKS AS SOURCE FOR FUTURE AFERSHOCKS **************************************************:
    //     ---> update Nepi[i] and Indexepi[i][1, ... Nepi[i]] *********************************************************************:
    setmu=1; setc=0; setp=0; setalpha=0; setM0=0; setN0=0;
    if(setRETAS==1) setM0=1;
    else            setN0=1; 
  
    LLvalue = -1e12;
    dLL     = 10000.0;  
    while(dLL>dLLmin){
      
      LL0 = LLvalue;
      LLoptimize_space_select(&mu,&c,&p,&M0,&N0,&alpha,setmu,setc,setp,setM0,setN0,setalpha,&LLvalue);
      
      if(setRETAS==1) Mmax=Mmaxvalue(M0);
      if(LLvalue>LL0){ 
	nloop++;
	
	calculateNdirect(mu,c,p,M0,N0,alpha);	
	
	if(setRETAS==1){
	  printf("nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf (--> Mmax=%.2lf)    LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
	  fout=fopen(outname,"a");  fprintf(fout,"%d \t %lf\t%lf\t%lf\t%lf  \t %lf\n",nloop,mu,c,p,M0,LLvalue); fclose(fout);
	}
	else{
	  printf("nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf   alpha=%lf    LL=%lf\n",nloop,mu,c,p,N0,alpha,LLvalue);   
	  fout=fopen(outname,"a");  fprintf(fout,"%d \t %lf\t%lf\t%lf\t%lf\t%lf  \t %lf\n",nloop,mu,c,p,N0,alpha,LLvalue); fclose(fout);
	}
      }
      dLL=LLvalue-LL0;
      LL0=LLvalue;  
    }

    
    // (3) ****** ADJUST total modeled event number TO observed number ********** **************************************************:
    //     -----> ratio ************************************************************************************************************: 
    nloop++;
    ratio = ratio_model_obs(mu,c,p,M0,N0,alpha);
    //printf("ratio=%lf\n",ratio);
    if(setRETAS==1) M0 *= ratio;
    else            N0 /= ratio;
    LogLike_nospace_directinput(mu,c,p,M0,N0,alpha,&LLvalue);
    
    if(setRETAS==1){
      Mmax=Mmaxvalue(M0);
      printf("nloop=%d:  mu=%lf  c=%lf   p=%lf  M0=%lf (--> Mmax=%.2lf)    LL=%lf\n",nloop,mu,c,p,M0,Mmax,LLvalue);   
      fout=fopen(outname,"a");  fprintf(fout,"%d \t %lf\t%lf\t%lf\t%lf  \t %lf\n",nloop,mu,c,p,M0,LLvalue); fclose(fout);
    }
    else{
      printf("nloop=%d:  mu=%lf  c=%lf   p=%lf  N0=%lf   alpha=%lf    LL=%lf\n",nloop,mu,c,p,N0,alpha,LLvalue);   
      fout=fopen(outname,"a");  fprintf(fout,"%d \t %lf\t%lf\t%lf\t%lf\t%lf  \t %lf\n",nloop,mu,c,p,N0,alpha,LLvalue); fclose(fout);
    }
  }

  // (5) ****** COMPARISON OF MODEL AND DATA *********************************** *************************************************************:
  //     -----> transformed times ************************************************************************************************************: 
  sprintf(outname1,"output/transformedtime-%s.out",suffx);
  calculatetransformedtime_dtcomplete(outname1,mu,c,p,M0,N0,alpha);


  MUvalue = mu;
  Cvalue  = c;
  Pvalue  = p; 
  M0value = M0;
  N0value = N0;
  ALPHAvalue = alpha;
}

