

void fspatial(double rr, double *res){
  double    pi, q, d;

  q=Qvalue;
  d=Dvalue;

  pi= 3.14159265358979;
  *res=(q/pi)*pow(d,2.0*q)/pow(sq(rr)+sq(d),1+q);
}


void fspatialdL(double mag, double rr, double *res){
  double    pi, L, dL, q, d;

  q=Qvalue;
  d=D0value;

 // subsurface rupture length all mechanisms: Wells & Coppersmith, BSSA 1994, Tab.2a:
  L  = pow(10.0,-2.44+0.59*mag); 
  dL = d*L;
  if(dL<locerror) dL=locerror;

  pi= 3.14159265358979;

  *res      = (q/pi)*pow(dL,2.0*q)/pow(sq(rr)+sq(dL),1+q);
}

void LogLike(double *b, double *nLL, double *h, int *ifg){
  double  mu, c, p, M0, N0, alpha, Na, mag, norm, ftt, dumc1, dumc2, dump1, dump2;
  double  lambda, mu0, dmu, dc, dc1, dp, dp1, dM0, dM01, dN0, dN01, dalpha, dalpha1, fr1, Xij, Xi;
  double  pi, rr, f, fr, ft, ff, fs, TT1, TT2, timesum, dumdc, dumdp;
  double  g1, g2,  g3, g4, g5, g6, max;
  int     i, j, k, jj, NE, count, igrid;


  max=1e20;

  pi=3.14159265358979;

  mu    = b[1]*b[1];
  c     = b[2]*b[2];
  p     = b[3]*b[3];
  M0    = b[4]*b[4];  
  N0    = b[5]*b[5];
  alpha = b[6]*b[6];

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));
  // derivative of c regarding norm:
  dumc2 =  - sq(norm) * pow(1.0+Tafter/c,-p) * (1.0-p) * Tafter/sq(c);
  // derivative of p regarding norm:
  dump2  =  - sq(norm) * log(1.0+Tafter/c) * pow(1.0+Tafter/c,1.0-p);


  // reset help-values:
  ff     = 0.0;
  dmu    = 0.0;
  dc     = 0.0;
  dp     = 0.0;
  dM0    = 0.0;
  dN0    = 0.0;
  dalpha = 0.0;
 

  for(i=1;i<=Z;i++) if(t[i]>=T1 && t[i]<=T2) {
 
    igrid = indgrid[i];   // index of the corresponding grid-point

    // reset help-values1:
    dc1     = 0.0;
    dp1     = 0.0; 
    dM01    = 0.0;
    dN01    = 0.0;
    dalpha1 = 0.0;

    if(spacebackground==1) mu0 = mu*probback[igrid]/dvol[igrid];
    else                   mu0 = mu*1.0/vol;

    lambda = mu0;

    for(j=1;j<=Zall;j++) if(tall[j]<t[i] && tall[j]+Tafter>=t[i]){

      mag = mall[j];

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0*pow(10.0,alpha*(mag-Mcut));

      NE    = Nepi[j]; 
      fr    = 0.0; 

      if(useMainshockprobmaps==0 || setmain[j]==0){

	count=0; for(k=1;k<=NE;k++){ jj=Indexepi[j][k]; if(tall[jj]<t[i]) count++; }

	for(k=1;k<=NE;k++){
	  jj = Indexepi[j][k];
	  if(tall[jj]<t[i]){
	    rr=distance(lat[i],lon[i],latall[jj],lonall[jj]); 
	    if(count<NDLmin) fspatialdL(mag,rr,&fr1);
	    else             fspatial(rr,&fr1);
	    fr += fr1;
	  }
	}
	fr /= 1.0*count;
      }
      else if(setmain[j]>=1){
	jj=setmain[j];
	if(useMainshockprobmaps==1)      fr=probmain[jj][igrid]/dvol[igrid];
        else if(useMainshockprobmaps==2) fr=probmaindist[jj][igrid]/dvol[igrid];
      }

      // normalized function for Tafter = infinity:
      ftt  = (p-1.0) * pow(c,p-1.0) / pow(c+t[i]-tall[j],p);

      // normalization factor due to Tafter: norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

      Xij  = fr * Na * norm * ftt;

      lambda += Xij; 
 
      // derivative of c regarding ftt:
      dumc1 =  ftt* ( (p-1.0)/c - p/(c+t[i]-tall[j]) );
      // combination:
      dc1 += fr * Na * (norm*dumc1 + dumc2*ftt);


      // derivative of p regarding ftt:
      dump1 =  ftt *  ( 1.0/(p-1.0) + log(c) - log(c+t[i]-tall[j]) );
      // combination:
      dp1  += fr * Na * (norm*dump1 + dump2*ftt);

      if(setRETAS==1) dM01 -= Xij / M0;
      else{
	dN01    += Xij / N0;
	dalpha1 += Xij * log(10.0) * (mag-Mcut);
      }
    }

    ff     += log(lambda);
    dmu    += mu0/(mu*lambda);
    dc     += dc1/lambda;
    dp     += dp1/lambda;  
    dM0    += dM01/lambda;
    dN0    += dN01/lambda;
    dalpha += dalpha1/lambda;
  }
  
  ft      = 0.0;
  dc1     = 0.0;
  dp1     = 0.0;  
  dM01    = 0.0;
  dN01    = 0.0;
  dalpha1 = 0.0;
   
  // loop over completeness periods
  timesum=0.0;
  for(k=1;k<=NK;k++){
    TT1 = tc[1][k];
    TT2 = tc[2][k];
    timesum += TT2-TT1;
  }

  for(i=1;i<=Zall;i++) if(tall[i]<T2){

    mag = mall[i];

    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
      else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
    }
    else             Na = N0 * pow(10.0,alpha*(mag-Mcut));
    
    Xi = calculate_timeintegral(i,Na,c,p,&dumdc,&dumdp);
 
    ft  += Xi;  
    dc1 += dumdc;
    dp1 += dumdp;
       

    if(setRETAS==1) dM01 -=  Xi / M0;
    else{
      dN01    += Xi / N0;
      dalpha1 += Xi * log(10.0) * (mag-Mcut);
    }
  }
  
  fs = mu*timesum + ft;
  f  = ff-fs;

  g1=0.0;  g2=0.0;  g3=0.0;  g4=0.0;  g5=0.0;  g6=0.0;
 
  if(set[1]==1)  g1 = dmu - timesum;
  if(set[2]==1)  g2 = dc  - dc1;
  if(set[3]==1)  g3 = dp  - dp1;  
  if(set[4]==1)  g4 = dM0 - dM01;
  if(set[5]==1)  g5 = dN0 - dN01;
  if(set[6]==1)  g6 = dalpha - dalpha1;

  f=-f;
  h[1] =-g1 *2.0*b[1];
  h[2] =-g2 *2.0*b[2];
  h[3] =-g3 *2.0*b[3];
  h[4] =-g4 *2.0*b[4];
  h[5] =-g5 *2.0*b[5];
  h[6] =-g6 *2.0*b[6];

  *nLL=f;

  if(fabs(f)<max) *ifg=0;
  else{
    *ifg=1;
    *nLL=1.0e30;
  }
}

