



void LogLike_nospace(double *b, double *nLL, double *h, int *ifg){
  double  mu, c, p, M0, N0, alpha, Na, mag;
  double  lambda, dmu, dc, dc1, dp, dp1, dM0, dM01, dN0, dN01, dalpha, dalpha1, Xij, Xi;
  double  f, fr, ft, ff, fs, dumc1, dumc2, dump1, dump2, dumdc, dumdp;
  double  TT1, TT2, timesum, norm, ftt;
  double  g1, g2,  g3, g4, g5, g6, max;
  int     i, j, k, count;

  max=1e20;

  mu    = b[1]*b[1];
  c     = b[2]*b[2];
  p     = b[3]*b[3];
  M0    = b[4]*b[4];
  N0    = b[5]*b[5];
  alpha = b[6]*b[6];

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));
  // derivative of c regarding norm:
  dumc2 =  - sq(norm) * pow(1.0+Tafter/c,-p) * (1.0-p) * Tafter/sq(c);
  // derivative of p regarding norm:
  dump2  =  - sq(norm) * log(1.0+Tafter/c) * pow(1.0+Tafter/c,1.0-p);

  // reset help-values:
  ff     = 0.0;
  dmu    = 0.0;
  dc     = 0.0;
  dp     = 0.0;
  dM0    = 0.0;
  dN0    = 0.0;
  dalpha = 0.0;

  //printf("Tafter=%lf  mu=%lf  c=%lf  p=%lf  N0=%lf  M0=%lf  alpha=%lf\n",Tafter,mu,c,p,N0,M0,alpha);

  count=0;
  for(i=1;i<=Z;i++) if(t[i]>=T1 && t[i]<=T2) {
    count++;

    // reset help-values1:
    dc1     = 0.0;
    dp1     = 0.0;
    dM01    = 0.0;
    dN01    = 0.0;
    dalpha1 = 0.0;

    lambda = mu;

    for(j=1;j<=Zall;j++) if(tall[j]<t[i] && tall[j]+Tafter>=t[i]){

      mag = mall[j];
      
      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0 * pow(10.0,alpha*(mag-Mcut));

      // accounting for the percentage triggered within the LL-space:
      Na *= spaceweightall[j][i];           
      
      // normalized function for Tafter = infinity:
      ftt  = (p-1.0) * pow(c,p-1.0) / pow(c+t[i]-tall[j],p);

      // normalization factor due to Tafter: norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

      Xij  = Na * norm * ftt;

      lambda += Xij;  

      // derivative of c regarding ftt:
      dumc1 =  ftt* ( (p-1.0)/c - p/(c+t[i]-tall[j]) );

      // combination:
      dc1 += Na * (norm*dumc1 + dumc2*ftt);

      // derivative of p regarding ftt:
      dump1 =  ftt *  ( 1.0/(p-1.0) + log(c) - log(c+t[i]-tall[j]) );

      // combination:
      dp1  += Na * (norm*dump1 + dump2*ftt);

      if(setRETAS==1) dM01 -= Xij / M0;
      else{
	dN01    += Xij / N0;
	dalpha1 += log(10.0)*(mag-Mcut) * Xij;
      }
    }
    ff     += log(lambda);     //printf("i=%d  lambda=%lf  ff=%lf\n",i,lambda,ff);
    dmu    += 1.0/lambda;
    dc     += dc1/lambda;
    dp     += dp1/lambda;
    dM0    += dM01/lambda;
    dN0    += dN01/lambda;
    dalpha += dalpha1/lambda;
  }
  
  ft      = 0.0;
  dc1     = 0.0;
  dp1     = 0.0;
  dM01    = 0.0;
  dN01    = 0.0;
  dalpha1 = 0.0;

  
  // loop over completeness periods
  timesum=0.0;
  for(k=1;k<=NK;k++){
    TT1 = tc[1][k];
    TT2 = tc[2][k];
    timesum += TT2-TT1;
  }

  for(i=1;i<=Zall;i++) if(tall[i]<T2){

    mag = mall[i];

    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
      else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
    }
    else             Na = N0 * pow(10.0,alpha*(mag-Mcut));
    
    Xi = calculate_timeintegral(i,Na,c,p,&dumdc,&dumdp);
 
    ft  += Xi;  
    dc1 += dumdc;
    dp1 += dumdp;
       
   
    if(setRETAS==1) dM01 -=  Xi / M0;
    else{
      dN01    += Xi / N0;
      dalpha1 += Xi * log(10.0) * (mag-Mcut);
      //printf("i=%d Xi=%lf  ft=%lf  dN01=%lf  dalpha1=%lf\n",i,Xi,ft,dN01,dalpha1);
    }
  }
  fs = mu*timesum + ft;
  f  = ff-fs;

  //printf("count=%d  fs=%lf  T2=%lf  t[Z]=%lf  tall[Zall]=%lf\n",count,fs,T2,t[Z],tall[Zall]);

  g1=0.0;  g2=0.0;  g3=0.0;  g4=0.0;  g5=0.0;  g6=0.0;
 
  if(set[1]==1)  g1 = dmu - timesum;
  if(set[2]==1)  g2 = dc  - dc1;
  if(set[3]==1)  g3 = dp  - dp1;
  if(set[4]==1)  g4 = dM0 - dM01;
  if(set[5]==1)  g5 = dN0 - dN01;
  if(set[6]==1)  g6 = dalpha - dalpha1;
 
  //printf(" ff=%lf  fs=%lf --> f=%lf\n",ff,ft,f);
  //printf(" dmu=%lf  dc=%lf  dp=%lf  dM0=%lf  dN0=%lf  dalpha=%lf\n",dmu,dc,dp,dM0,dN0,dalpha);
  //printf(" timesum=%lf  dc1=%lf  dp1=%lf  dM01=%lf  dN01=%lf  dalpha1=%lf\n",timesum,dc1,dp1,dM01,dN01,dalpha1);
  //printf(" g1=%lf  g2=%lf  g3=%lf  g4=%lf  g5=%lf  g6=%lf\n",g1,g2,g3,g4,g5,g6);
  //exit(1);

  f=-f;
  h[1] =-g1 *2.0*b[1];
  h[2] =-g2 *2.0*b[2];
  h[3] =-g3 *2.0*b[3];
  h[4] =-g4 *2.0*b[4];
  h[5] =-g5 *2.0*b[5];
  h[6] =-g6 *2.0*b[6];

  *nLL=f;

  if(fabs(f)<max) *ifg=0;
  else{
    *ifg=1;
    *nLL=1.0e30;
  }
}

