

void LogLike_nospace_directinput(double mu, double c, double p, double M0, double N0, double alpha, double *LL){
  double  Na, mag, lambda;
  double  ft, ff, dc, dp, Xi;
  double  TT1, TT2, timesum, norm, ftt;
  int     i, j, k;

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

  // reset help-values:
  ff  = 0.0;
  for(i=1;i<=Z;i++) if(t[i]>=T1 && t[i]<=T2) {
    lambda = mu;
    for(j=1;j<=Zall;j++) if(tall[j]<t[i] && tall[j]+Tafter>=t[i]){

      mag = mall[j];

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0*pow(10.0,alpha*(mag-Mcut));

      // accounting for the percentage triggered within the LL-space:
      Na *= spaceweightall[j][i];    


      // normalized function for Tafter = infinity:
      ftt  = (p-1.0) * pow(c,p-1.0) / pow(c+t[i]-tall[j],p);
      // normalization factor due to Tafter: norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));
      lambda += Na * norm * ftt;
    }
    ff  += log(lambda);
  }
  
 
  
  // loop over completeness periods
  timesum=0.0;
  for(k=1;k<=NK;k++){
    TT1 = tc[1][k];
    TT2 = tc[2][k];
    timesum += TT2-TT1;
  }

  ft = mu*timesum;

  for(i=1;i<=Zall;i++) if(tall[i]<T2){

    mag = mall[i];

    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
      else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
    }
    else             Na = N0 * pow(10.0,alpha*(mag-Mcut));
    
    Xi = calculate_timeintegral(i,Na,c,p,&dc,&dp);
 
    ft  += Xi;  
    
  }

  *LL = ff-ft;
}

