void LLvalue_nospace(int indlargest, double dmagindlargest, double mu, double c, double p, double M0, double N0, double alpha, double *f, double *df){
  double  Na, time, mag;
  double  lambda, dmag, Xi, dumdc, dumdp;
  double  ff, ft, dff, dft, dc, dp, TT1, TT2, timesum, norm;
  int     i, j, k;

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));

  time = tall[indlargest];
  
  //printf("indlargest=%d   time=%lf=%lf  mag=%lf\n",indlargest,time,tall[indlargest],mall[indlargest]);

  ff  = 0.0;
  dff = 0.0;
  for(i=1;i<=Z;i++) if(t[i]>time && t[i]<=T2){

    lambda = mu;
    for(j=1;j<=Zall;j++) if(tall[j]<t[i] && tall[j]+Tafter>=t[i]){
      mag = mall[j];
      if(j==indlargest) mag += dmagindlargest;

      if(setRETAS==1){
	if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
	else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             Na = N0*pow(10.0,alpha*(mag-Mcut));
         
      // accounting for the percentage triggered within the LL-space:
      Na *= spaceweightall[j][i]; 

      lambda += Na * norm * (p-1.0) * pow(c,p-1.0) / pow(c+t[i]-tall[j],p);
    }
    
    if(t[i]<=time+Tafter){
      mag  = mall[indlargest] + dmagindlargest;

      if(setRETAS==1){
	if(mag<=Mstar) dmag = log(10.0)*1.5 * C*pow(10.0,1.5*mag)/M0;
	else           dmag = log(10.0)*alpha0 * C*Cstar*pow(10.0,alpha0*mag)/M0;
      }
      else             dmag = log(10.0)*alpha*N0*pow(10.0,alpha*(mag-Mcut));

      // accounting for the percentage triggered within the LL-space:
      dmag *= spaceweightall[indlargest][i]; 

      dmag *= norm *(p-1.0) * pow(c,p-1.0) / pow(c+t[i]-time,p);
    }
    else dmag = 0.0;

    ff  += log(lambda);
    dff += dmag/lambda;
  }
 

  // loop over completeness periods
  timesum=0.0;
  for(k=1;k<=NK;k++){
    TT1 = tc[1][k];
    TT2 = tc[2][k];
    timesum += TT2-TT1;
  }

  dft = 0.0;
  ft  = mu*timesum;

  for(i=1;i<=Zall;i++) if(tall[i]<T2){

    mag = mall[i];
    if(i==indlargest) mag += dmagindlargest;

    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
      else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
    }
    else             Na = N0 * pow(10.0,alpha*(mag-Mcut));
    
    Xi = calculate_timeintegral(i,Na,c,p,&dc,&dp);

    ft  += Xi;  

    //printf("j=%d  mag=%lf  Na=%lf  Xi=%lf  ft=%lf\n",i,mag,Na,Xi,ft);
    if(i==indlargest){
      mag = mall[indlargest] + dmagindlargest;
      if(setRETAS==1){
	if(mag<=Mstar) dft = Xi * log(10.0)*1.5;
	else           dft = Xi * log(10.0)*alpha0;
      }
      else             dft = Xi * log(10.0)*alpha;
    }
  }

  *f  = ff-ft;
  *df = dff - dft;
}



void LogLike_nospace_magoptimization(int indlargest, double mu, double c, double p, double M0, double N0, double alpha, double *mag){
  double  dmag, dmag0, ddmag, LL, LL0, dLL, dLLmin;
  int     i, setgo;

  dmag = 0.0;
  LLvalue_nospace(indlargest,dmag,mu,c,p,M0,N0,alpha,&LL,&dLL);

  ddmag = 0.01*dLL/fabs(dLL);
 
  setgo=1;
  while(setgo==1){
    dmag0 = dmag + ddmag;
    LLvalue_nospace(indlargest,dmag0,mu,c,p,M0,N0,alpha,&LL0,&dLL);  
    //printf(".... dmag0=%lf --> LL=%lf  dLL=%lf\n",dmag0,LL0,dLL);
    if(LL0>LL){ LL=LL0; dmag=dmag0; if(fabs(dLL)<0.1) setgo=0; }
    else setgo=0;
  }
  //printf("indlargest=%d  mall=%lf  dmag=%lf",indlargest,mall[indlargest],dmag);
  mall[indlargest]+=dmag;
  //printf(" --> mall_new =%lf\n",mall[indlargest]);

  *mag = mall[indlargest];

}

