double Mmaxvalue(double M0){
  double  dum, res;

  // <M0> = M0min*(b/(1.5-b))*(pow(10.0, (1.5-b)*(Mmax-Mmin))-1.0) / (1-pow(10.0,-b*(Mmax-Mmin)))   [Nm]=[Pa m3]
  
  dum  = M0/pow(10.0,1.5*Mmin);
  dum /= bvalue/(1.5-bvalue);
  dum += 1.0;
  
  res  = log10(dum)/(1.5-bvalue);
  res += Mmin;

  return res;
}

void considerMbelowMcuttriggering(double M0, double *fac){
  double nbranch, C;

  // for each (triggered) event above Mcut will have on average 10^(b*(mcut-m)) corresponding (events) events with m<Mcut. 
  // Each of this events will trigger again Na(m) events above Mcut.
  // In total: n=Integral_{Mmin}^{Mcut} 10^(b*(Mcut-m)) * Na(m) dm  events will be additionally triggered above Mcut by triggered events below Mcut:

  // fac = 1.0/(1-n)

  // Estimated M0-value = M0_true/fac  --> M0_true = M0*fac

  C = 2.0*pow(10.0,bvalue*(Mmin-Mcut));   
  nbranch = (1.0-pow(10.0,(bvalue-1.5)*(Mcut-Mmin)))*C*pow(10.0,1.5*Mcut)/(M0*log(10.0)*(1.5-bvalue));  
  *fac = 1.0/(1.0 - nbranch);
}
