
int readinputfile(char *input_fname, char *outname, char *crust_file, char *fore_template,
		   char *catname, char *background_rate_file, char *slipmodelfile, double *T2, double *T){
  
  /* input: file name input_fname
   *
   * output:
   * 		outname: output file
   * 		T2, T: start and length of forecast period in days
   * 		crust_file: input file for farfalle code (general file with info about the crust etc).
   * 		fore_template: forecast template
   * 		catname: catalog
   * 		background_rate_file: file containing background seismicity model
   * 		slipmodefile: file containing a list of slip models 
   *
   * NB: all pointers will be ignored if NULL is passed; otherwise, char* should already be initialized.
   */
  
  FILE *fin;
  int  Nchar=200;
  char line[Nchar];
  char *key, *value;
  int  NP=8, i;
  
  char *keys[]={
    /*0*/	"ForecastStartDate",	\
    /*1*/	"ForecastEndDate",	\
    /*2*/	"OutputForecastFile",	\
    /*3*/	"InputCatalogFile",		\
    /*4*/	"ForecastTemplate",		\
    /*5*/	"InputCoulombFile",		\
    /*6*/	"InputListSlipModels",		\
    /*7*/	"InputBackgroundRateFile"
  };
  
  
  if((fin = fopen(input_fname, "r"))==NULL) {
    fprintf(stderr, "Error read_input: unable to open input file %s.\n", input_fname);
    return 1;
  }
  
  while(!feof(fin)) {
    fgets(line,Nchar,fin);
    if (ferror(fin)) {
      printf("Error reading input data using fgets!\n");
      return 1;
    }
    
    key=strtok(line,"=");
    value=strtok(NULL,"=");
    i=0;
    while (i<NP && strcmp(key,keys[i])) i++;
    if (i>=NP){
      fprintf(stderr, "Warning read_input: parameter \" %s\" in file \"%s\" not recognized.\n", value, input_fname);
      continue;
    }
    
    switch(i){
    case 0:
      sscanf(value, "%d-%d-%dT%d:%d:%dZ", &yy, &mm, &dd, &hh, &min, &sec);
      calculatejulday(yy,mm,dd,hh,min,sec,&tstart);
      *T2=tstart;
      break;
    case 1:
      sscanf(value, "%d-%d-%dT%d:%d:%dZ", &yy, &mm, &dd, &hh, &min, &sec);
      calculatejulday(yy,mm,dd,hh,min,sec,&tend);
      *T=tend-tstart;
      break;
    case 2:
      if (outname) sscanf(value,"%s",outname);
      break;
    case 3:
      if (catname) sscanf(value,"%s",catname);
      break;
    case 4:
      if (fore_template) sscanf(value,"%s",fore_template);
      break;
    case 5:
      if (crust_file) sscanf(value,"%s",crust_file);
      break;
    case 6:
      if (slipmodelfile) sscanf(value,"%s",slipmodelfile);
      break;
    case 7:
      if (background_rate_file) sscanf(value,"%s",background_rate_file);
      break;
    }
  }
  
  fclose(fin);
  return 0;
  
}
